/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressAnimationItem
extends AnimationItem
implements FinishedJobs.KeptJobsListener {
    ProgressBar bar;
    MouseListener mouseListener;
    Composite top;
    ToolBar toolbar;
    ToolItem toolButton;
    ProgressRegion progressRegion;
    Image noneImage;
    Image okImage;
    Image errorImage;
    boolean animationRunning;
    private int flags;

    ProgressAnimationItem(ProgressRegion progressRegion, int n) {
        super(progressRegion.workbenchWindow);
        this.flags = n;
        FinishedJobs.getInstance().addListener(this);
        this.progressRegion = progressRegion;
        this.mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ProgressAnimationItem.this.doAction();
            }
        };
    }

    void doAction() {
        JobTreeElement[] jobTreeElementArray = FinishedJobs.getInstance().getKeptElements();
        int n = jobTreeElementArray.length - 1;
        while (n >= 0) {
            Job job;
            JobInfo jobInfo;
            if (jobTreeElementArray[n] instanceof JobInfo && !(jobInfo = (JobInfo)jobTreeElementArray[n]).isReported() && (job = jobInfo.getJob()) != null) {
                IStatus iStatus = job.getResult();
                if (iStatus != null && iStatus.getSeverity() == 4) {
                    StatusAdapter statusAdapter = StatusAdapterHelper.getInstance().getStatusAdapter(jobInfo);
                    if (statusAdapter == null) {
                        statusAdapter = new StatusAdapter(iStatus);
                    }
                    StatusManager.getManager().handle(statusAdapter, 2);
                    if (FinishedJobs.keep(jobInfo)) {
                        jobInfo.setReported(true);
                    } else {
                        this.removeTopElement(jobInfo);
                    }
                }
                if (this.execute(jobInfo, job)) {
                    return;
                }
            }
            --n;
        }
        this.progressRegion.processDoubleClick();
        this.refresh();
    }

    private boolean execute(JobInfo jobInfo, Job job) {
        Object object = job.getProperty(IProgressConstants2.ACTION_PROPERTY);
        if (object instanceof IAction && ((IAction)object).isEnabled()) {
            IAction iAction = (IAction)object;
            iAction.run();
            this.removeTopElement(jobInfo);
            return true;
        }
        object = job.getProperty(IProgressConstants2.COMMAND_PROPERTY);
        if (object instanceof ParameterizedCommand) {
            ParameterizedCommand parameterizedCommand = (ParameterizedCommand)object;
            WorkbenchWindow workbenchWindow = this.getWindow();
            IHandlerService iHandlerService = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
            Throwable throwable = null;
            try {
                iHandlerService.executeCommand(parameterizedCommand, null);
                this.removeTopElement(jobInfo);
            }
            catch (ExecutionException executionException) {
                throwable = executionException;
            }
            catch (NotDefinedException notDefinedException) {
                throwable = notDefinedException;
            }
            catch (NotEnabledException notEnabledException) {
                throwable = notEnabledException;
            }
            catch (NotHandledException notHandledException) {
                throwable = notHandledException;
            }
            if (throwable != null) {
                Status status = new Status(4, "org.eclipse.ui", throwable.getMessage(), throwable);
                StatusManager.getManager().handle((IStatus)status, 3);
            }
            return true;
        }
        return false;
    }

    private void removeTopElement(JobInfo jobInfo) {
        JobTreeElement jobTreeElement = (JobTreeElement)jobInfo.getParent();
        if (jobTreeElement == null) {
            jobTreeElement = jobInfo;
        }
        FinishedJobs.getInstance().remove(jobTreeElement);
    }

    private IAction getAction(Job job) {
        Object object = job.getProperty(IProgressConstants2.ACTION_PROPERTY);
        if (object instanceof IAction) {
            return (IAction)object;
        }
        return null;
    }

    private void refresh() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        JobTreeElement[] jobTreeElementArray = FinishedJobs.getInstance().getKeptElements();
        int n = jobTreeElementArray.length - 1;
        while (n >= 0) {
            JobInfo jobInfo;
            Job job;
            if (jobTreeElementArray[n] instanceof JobInfo && (job = (jobInfo = (JobInfo)jobTreeElementArray[n]).getJob()) != null && !jobInfo.isReported()) {
                IStatus iStatus = job.getResult();
                if (iStatus != null && iStatus.getSeverity() == 4) {
                    this.initButton(this.errorImage, NLS.bind((String)ProgressMessages.ProgressAnimationItem_error, (Object)job.getName()));
                    return;
                }
                IAction iAction = this.getAction(job);
                if (iAction != null && iAction.isEnabled()) {
                    String string = iAction.getToolTipText();
                    if (string == null || string.trim().length() == 0) {
                        string = NLS.bind((String)ProgressMessages.ProgressAnimationItem_ok, (Object)job.getName());
                    }
                    this.initButton(this.okImage, string);
                    return;
                }
                this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
                return;
            }
            --n;
        }
        if (this.animationRunning) {
            this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
            return;
        }
        this.toolbar.setVisible(false);
    }

    private void initButton(Image image, final String string) {
        this.toolButton.setImage(image);
        this.toolButton.setToolTipText(string);
        this.toolbar.setVisible(true);
        this.toolbar.getParent().layout();
        this.toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = string;
            }
        });
    }

    @Override
    protected Control createAnimationItem(Composite composite) {
        GridData gridData;
        if (this.okImage == null) {
            Display display = composite.getDisplay();
            this.noneImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_none.gif").createImage((Device)display);
            this.okImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_ok.gif").createImage((Device)display);
            this.errorImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_error.gif").createImage((Device)display);
        }
        this.top = new Composite(composite, 0);
        this.top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FinishedJobs.getInstance().removeListener(ProgressAnimationItem.this);
                ProgressAnimationItem.this.noneImage.dispose();
                ProgressAnimationItem.this.okImage.dispose();
                ProgressAnimationItem.this.errorImage.dispose();
            }
        });
        boolean bl = Util.isMac();
        GridLayout gridLayout = new GridLayout();
        if (this.isHorizontal()) {
            gridLayout.numColumns = bl ? 3 : 2;
        }
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        if (this.isHorizontal()) {
            gridLayout.horizontalSpacing = 2;
        } else {
            gridLayout.verticalSpacing = 2;
        }
        this.top.setLayout((Layout)gridLayout);
        this.bar = new ProgressBar(this.top, this.flags | 2);
        this.bar.setVisible(false);
        this.bar.addMouseListener(this.mouseListener);
        int n = 12;
        if (this.isHorizontal()) {
            gridData = new GridData(1, 0x1000000, true, false);
            gridData.heightHint = n;
        } else {
            gridData = new GridData(0x1000000, 1, false, true);
            gridData.widthHint = n;
        }
        this.bar.setLayoutData((Object)gridData);
        this.toolbar = new ToolBar(this.top, 0x800000);
        this.toolbar.setVisible(false);
        this.toolButton = new ToolItem(this.toolbar, 0);
        this.toolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressAnimationItem.this.doAction();
            }
        });
        if (bl) {
            new Label(this.top, 0).setLayoutData((Object)new GridData(4, 4));
        }
        this.refresh();
        return this.top;
    }

    private boolean isHorizontal() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public Control getControl() {
        return this.top;
    }

    @Override
    void animationDone() {
        super.animationDone();
        this.animationRunning = false;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(false);
        this.refresh();
    }

    public boolean animationRunning() {
        return this.animationRunning;
    }

    @Override
    void animationStart() {
        super.animationStart();
        this.animationRunning = true;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(true);
        this.refresh();
    }

    @Override
    public void removed(JobTreeElement jobTreeElement) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressAnimationItem.this.refresh();
            }
        });
    }

    @Override
    public void finished(JobTreeElement jobTreeElement) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressAnimationItem.this.refresh();
            }
        });
    }
}

