/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;

public class JobInfo
extends JobTreeElement {
    private IStatus blockedStatus;
    private volatile boolean canceled = false;
    private volatile boolean reported = false;
    private List children = Collections.synchronizedList(new ArrayList());
    private Job job;
    private GroupInfo parent;
    private TaskInfo taskInfo;
    private int ticks = -1;

    protected JobInfo(Job job) {
        this.job = job;
    }

    void addSubTask(String string) {
        this.children.add(new SubTaskInfo(this, string));
    }

    void addWork(double d) {
        if (this.taskInfo == null) {
            return;
        }
        if (this.parent == null || this.ticks < 1) {
            this.taskInfo.addWork(d);
        } else {
            this.taskInfo.addWork(d, this.parent, this.ticks);
        }
    }

    void beginTask(String string, int n) {
        this.taskInfo = new TaskInfo(this, string, n);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.job.cancel();
        ProgressManager.getInstance().refreshJobInfo(this);
    }

    void clearChildren() {
        this.children.clear();
    }

    void clearTaskInfo() {
        FinishedJobs.getInstance().remove(this.taskInfo);
        this.taskInfo = null;
    }

    private int compareJobs(JobInfo jobInfo) {
        int n;
        int n2;
        Job job = jobInfo.getJob();
        if (this.job.isUser()) {
            if (!job.isUser()) {
                return -1;
            }
        } else if (job.isUser()) {
            return 1;
        }
        if (this.isBlocked()) {
            if (!jobInfo.isBlocked()) {
                return 1;
            }
        } else if (jobInfo.isBlocked()) {
            return -1;
        }
        if ((n2 = this.job.getPriority()) == (n = job.getPriority())) {
            return this.job.getName().compareTo(job.getName());
        }
        if (n2 > n) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Object object) {
        int n;
        if (!(object instanceof JobInfo)) {
            return super.compareTo(object);
        }
        JobInfo jobInfo = (JobInfo)object;
        boolean bl = this.isCanceled();
        boolean bl2 = jobInfo.isCanceled();
        if (bl && !bl2) {
            return 1;
        }
        if (!bl && bl2) {
            return -1;
        }
        int n2 = this.getJob().getState();
        if (n2 == (n = jobInfo.getJob().getState())) {
            return this.compareJobs(jobInfo);
        }
        return n2 > n ? -1 : (n2 == n ? 0 : 1);
    }

    void dispose() {
        if (this.parent != null) {
            this.parent.removeJobInfo(this);
        }
    }

    public IStatus getBlockedStatus() {
        return this.blockedStatus;
    }

    @Override
    Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    String getCondensedDisplayString() {
        TaskInfo taskInfo = this.getTaskInfo();
        if (taskInfo != null) {
            return taskInfo.getDisplayStringWithoutTask(true);
        }
        return this.getJob().getName();
    }

    @Override
    public Image getDisplayImage() {
        int n = this.getPercentDone();
        if (n > 0) {
            return super.getDisplayImage();
        }
        if (this.isBlocked()) {
            return JFaceResources.getImage((String)"LOCKED_JOB");
        }
        int n2 = this.getJob().getState();
        if (n2 == 1) {
            return JFaceResources.getImage((String)"SLEEPING_JOB");
        }
        if (n2 == 2) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        return super.getDisplayImage();
    }

    @Override
    String getDisplayString() {
        return this.getDisplayString(true);
    }

    @Override
    String getDisplayString(boolean bl) {
        String string = this.getDisplayStringWithStatus(bl);
        if (this.job.isSystem()) {
            return NLS.bind((String)ProgressMessages.JobInfo_System, (Object[])new Object[]{string});
        }
        return string;
    }

    private String getDisplayStringWithStatus(boolean bl) {
        if (this.isCanceled()) {
            return NLS.bind((String)ProgressMessages.JobInfo_Cancelled, (Object[])new Object[]{this.getJob().getName()});
        }
        if (this.isBlocked()) {
            return NLS.bind((String)ProgressMessages.JobInfo_Blocked, (Object[])new Object[]{this.getJob().getName(), this.blockedStatus.getMessage()});
        }
        if (this.getJob().getState() == 4) {
            TaskInfo taskInfo = this.getTaskInfo();
            if (taskInfo == null) {
                return this.getJob().getName();
            }
            return taskInfo.getDisplayString(bl);
        }
        if (this.getJob().getState() == 1) {
            return NLS.bind((String)ProgressMessages.JobInfo_Sleeping, (Object[])new Object[]{this.getJob().getName()});
        }
        return NLS.bind((String)ProgressMessages.JobInfo_Waiting, (Object[])new Object[]{this.getJob().getName()});
    }

    GroupInfo getGroupInfo() {
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    int getPercentDone() {
        TaskInfo taskInfo = this.getTaskInfo();
        if (taskInfo != null) {
            if (taskInfo.totalWork == -1) {
                return -1;
            }
            if (taskInfo.totalWork == 0) {
                return 0;
            }
            return (int)taskInfo.preWork * 100 / taskInfo.totalWork;
        }
        return -1;
    }

    TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    boolean hasChildren() {
        return this.children.size() > 0;
    }

    boolean hasTaskInfo() {
        return this.taskInfo != null;
    }

    @Override
    boolean isActive() {
        return this.getJob().getState() != 0;
    }

    boolean isReported() {
        return this.reported;
    }

    void setReported(boolean bl) {
        this.reported = bl;
    }

    public boolean isBlocked() {
        return this.getBlockedStatus() != null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isCancellable() {
        return super.isCancellable();
    }

    @Override
    boolean isJobInfo() {
        return true;
    }

    public void setBlockedStatus(IStatus iStatus) {
        this.blockedStatus = iStatus;
    }

    void setGroupInfo(GroupInfo groupInfo) {
        this.parent = groupInfo;
    }

    void setTaskName(String string) {
        this.taskInfo.setTaskName(string);
    }

    public void setTicks(int n) {
        this.ticks = n;
    }
}

