/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;

class GroupInfo
extends JobTreeElement
implements IProgressMonitor {
    private List infos = new ArrayList();
    private Object lock = new Object();
    private String taskName = ProgressMessages.SubTaskInfo_UndefinedTaskName;
    boolean isActive = false;
    double total = -1.0;
    double currentWork;

    GroupInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean hasChildren() {
        Object object = this.lock;
        synchronized (object) {
            return !this.infos.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object[] getChildren() {
        Object object = this.lock;
        synchronized (object) {
            return this.infos.toArray();
        }
    }

    @Override
    String getDisplayString() {
        if (this.total < 0.0) {
            return this.taskName;
        }
        Object[] objectArray = new String[]{this.taskName, String.valueOf(this.getPercentDone())};
        return NLS.bind((String)ProgressMessages.JobInfo_NoTaskNameDoneMessage, (Object[])objectArray);
    }

    int getPercentDone() {
        return (int)(this.currentWork * 100.0 / this.total);
    }

    @Override
    boolean isJobInfo() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(String string, int n) {
        if (string == null) {
            string = ProgressMessages.SubTaskInfo_UndefinedTaskName;
        } else {
            this.taskName = string;
        }
        this.total = n;
        Object object = this.lock;
        synchronized (object) {
            this.isActive = true;
        }
        ProgressManager.getInstance().refreshGroup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = this.lock;
        synchronized (object) {
            this.isActive = false;
        }
        this.updateInProgressManager();
    }

    private void updateInProgressManager() {
        for (JobInfo jobInfo : this.infos) {
            if (jobInfo.getJob().getState() == 0) continue;
            ProgressManager.getInstance().refreshGroup(this);
            return;
        }
        if (FinishedJobs.getInstance().isKept(this)) {
            ProgressManager.getInstance().refreshGroup(this);
        } else {
            ProgressManager.getInstance().removeGroup(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalWorked(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.currentWork += d;
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean bl) {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(String string) {
        GroupInfo groupInfo = this;
        synchronized (groupInfo) {
            this.isActive = true;
        }
        this.taskName = string == null ? ProgressMessages.SubTaskInfo_UndefinedTaskName : string;
    }

    public void subTask(String string) {
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeJobInfo(JobInfo jobInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.infos.remove(jobInfo);
            if (this.infos.isEmpty()) {
                this.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJobInfo(JobInfo jobInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.infos.add(jobInfo);
        }
    }

    @Override
    boolean isActive() {
        return this.isActive;
    }

    @Override
    public void cancel() {
        Object[] objectArray = this.getChildren();
        int n = 0;
        while (n < objectArray.length) {
            ((JobInfo)objectArray[n]).cancel();
            ++n;
        }
        this.updateInProgressManager();
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    String getTaskName() {
        return this.taskName;
    }
}

