/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;

public class FinishedJobs
extends EventManager {
    private static FinishedJobs theInstance;
    private IJobProgressManagerListener listener;
    private HashSet keptjobinfos = new HashSet();
    private HashMap finishedTime = new HashMap();
    private static JobTreeElement[] EMPTY_INFOS;

    public static synchronized FinishedJobs getInstance() {
        if (theInstance == null) {
            theInstance = new FinishedJobs();
            EMPTY_INFOS = new JobTreeElement[0];
        }
        return theInstance;
    }

    private FinishedJobs() {
        this.listener = new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo jobInfo) {
                FinishedJobs.this.checkForDuplicates(jobInfo);
            }

            @Override
            public void addGroup(GroupInfo groupInfo) {
                FinishedJobs.this.checkForDuplicates(groupInfo);
            }

            @Override
            public void refreshJobInfo(JobInfo jobInfo) {
                FinishedJobs.this.checkTasks(jobInfo);
            }

            @Override
            public void refreshGroup(GroupInfo groupInfo) {
            }

            @Override
            public void refreshAll() {
            }

            @Override
            public void removeJob(JobInfo jobInfo) {
                if (FinishedJobs.keep(jobInfo)) {
                    FinishedJobs.this.checkForDuplicates(jobInfo);
                    FinishedJobs.this.add(jobInfo);
                }
            }

            @Override
            public void removeGroup(GroupInfo groupInfo) {
            }

            @Override
            public boolean showsDebug() {
                return false;
            }
        };
        ProgressManager.getInstance().addListener(this.listener);
    }

    static boolean keep(JobInfo jobInfo) {
        Job job = jobInfo.getJob();
        if (job != null) {
            if (FinishedJobs.hasKeepFlag(job)) {
                return true;
            }
            IStatus iStatus = job.getResult();
            if (iStatus != null && iStatus.getSeverity() == 4) {
                return true;
            }
        }
        return false;
    }

    static boolean hasKeepFlag(Job job) {
        Object object = job.getProperty(ProgressManagerUtil.KEEP_PROPERTY);
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            return true;
        }
        object = job.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY);
        return object instanceof Boolean && (Boolean)object != false;
    }

    void addListener(KeptJobsListener keptJobsListener) {
        this.addListenerObject(keptJobsListener);
    }

    void removeListener(KeptJobsListener keptJobsListener) {
        this.removeListenerObject(keptJobsListener);
    }

    private void checkForDuplicates(GroupInfo groupInfo) {
        Object[] objectArray = groupInfo.getChildren();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof JobInfo) {
                this.checkForDuplicates((JobInfo)objectArray[n]);
            }
            ++n;
        }
    }

    private void checkForDuplicates(JobTreeElement jobTreeElement) {
        JobTreeElement[] jobTreeElementArray = this.findJobsToRemove(jobTreeElement);
        if (jobTreeElementArray != null) {
            int n = 0;
            while (n < jobTreeElementArray.length) {
                this.remove(jobTreeElementArray[n]);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(JobInfo jobInfo) {
        boolean bl = false;
        Object[] objectArray = this.keptjobinfos;
        synchronized (this.keptjobinfos) {
            if (!this.keptjobinfos.contains(jobInfo)) {
                this.keptjobinfos.add(jobInfo);
                long l = System.currentTimeMillis();
                this.finishedTime.put(jobInfo, new Long(l));
                Object object = jobInfo.getParent();
                if (object != null && !this.keptjobinfos.contains(object)) {
                    this.keptjobinfos.add(object);
                    this.finishedTime.put(object, new Long(l));
                }
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                objectArray = this.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    KeptJobsListener keptJobsListener = (KeptJobsListener)objectArray[n];
                    keptJobsListener.finished(jobInfo);
                    ++n;
                }
            }
            return;
        }
    }

    static void disposeAction(JobTreeElement jobTreeElement) {
        Object object;
        JobInfo jobInfo;
        Job job;
        if (jobTreeElement.isJobInfo() && (job = (jobInfo = (JobInfo)jobTreeElement).getJob()) != null && (object = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof ActionFactory.IWorkbenchAction) {
            ((ActionFactory.IWorkbenchAction)object).dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobTreeElement[] findJobsToRemove(JobTreeElement jobTreeElement) {
        Object object;
        Job job;
        if (jobTreeElement.isJobInfo() && (job = ((JobInfo)jobTreeElement).getJob()) != null && (object = job.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY)) instanceof Boolean && ((Boolean)object).booleanValue()) {
            JobTreeElement[] jobTreeElementArray;
            ArrayList<JobTreeElement> arrayList = null;
            HashSet hashSet = this.keptjobinfos;
            synchronized (hashSet) {
                jobTreeElementArray = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            }
            int n = 0;
            while (n < jobTreeElementArray.length) {
                Job job2;
                JobTreeElement jobTreeElement2 = jobTreeElementArray[n];
                if (jobTreeElement2 != jobTreeElement && jobTreeElement2.isJobInfo() && (job2 = ((JobInfo)jobTreeElement2).getJob()) != null && job2 != job && job2.belongsTo((Object)job)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<JobTreeElement>();
                    }
                    arrayList.add(jobTreeElement2);
                }
                ++n;
            }
            if (arrayList != null) {
                return arrayList.toArray(new JobTreeElement[arrayList.size()]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTasks(JobInfo jobInfo) {
        TaskInfo taskInfo;
        if (FinishedJobs.keep(jobInfo) && (taskInfo = jobInfo.getTaskInfo()) != null) {
            JobTreeElement[] jobTreeElementArray = null;
            boolean bl = false;
            JobTreeElement jobTreeElement = (JobTreeElement)taskInfo.getParent();
            HashSet hashSet = this.keptjobinfos;
            synchronized (hashSet) {
                if (jobTreeElement == jobInfo && !this.keptjobinfos.contains(taskInfo)) {
                    jobTreeElementArray = this.findJobsToRemove(jobTreeElement);
                    this.keptjobinfos.add(taskInfo);
                    this.finishedTime.put(taskInfo, new Long(System.currentTimeMillis()));
                }
            }
            if (jobTreeElementArray != null) {
                int n = 0;
                while (n < jobTreeElementArray.length) {
                    this.remove(jobTreeElementArray[n]);
                    ++n;
                }
            }
            if (bl) {
                Object[] objectArray = this.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    KeptJobsListener keptJobsListener = (KeptJobsListener)objectArray[n];
                    keptJobsListener.finished(jobInfo);
                    ++n;
                }
            }
        }
    }

    public void removeErrorJobs() {
        JobTreeElement[] jobTreeElementArray = this.getKeptElements();
        int n = 0;
        while (n < jobTreeElementArray.length) {
            JobInfo jobInfo;
            Job job;
            if (jobTreeElementArray[n].isJobInfo() && (job = (jobInfo = (JobInfo)jobTreeElementArray[n]).getJob()) != null) {
                Object[] objectArray;
                if (FinishedJobs.hasKeepFlag(job)) {
                    jobInfo.setReported(true);
                    objectArray = this.getListeners();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        KeptJobsListener keptJobsListener = (KeptJobsListener)objectArray[n2];
                        keptJobsListener.removed(null);
                        ++n2;
                    }
                } else {
                    objectArray = job.getResult();
                    if (objectArray != null && objectArray.getSeverity() == 4) {
                        JobTreeElement jobTreeElement = (JobTreeElement)jobInfo.getParent();
                        if (jobTreeElement == null) {
                            jobTreeElement = jobInfo;
                        }
                        FinishedJobs.getInstance().remove(jobTreeElement);
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(JobTreeElement jobTreeElement) {
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = this.keptjobinfos;
        synchronized (this.keptjobinfos) {
            if (this.keptjobinfos.remove(jobTreeElement)) {
                bl2 = true;
                this.finishedTime.remove(jobTreeElement);
                FinishedJobs.disposeAction(jobTreeElement);
                JobTreeElement[] jobTreeElementArray = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
                int n = 0;
                while (n < jobTreeElementArray.length) {
                    JobTreeElement jobTreeElement2 = (JobTreeElement)jobTreeElementArray[n].getParent();
                    if (jobTreeElement2 != null && (jobTreeElement2 == jobTreeElement || jobTreeElement2.getParent() == jobTreeElement)) {
                        if (this.keptjobinfos.remove(jobTreeElementArray[n])) {
                            FinishedJobs.disposeAction(jobTreeElementArray[n]);
                        }
                        this.finishedTime.remove(jobTreeElementArray[n]);
                    }
                    ++n;
                }
                bl = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                objectArray = this.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    KeptJobsListener keptJobsListener = (KeptJobsListener)objectArray[n];
                    keptJobsListener.removed(jobTreeElement);
                    ++n;
                }
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTreeElement[] getKeptElements() {
        JobTreeElement[] jobTreeElementArray;
        if (this.keptjobinfos.isEmpty()) {
            return EMPTY_INFOS;
        }
        HashSet hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            jobTreeElementArray = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
        }
        return jobTreeElementArray;
    }

    public Date getFinishDate(JobTreeElement jobTreeElement) {
        Object v = this.finishedTime.get(jobTreeElement);
        if (v instanceof Long) {
            return new Date((Long)v);
        }
        return null;
    }

    public boolean isKept(JobTreeElement jobTreeElement) {
        return this.keptjobinfos.contains(jobTreeElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object[] objectArray = this.keptjobinfos;
        synchronized (this.keptjobinfos) {
            JobTreeElement[] jobTreeElementArray = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            int n = 0;
            while (n < jobTreeElementArray.length) {
                FinishedJobs.disposeAction(jobTreeElementArray[n]);
                ++n;
            }
            this.keptjobinfos.clear();
            this.finishedTime.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            objectArray = this.getListeners();
            int n2 = 0;
            while (n2 < objectArray.length) {
                KeptJobsListener keptJobsListener = (KeptJobsListener)objectArray[n2];
                keptJobsListener.removed(null);
                ++n2;
            }
            return;
        }
    }

    Set getKeptAsSet() {
        return this.keptjobinfos;
    }

    static interface KeptJobsListener {
        public void finished(JobTreeElement var1);

        public void removed(JobTreeElement var1);
    }
}

