/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressInfoItem;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class DetailedProgressViewer
extends AbstractProgressViewer {
    private static final int MAX_DISPLAYED = 20;
    Composite control;
    private ScrolledComposite scrolled;
    private Composite noEntryArea;

    public DetailedProgressViewer(Composite composite, int n) {
        this.scrolled = new ScrolledComposite(composite, 0x200 | n);
        int n2 = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        this.scrolled.getVerticalBar().setIncrement(n2 * 2);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.control = new Composite((Composite)this.scrolled, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.control.setLayout((Layout)gridLayout);
        this.control.setBackground(composite.getDisplay().getSystemColor(25));
        this.control.addFocusListener((FocusListener)new FocusAdapter(){
            private boolean settingFocus = false;

            public void focusGained(FocusEvent focusEvent) {
                if (!this.settingFocus) {
                    this.settingFocus = true;
                    DetailedProgressViewer.this.setFocus();
                    this.settingFocus = false;
                }
            }
        });
        this.control.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                DetailedProgressViewer.this.updateVisibleItems();
            }

            public void controlResized(ControlEvent controlEvent) {
                DetailedProgressViewer.this.updateVisibleItems();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.control, "org.eclipse.ui.responsive_ui_context");
        this.scrolled.setContent((Control)this.control);
        this.hookControl((Control)this.control);
        this.noEntryArea = new Composite((Composite)this.scrolled, 0);
        this.noEntryArea.setLayout((Layout)new GridLayout());
        Text text = new Text(this.noEntryArea, 4);
        text.setText(ProgressMessages.ProgressView_NoOperations);
        text.setBackground(this.noEntryArea.getDisplay().getSystemColor(22));
        GridData gridData = new GridData(2);
        text.setLayoutData((Object)gridData);
        text.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, "org.eclipse.ui.responsive_ui_context");
    }

    @Override
    public void add(Object[] objectArray) {
        ViewerComparator viewerComparator = this.getComparator();
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
        Control[] controlArray = this.control.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n].getData() != null) {
                hashSet.add(controlArray[n].getData());
            }
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                hashSet.add(objectArray[n]);
            }
            ++n;
        }
        Object[] objectArray2 = new JobTreeElement[hashSet.size()];
        hashSet.toArray(objectArray2);
        if (viewerComparator != null) {
            viewerComparator.sort((Viewer)this, objectArray2);
        }
        int n2 = 0;
        while (n2 < controlArray.length) {
            ((ProgressInfoItem)controlArray[n2]).dispose();
            ++n2;
        }
        n2 = Math.min(hashSet.size(), 20);
        int n3 = 0;
        while (n3 < n2) {
            ProgressInfoItem progressInfoItem = this.createNewItem((JobTreeElement)objectArray2[n3]);
            progressInfoItem.setColor(n3);
            ++n3;
        }
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    private void updateForShowingProgress() {
        if (this.control.getChildren().length > 0) {
            this.scrolled.setContent((Control)this.control);
        } else {
            this.scrolled.setContent((Control)this.noEntryArea);
        }
    }

    private ProgressInfoItem createNewItem(JobTreeElement jobTreeElement) {
        final ProgressInfoItem progressInfoItem = new ProgressInfoItem(this.control, 0, jobTreeElement);
        progressInfoItem.setIndexListener(new ProgressInfoItem.IndexListener(){

            @Override
            public void selectNext() {
                DetailedProgressViewer.this.selectNext(progressInfoItem);
            }

            @Override
            public void selectPrevious() {
                DetailedProgressViewer.this.selectPrevious(progressInfoItem);
            }

            @Override
            public void select() {
                Control[] controlArray = DetailedProgressViewer.this.control.getChildren();
                int n = 0;
                while (n < controlArray.length) {
                    ProgressInfoItem progressInfoItem2 = (ProgressInfoItem)controlArray[n];
                    if (!((Object)((Object)progressInfoItem)).equals((Object)progressInfoItem2)) {
                        progressInfoItem2.selectWidgets(false);
                    }
                    ++n;
                }
                progressInfoItem.selectWidgets(true);
            }
        });
        progressInfoItem.refresh();
        return progressInfoItem;
    }

    protected void selectPrevious(ProgressInfoItem progressInfoItem) {
        Control[] controlArray = this.control.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            ProgressInfoItem progressInfoItem2 = (ProgressInfoItem)controlArray[n];
            if (((Object)((Object)progressInfoItem)).equals((Object)progressInfoItem2)) {
                ProgressInfoItem progressInfoItem3 = n == 0 ? (ProgressInfoItem)controlArray[controlArray.length - 1] : (ProgressInfoItem)controlArray[n - 1];
                progressInfoItem.selectWidgets(false);
                progressInfoItem3.selectWidgets(true);
                return;
            }
            ++n;
        }
    }

    protected void selectNext(ProgressInfoItem progressInfoItem) {
        Control[] controlArray = this.control.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            ProgressInfoItem progressInfoItem2 = (ProgressInfoItem)controlArray[n];
            if (((Object)((Object)progressInfoItem)).equals((Object)progressInfoItem2)) {
                ProgressInfoItem progressInfoItem3 = n == controlArray.length - 1 ? (ProgressInfoItem)controlArray[0] : (ProgressInfoItem)controlArray[n + 1];
                progressInfoItem.selectWidgets(false);
                progressInfoItem3.selectWidgets(true);
                return;
            }
            ++n;
        }
    }

    protected Widget doFindInputItem(Object object) {
        return null;
    }

    protected Widget doFindItem(Object object) {
        Control[] controlArray = this.control.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (!controlArray[n].isDisposed() && controlArray[n].getData() != null && controlArray[n].getData().equals(object)) {
                return controlArray[n];
            }
            ++n;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        if (this.usingElementMap()) {
            this.unmapElement(widget);
        }
        widget.dispose();
        this.add(new Object[]{object});
    }

    public Control getControl() {
        return this.scrolled;
    }

    protected List getSelectionFromWidget() {
        return new ArrayList(0);
    }

    protected void inputChanged(Object object, Object object2) {
        super.inputChanged(object, object2);
        this.refreshAll();
        this.updateForShowingProgress();
    }

    protected void internalRefresh(Object object) {
        if (object == null) {
            return;
        }
        if (object.equals(this.getRoot())) {
            this.refreshAll();
            return;
        }
        Widget widget = this.findItem(object);
        if (widget == null) {
            this.add(new Object[]{object});
            return;
        }
        ((ProgressInfoItem)widget).refresh();
        Point point = this.control.computeSize(-1, -1);
        point.x += 4;
        point.y += 4;
        this.scrolled.setMinSize(point);
    }

    @Override
    public void remove(Object[] objectArray) {
        Object object;
        int n = 0;
        while (n < objectArray.length) {
            JobTreeElement jobTreeElement = (JobTreeElement)objectArray[n];
            if (FinishedJobs.getInstance().isKept(jobTreeElement)) {
                object = this.doFindItem(objectArray[n]);
                if (object != null) {
                    ((ProgressInfoItem)((Object)object)).refresh();
                }
            } else {
                Object object2;
                object = this.doFindItem(jobTreeElement);
                if (object == null && (object2 = jobTreeElement.getParent()) != null) {
                    object = this.doFindItem(object2);
                }
                if (object != null) {
                    this.unmapElement(objectArray[n]);
                    object.dispose();
                }
            }
            ++n;
        }
        Control[] controlArray = this.control.getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            object = (ProgressInfoItem)controlArray[n2];
            ((ProgressInfoItem)((Object)object)).setColor(n2);
            ++n2;
        }
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    public void reveal(Object object) {
    }

    protected void setSelectionToWidget(List list, boolean bl) {
    }

    public void cancelSelection() {
    }

    public void setFocus() {
        Control[] controlArray = this.control.getChildren();
        if (controlArray.length > 0) {
            ((ProgressInfoItem)controlArray[0]).setButtonFocus();
        } else {
            this.noEntryArea.setFocus();
        }
    }

    private void refreshAll() {
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        Control[] controlArray = this.control.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].dispose();
            ++n;
        }
        n = Math.min(objectArray.length, 20);
        int n2 = 0;
        while (n2 < n) {
            ProgressInfoItem progressInfoItem = this.createNewItem((JobTreeElement)objectArray[n2]);
            progressInfoItem.setColor(n2);
            ++n2;
        }
        this.control.layout(true);
        this.updateForShowingProgress();
    }

    private void updateVisibleItems() {
        Control[] controlArray = this.control.getChildren();
        int n = this.scrolled.getOrigin().y;
        int n2 = n + this.scrolled.getParent().getBounds().height;
        int n3 = 0;
        while (n3 < controlArray.length) {
            ProgressInfoItem progressInfoItem = (ProgressInfoItem)controlArray[n3];
            progressInfoItem.setDisplayed(n, n2);
            ++n3;
        }
    }

    public ProgressInfoItem[] getProgressInfoItems() {
        Control[] controlArray = this.control.getChildren();
        ProgressInfoItem[] progressInfoItemArray = new ProgressInfoItem[controlArray.length];
        System.arraycopy(controlArray, 0, progressInfoItemArray, 0, controlArray.length);
        return progressInfoItemArray;
    }
}

