/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class BlockedJobsDialog
extends IconAndMessageDialog {
    protected static BlockedJobsDialog singleton;
    private DetailedProgressViewer viewer;
    private String blockedTaskName = ProgressMessages.SubTaskInfo_UndefinedTaskName;
    private Button cancelSelected;
    private Cursor arrowCursor;
    private Cursor waitCursor;
    private IProgressMonitor blockingMonitor;
    private JobTreeElement blockedElement = new BlockedUIElement();

    public static BlockedJobsDialog createBlockedDialog(Shell shell, IProgressMonitor iProgressMonitor, IStatus iStatus, String string) {
        if (singleton != null) {
            return singleton;
        }
        singleton = new BlockedJobsDialog(shell, iProgressMonitor, iStatus);
        if (string == null || string.length() == 0) {
            singleton.setBlockedTaskName(ProgressMessages.BlockedJobsDialog_UserInterfaceTreeElement);
        } else {
            singleton.setBlockedTaskName(string);
        }
        if (shell == null) {
            WorkbenchJob workbenchJob = new WorkbenchJob(WorkbenchMessages.EventLoopProgressMonitor_OpenDialogJobName){

                @Override
                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    if (singleton == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ProgressManagerUtil.rescheduleIfModalShellOpen(this)) {
                        return Status.CANCEL_STATUS;
                    }
                    singleton.open();
                    return Status.OK_STATUS;
                }
            };
            workbenchJob.setSystem(true);
            workbenchJob.schedule(PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        } else {
            singleton.open();
        }
        return singleton;
    }

    public static void clear(IProgressMonitor iProgressMonitor) {
        if (singleton == null) {
            return;
        }
        singleton.close(iProgressMonitor);
    }

    private BlockedJobsDialog(Shell shell, IProgressMonitor iProgressMonitor, IStatus iStatus) {
        super(shell == null ? ProgressManagerUtil.getDefaultParent() : shell);
        this.blockingMonitor = iProgressMonitor;
        this.setShellStyle(0x10C30 | BlockedJobsDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
        this.setMessage(iStatus.getMessage());
    }

    protected Control createDialogArea(Composite composite) {
        this.setMessage(this.message);
        this.createMessageArea(composite);
        this.showJobDetails(composite);
        return composite;
    }

    void showJobDetails(Composite composite) {
        int n;
        this.viewer = new DetailedProgressViewer(composite, 2818);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((Comparable)object).compareTo(object2);
            }
        });
        ProgressViewerContentProvider progressViewerContentProvider = this.getContentProvider();
        this.viewer.setContentProvider((IContentProvider)progressViewerContentProvider);
        this.viewer.setInput(progressViewerContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = n = this.convertHeightInCharsToPixels(10);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private ProgressViewerContentProvider getContentProvider() {
        return new ProgressViewerContentProvider(this.viewer, true, false){

            @Override
            public Object[] getElements(Object object) {
                Object[] objectArray = super.getElements(object);
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                objectArray2[0] = BlockedJobsDialog.this.blockedElement;
                return objectArray2;
            }
        };
    }

    private void clearCursors() {
        this.clearCursor((Control)this.cancelSelected);
        this.clearCursor((Control)this.getShell());
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
        }
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        this.arrowCursor = null;
        this.waitCursor = null;
    }

    private void clearCursor(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setCursor(null);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ProgressMessages.BlockedJobsDialog_BlockedTitle);
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)shell.getDisplay(), 1);
        }
        shell.setCursor(this.waitCursor);
    }

    private void setMessage(String string) {
        String string2 = this.message = string == null ? "" : string;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.blockingMonitor;
    }

    public boolean close(IProgressMonitor iProgressMonitor) {
        if (this.blockingMonitor != iProgressMonitor) {
            return false;
        }
        return this.close();
    }

    public boolean close() {
        singleton = null;
        this.clearCursors();
        return super.close();
    }

    protected Control createButtonBar(Composite composite) {
        return composite;
    }

    void setBlockedTaskName(String string) {
        this.blockedTaskName = string;
    }

    private class BlockedUIElement
    extends JobTreeElement {
        private BlockedUIElement() {
        }

        @Override
        Object[] getChildren() {
            return ProgressManagerUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        String getDisplayString() {
            if (BlockedJobsDialog.this.blockedTaskName == null || BlockedJobsDialog.this.blockedTaskName.length() == 0) {
                return ProgressMessages.BlockedJobsDialog_UserInterfaceTreeElement;
            }
            return BlockedJobsDialog.this.blockedTaskName;
        }

        @Override
        public Image getDisplayImage() {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }

        @Override
        boolean hasChildren() {
            return false;
        }

        @Override
        boolean isActive() {
            return true;
        }

        @Override
        boolean isJobInfo() {
            return false;
        }

        @Override
        public void cancel() {
            BlockedJobsDialog.this.blockingMonitor.setCanceled(true);
        }

        @Override
        public boolean isCancellable() {
            return true;
        }
    }
}

