/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class AnimationManager {
    private static AnimationManager singleton;
    boolean animated = false;
    private IJobProgressManagerListener listener;
    IAnimationProcessor animationProcessor = new ProgressAnimationProcessor(this);
    WorkbenchJob animationUpdateJob = new WorkbenchJob(ProgressMessages.AnimationManager_AnimationStart){

        @Override
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (AnimationManager.this.animated) {
                AnimationManager.this.animationProcessor.animationStarted();
            } else {
                AnimationManager.this.animationProcessor.animationFinished();
            }
            return Status.OK_STATUS;
        }
    };

    public static AnimationManager getInstance() {
        if (singleton == null) {
            singleton = new AnimationManager();
        }
        return singleton;
    }

    static Color getItemBackgroundColor(Control control) {
        return control.getDisplay().getSystemColor(29);
    }

    AnimationManager() {
        this.animationUpdateJob.setSystem(true);
        this.listener = this.getProgressListener();
        ProgressManager.getInstance().addListener(this.listener);
    }

    void addItem(AnimationItem animationItem) {
        this.animationProcessor.addItem(animationItem);
    }

    void removeItem(AnimationItem animationItem) {
        this.animationProcessor.removeItem(animationItem);
    }

    boolean isAnimated() {
        return this.animated;
    }

    void setAnimated(boolean bl) {
        this.animated = bl;
        this.animationUpdateJob.schedule(100L);
    }

    void dispose() {
        this.setAnimated(false);
        ProgressManager.getInstance().removeListener(this.listener);
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){
            Set jobs = Collections.synchronizedSet(new HashSet());

            @Override
            public void addJob(JobInfo jobInfo) {
                this.incrementJobCount(jobInfo);
            }

            @Override
            public void refreshJobInfo(JobInfo jobInfo) {
                int n = jobInfo.getJob().getState();
                if (n == 4) {
                    this.addJob(jobInfo);
                } else {
                    this.removeJob(jobInfo);
                }
            }

            @Override
            public void refreshAll() {
                ProgressManager progressManager = ProgressManager.getInstance();
                this.jobs.clear();
                AnimationManager.this.setAnimated(false);
                JobInfo[] jobInfoArray = progressManager.getJobInfos(this.showsDebug());
                int n = 0;
                while (n < jobInfoArray.length) {
                    this.addJob(jobInfoArray[n]);
                    ++n;
                }
            }

            @Override
            public void removeJob(JobInfo jobInfo) {
                this.decrementJobCount(jobInfo.getJob());
            }

            @Override
            public boolean showsDebug() {
                return false;
            }

            private void incrementJobCount(JobInfo jobInfo) {
                if (this.isNotTracked(jobInfo)) {
                    return;
                }
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(true);
                }
                this.jobs.add(jobInfo.getJob());
            }

            private void decrementJobCount(Job job) {
                this.jobs.remove(job);
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(false);
                }
            }

            private boolean isNotTracked(JobInfo jobInfo) {
                Job job = jobInfo.getJob();
                return job.getState() != 4 || AnimationManager.this.animationProcessor.isProcessorJob(job);
            }

            @Override
            public void addGroup(GroupInfo groupInfo) {
            }

            @Override
            public void removeGroup(GroupInfo groupInfo) {
            }

            @Override
            public void refreshGroup(GroupInfo groupInfo) {
            }
        };
    }

    int getPreferredWidth() {
        return this.animationProcessor.getPreferredWidth();
    }
}

