/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;

public abstract class AnimationItem {
    WorkbenchWindow window;
    IAnimationContainer animationContainer = new IAnimationContainer(){

        @Override
        public void animationDone() {
        }

        @Override
        public void animationStart() {
        }
    };

    public AnimationItem(WorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
    }

    public void createControl(Composite composite) {
        Control control = this.createAnimationItem(composite);
        control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ProgressManagerUtil.openProgressView(AnimationItem.this.window);
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AnimationManager.getInstance().removeItem(AnimationItem.this);
            }
        });
        AnimationManager.getInstance().addItem(this);
    }

    protected abstract Control createAnimationItem(Composite var1);

    void paintImage(PaintEvent paintEvent, Image image, ImageData imageData) {
        paintEvent.gc.drawImage(image, 0, 0);
    }

    public abstract Control getControl();

    void animationStart() {
        this.animationContainer.animationStart();
    }

    void animationDone() {
        this.animationContainer.animationDone();
    }

    public int getPreferredWidth() {
        return AnimationManager.getInstance().getPreferredWidth() + 5;
    }

    void setAnimationContainer(IAnimationContainer iAnimationContainer) {
        this.animationContainer = iAnimationContainer;
    }

    public WorkbenchWindow getWindow() {
        return this.window;
    }

    static interface IAnimationContainer {
        public void animationStart();

        public void animationDone();
    }
}

