/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.preferences.IDynamicPropertyMap;
import org.eclipse.ui.internal.preferences.PreferenceStoreAdapter;
import org.eclipse.ui.internal.preferences.PreferencesAdapter;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;
import org.eclipse.ui.internal.preferences.ThemeManagerAdapter;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultPartList;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.ISystemMenu;
import org.eclipse.ui.internal.presentations.util.LeftToRightTabOrder;
import org.eclipse.ui.internal.presentations.util.PresentablePartFolder;
import org.eclipse.ui.internal.presentations.util.ReplaceDragHandler;
import org.eclipse.ui.internal.presentations.util.TabDragHandler;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.internal.presentations.util.TabFolderListener;
import org.eclipse.ui.internal.presentations.util.TabOrder;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public final class TabbedStackPresentation
extends StackPresentation {
    private PresentablePartFolder folder;
    private ISystemMenu systemMenu;
    private ISystemMenu partList;
    private PreferenceStoreAdapter apiPreferences = new PreferenceStoreAdapter(PrefUtil.getAPIPreferenceStore());
    private ThemeManagerAdapter themePreferences = new ThemeManagerAdapter(PlatformUI.getWorkbench().getThemeManager());
    private TabOrder tabs;
    private TabDragHandler dragBehavior;
    private boolean initializing = true;
    private int ignoreSelectionChanges = 0;
    private TabFolderListener tabFolderListener = new TabFolderListener(){

        @Override
        public void handleEvent(TabFolderEvent tabFolderEvent) {
            switch (tabFolderEvent.type) {
                case 5: {
                    TabbedStackPresentation.this.getSite().setState(0);
                    break;
                }
                case 7: {
                    TabbedStackPresentation.this.getSite().setState(1);
                    break;
                }
                case 4: {
                    TabbedStackPresentation.this.getSite().setState(2);
                    break;
                }
                case 6: {
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.folder.getPartForTab(tabFolderEvent.tab);
                    if (iPresentablePart == null) break;
                    TabbedStackPresentation.this.getSite().close(new IPresentablePart[]{iPresentablePart});
                    break;
                }
                case 11: {
                    TabbedStackPresentation.this.showPartList();
                    break;
                }
                case 9: {
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.getSite().getSelectedPart();
                    if (iPresentablePart == null) break;
                    iPresentablePart.setFocus();
                    break;
                }
                case 1: {
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.getSite().getSelectedPart();
                    if (iPresentablePart != null) {
                        iPresentablePart.setFocus();
                    }
                    TabbedStackPresentation.this.showPaneMenu(TabbedStackPresentation.this.folder.getPartForTab(tabFolderEvent.tab), new Point(tabFolderEvent.x, tabFolderEvent.y));
                    break;
                }
                case 10: {
                    AbstractTabItem abstractTabItem = tabFolderEvent.tab;
                    Point point = new Point(tabFolderEvent.x, tabFolderEvent.y);
                    if (abstractTabItem == null) {
                        TabbedStackPresentation.this.getSite().dragStart(point, false);
                        break;
                    }
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.folder.getPartForTab(abstractTabItem);
                    try {
                        TabbedStackPresentation.this.dragStart = TabbedStackPresentation.this.folder.indexOf(iPresentablePart);
                        TabbedStackPresentation.this.getSite().dragStart(iPresentablePart, point, false);
                        break;
                    }
                    finally {
                        TabbedStackPresentation.this.dragStart = -1;
                    }
                }
                case 8: {
                    if (TabbedStackPresentation.this.ignoreSelectionChanges > 0) {
                        return;
                    }
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.folder.getPartForTab(tabFolderEvent.tab);
                    if (iPresentablePart == null) break;
                    TabbedStackPresentation.this.getSite().selectPart(iPresentablePart);
                    break;
                }
                case 12: {
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.folder.getPartForTab(tabFolderEvent.tab);
                    if (iPresentablePart == null) {
                        iPresentablePart = TabbedStackPresentation.this.getSite().getSelectedPart();
                    }
                    if (iPresentablePart == null) break;
                    TabbedStackPresentation.this.showSystemMenu(new Point(tabFolderEvent.x, tabFolderEvent.y), iPresentablePart);
                    break;
                }
                case 13: {
                    IPresentablePart[] iPresentablePartArray;
                    IPresentablePart iPresentablePart = TabbedStackPresentation.this.folder.getPartForTab(tabFolderEvent.tab);
                    if (iPresentablePart == null && (iPresentablePartArray = TabbedStackPresentation.this.getSite().getPartList()).length > 0) {
                        iPresentablePart = iPresentablePartArray[0];
                    }
                    if (iPresentablePart != TabbedStackPresentation.this.getSite().getSelectedPart()) break;
                    TabbedStackPresentation.this.getSite().flushLayout();
                }
            }
        }
    };
    private int dragStart = -1;
    private Map prefs = new HashMap();

    public TabbedStackPresentation(IStackPresentationSite iStackPresentationSite, AbstractTabFolder abstractTabFolder, ISystemMenu iSystemMenu) {
        this(iStackPresentationSite, new PresentablePartFolder(abstractTabFolder), iSystemMenu);
    }

    public TabbedStackPresentation(IStackPresentationSite iStackPresentationSite, PresentablePartFolder presentablePartFolder, ISystemMenu iSystemMenu) {
        this(iStackPresentationSite, presentablePartFolder, new LeftToRightTabOrder(presentablePartFolder), new ReplaceDragHandler(presentablePartFolder.getTabFolder()), iSystemMenu);
    }

    public TabbedStackPresentation(IStackPresentationSite iStackPresentationSite, PresentablePartFolder presentablePartFolder, TabOrder tabOrder, TabDragHandler tabDragHandler, ISystemMenu iSystemMenu) {
        super(iStackPresentationSite);
        this.systemMenu = iSystemMenu;
        this.folder = presentablePartFolder;
        this.tabs = tabOrder;
        this.dragBehavior = tabDragHandler;
        this.folder.getTabFolder().getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TabbedStackPresentation.this.presentationDisposed();
            }
        });
        this.folder.getTabFolder().addListener(this.tabFolderListener);
        this.partList = new DefaultPartList(iStackPresentationSite, presentablePartFolder);
    }

    @Override
    public void restoreState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
        this.tabs.restoreState(iPresentationSerializer, iMemento);
    }

    @Override
    public void saveState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
        super.saveState(iPresentationSerializer, iMemento);
        this.tabs.saveState(iPresentationSerializer, iMemento);
    }

    private boolean isDisposed() {
        return this.folder == null || this.folder.isDisposed();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.folder.setBounds(rectangle);
    }

    @Override
    public Point computeMinimumSize() {
        return this.folder.getTabFolder().computeSize(-1, -1);
    }

    private int computePreferredMinimumSize(boolean bl, int n) {
        int n2 = n == Integer.MAX_VALUE ? -1 : n;
        int n3 = bl ? this.folder.getTabFolder().computeSize((int)-1, (int)n2).x : this.folder.getTabFolder().computeSize((int)n2, (int)-1).y;
        return n3;
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        IPresentablePart[] iPresentablePartArray = this.getSite().getPartList();
        if (iPresentablePartArray.length == 1 && iPresentablePartArray[0] != null && this.getSite().getState() != 0) {
            int n4 = iPresentablePartArray[0].computePreferredSize(bl, n, n2, n3);
            if (n4 == Integer.MAX_VALUE) {
                return n4;
            }
            int n5 = this.computePreferredMinimumSize(bl, n2);
            if (bl) {
                n4 = Math.max(n5, n4);
            } else if (Integer.MAX_VALUE - n5 > n4) {
                n4 += n5;
            }
            return n4;
        }
        if (n3 != Integer.MAX_VALUE || this.getSite().getState() == 0) {
            int n6 = this.computePreferredMinimumSize(bl, n2);
            if (this.getSite().getState() == 0) {
                return n6;
            }
            return Math.max(n6, n3);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSizeFlags(boolean bl) {
        int n = 0;
        IPresentablePart[] iPresentablePartArray = this.getSite().getPartList();
        if (iPresentablePartArray.length == 1 && iPresentablePartArray[0] != null) {
            n |= iPresentablePartArray[0].getSizeFlags(bl);
        }
        return n | super.getSizeFlags(bl);
    }

    @Override
    public void showPartList() {
        int n;
        if (this.partList != null && (n = this.folder.getTabFolder().getItemCount()) > 0) {
            this.partList.show(this.getControl(), this.folder.getTabFolder().getPartListLocation(), this.getSite().getSelectedPart());
        }
    }

    @Override
    public void dispose() {
        this.folder.getTabFolder().getControl().dispose();
    }

    private void presentationDisposed() {
        this.apiPreferences.dispose();
        this.themePreferences.dispose();
        for (PropertyMapAdapter propertyMapAdapter : this.prefs.values()) {
            propertyMapAdapter.dispose();
        }
        if (this.systemMenu != null) {
            this.systemMenu.dispose();
        }
        if (this.partList != null) {
            this.partList.dispose();
        }
        this.systemMenu = null;
        this.partList = null;
    }

    @Override
    public void setActive(int n) {
        this.folder.getTabFolder().setActive(n);
    }

    @Override
    public void setVisible(boolean bl) {
        IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
        if (iPresentablePart != null) {
            iPresentablePart.setVisible(bl);
        }
        this.folder.setVisible(bl);
    }

    @Override
    public void setState(int n) {
        this.folder.getTabFolder().setState(n);
    }

    @Override
    public Control getControl() {
        return this.folder.getTabFolder().getControl();
    }

    public AbstractTabFolder getTabFolder() {
        return this.folder.getTabFolder();
    }

    @Override
    public void addPart(IPresentablePart iPresentablePart, Object object) {
        ++this.ignoreSelectionChanges;
        try {
            if (this.initializing) {
                this.tabs.addInitial(iPresentablePart);
            } else if (object == null) {
                this.tabs.add(iPresentablePart);
            } else {
                int n = this.dragBehavior.getInsertionPosition(object);
                this.tabs.insert(iPresentablePart, n);
            }
        }
        finally {
            --this.ignoreSelectionChanges;
        }
        if (this.tabs.getPartList().length == 1 && (iPresentablePart.getSizeFlags(true) != 0 || iPresentablePart.getSizeFlags(false) != 0)) {
            this.getSite().flushLayout();
        }
    }

    @Override
    public void movePart(IPresentablePart iPresentablePart, Object object) {
        ++this.ignoreSelectionChanges;
        try {
            int n = this.dragBehavior.getInsertionPosition(object);
            if (n == this.folder.indexOf(iPresentablePart)) {
                return;
            }
            this.tabs.move(iPresentablePart, n);
        }
        finally {
            --this.ignoreSelectionChanges;
        }
    }

    @Override
    public void removePart(IPresentablePart iPresentablePart) {
        ++this.ignoreSelectionChanges;
        try {
            this.tabs.remove(iPresentablePart);
        }
        finally {
            --this.ignoreSelectionChanges;
        }
    }

    @Override
    public void selectPart(IPresentablePart iPresentablePart) {
        this.initializing = false;
        this.tabs.select(iPresentablePart);
    }

    @Override
    public StackDropResult dragOver(Control control, Point point) {
        return this.dragBehavior.dragOver(control, point, this.dragStart);
    }

    @Override
    public void showSystemMenu() {
        this.showSystemMenu(this.folder.getTabFolder().getSystemMenuLocation(), this.getSite().getSelectedPart());
    }

    public void showSystemMenu(Point point, IPresentablePart iPresentablePart) {
        if (iPresentablePart != this.getSite().getSelectedPart()) {
            this.getSite().selectPart(iPresentablePart);
        }
        this.systemMenu.show(this.getControl(), point, iPresentablePart);
    }

    @Override
    public void showPaneMenu() {
        IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
        if (iPresentablePart != null) {
            this.showPaneMenu(iPresentablePart, this.folder.getTabFolder().getPaneMenuLocation());
        }
    }

    public void showPaneMenu(IPresentablePart iPresentablePart, Point point) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPartMenu iPartMenu = iPresentablePart.getMenu();
        if (iPartMenu != null) {
            iPartMenu.showMenu(point);
        }
    }

    @Override
    public Control[] getTabList(IPresentablePart iPresentablePart) {
        ArrayList<Control> arrayList = new ArrayList<Control>();
        if (this.folder.getTabFolder().getTabPosition() == 1024 && iPresentablePart.getControl() != null) {
            arrayList.add(iPresentablePart.getControl());
        }
        arrayList.add(this.folder.getTabFolder().getControl());
        if (iPresentablePart.getToolBar() != null) {
            arrayList.add(iPresentablePart.getToolBar());
        }
        if (this.folder.getTabFolder().getTabPosition() == 128 && iPresentablePart.getControl() != null) {
            arrayList.add(iPresentablePart.getControl());
        }
        return arrayList.toArray(new Control[arrayList.size()]);
    }

    public void setPartList(ISystemMenu iSystemMenu) {
        this.partList = iSystemMenu;
    }

    public IDynamicPropertyMap getTheme() {
        return this.themePreferences;
    }

    public IDynamicPropertyMap getApiPreferences() {
        return this.apiPreferences;
    }

    public IDynamicPropertyMap getPluginPreferences(Plugin plugin) {
        String string = plugin.getBundle().getSymbolicName();
        IDynamicPropertyMap iDynamicPropertyMap = (IDynamicPropertyMap)this.prefs.get(string);
        if (iDynamicPropertyMap != null) {
            return iDynamicPropertyMap;
        }
        iDynamicPropertyMap = new PreferencesAdapter(plugin.getPluginPreferences());
        this.prefs.put(string, iDynamicPropertyMap);
        return iDynamicPropertyMap;
    }

    public void moveTab(IPresentablePart iPresentablePart, int n) {
        this.tabs.move(iPresentablePart, n);
        this.folder.layout(true);
    }

    public IPresentablePart[] getPartList() {
        return this.tabs.getPartList();
    }

    public void showMinMax(boolean bl) {
        this.folder.getTabFolder().showMinMax(bl);
    }
}

