/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.presentations.util.EnhancedFillLayout;

public class StandardSystemToolbar
extends EventManager {
    private ToolBarManager toolbarManager;
    private Composite control;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            ToolItem toolItem = StandardSystemToolbar.this.toolbarManager.getControl().getItem(new Point(mouseEvent.x, mouseEvent.y));
            if (toolItem == ((StandardSystemToolbar)StandardSystemToolbar.this).paneMenu.item && mouseEvent.button == 1) {
                StandardSystemToolbar.this.fireEvent(1);
            }
        }
    };
    private SystemMenuContribution paneMenu = new PaneMenu();
    private SystemMenuContribution showToolbar = new SystemMenuContribution();
    private SystemMenuContribution min = new SystemMenuContribution();
    private SystemMenuContribution max = new SystemMenuContribution();
    private SystemMenuContribution close = new SystemMenuContribution();
    private int state = 2;
    private boolean showingToolbar = true;
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget != ((StandardSystemToolbar)StandardSystemToolbar.this).paneMenu.item) {
                if (selectionEvent.widget == ((StandardSystemToolbar)StandardSystemToolbar.this).showToolbar.item) {
                    if (StandardSystemToolbar.this.showingToolbar) {
                        StandardSystemToolbar.this.fireEvent(2);
                    } else {
                        StandardSystemToolbar.this.fireEvent(3);
                    }
                } else if (selectionEvent.widget == ((StandardSystemToolbar)StandardSystemToolbar.this).min.item) {
                    if (StandardSystemToolbar.this.state == 0) {
                        StandardSystemToolbar.this.fireEvent(4);
                    } else {
                        StandardSystemToolbar.this.fireEvent(5);
                    }
                } else if (selectionEvent.widget == ((StandardSystemToolbar)StandardSystemToolbar.this).max.item) {
                    if (StandardSystemToolbar.this.state == 1) {
                        StandardSystemToolbar.this.fireEvent(4);
                    } else {
                        StandardSystemToolbar.this.fireEvent(7);
                    }
                } else if (selectionEvent.widget == ((StandardSystemToolbar)StandardSystemToolbar.this).close.item) {
                    StandardSystemToolbar.this.fireEvent(6);
                }
            }
        }
    };

    public StandardSystemToolbar(Composite composite, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.control = new Composite(composite, 0);
        this.control.setLayout((Layout)new EnhancedFillLayout());
        this.toolbarManager = new ToolBarManager(0x800000);
        this.toolbarManager.createControl(this.control);
        this.toolbarManager.getControl().addMouseListener(this.mouseListener);
        this.toolbarManager.add((IContributionItem)this.paneMenu);
        this.paneMenu.setImage(WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_THIN"));
        this.paneMenu.setVisible(bl);
        this.paneMenu.setToolTipText(WorkbenchMessages.Menu);
        this.toolbarManager.add((IContributionItem)this.showToolbar);
        this.showToolbar.setImage(WorkbenchImages.getImage("IMG_LCL_HIDE_TOOLBAR_THIN"));
        this.showToolbar.setVisible(bl2);
        this.toolbarManager.add((IContributionItem)this.min);
        this.min.setVisible(bl3);
        this.toolbarManager.add((IContributionItem)this.max);
        this.max.setVisible(bl4);
        this.toolbarManager.add((IContributionItem)this.close);
        this.close.setImage(WorkbenchImages.getImage("IMG_LCL_CLOSE_VIEW_THIN"));
        this.close.setVisible(bl5);
        this.setState(2);
        this.toolbarManager.update(true);
    }

    public Point getPaneMenuLocation() {
        Rectangle rectangle = Geometry.toDisplay((Control)this.paneMenu.item.getParent(), (Rectangle)this.paneMenu.item.getBounds());
        return new Point(rectangle.x, rectangle.y + rectangle.height);
    }

    public void enableClose(boolean bl) {
        this.close.setVisible(bl);
        this.toolbarManager.update(false);
    }

    public void enableMinimize(boolean bl) {
        this.min.setVisible(bl);
        this.toolbarManager.update(false);
    }

    public void enableMaximize(boolean bl) {
        this.max.setVisible(bl);
        this.toolbarManager.update(false);
    }

    public void enableShowToolbar(boolean bl) {
        this.showToolbar.setVisible(bl);
        this.toolbarManager.update(false);
    }

    public void enablePaneMenu(boolean bl) {
        this.paneMenu.setVisible(bl);
        this.toolbarManager.update(false);
    }

    public void setState(int n) {
        if (this.min != null) {
            if (n == 0) {
                this.min.setToolTipText(WorkbenchMessages.StandardSystemToolbar_Restore);
                this.min.setImage(WorkbenchImages.getImage("IMG_LCL_RESTORE_VIEW_THIN"));
            } else {
                this.min.setToolTipText(WorkbenchMessages.StandardSystemToolbar_Minimize);
                this.min.setImage(WorkbenchImages.getImage("IMG_LCL_MIN_VIEW_THIN"));
            }
        }
        if (this.max != null) {
            if (n == 1) {
                this.max.setToolTipText(WorkbenchMessages.StandardSystemToolbar_Restore);
                this.max.setImage(WorkbenchImages.getImage("IMG_LCL_RESTORE_VIEW_THIN"));
            } else {
                this.max.setToolTipText(WorkbenchMessages.StandardSystemToolbar_Maximize);
                this.max.setImage(WorkbenchImages.getImage("IMG_LCL_MAX_VIEW_THIN"));
            }
        }
        this.state = n;
    }

    public void setToolbarShowing(boolean bl) {
        this.showingToolbar = bl;
        if (this.showToolbar != null) {
            if (bl) {
                this.showToolbar.setImage(WorkbenchImages.getImage("IMG_LCL_HIDE_TOOLBAR_THIN"));
            } else {
                this.showToolbar.setImage(WorkbenchImages.getImage("IMG_LCL_SHOW_TOOLBAR_THIN"));
            }
        }
    }

    public void addListener(IPropertyListener iPropertyListener) {
        this.addListenerObject(iPropertyListener);
    }

    public void removeListener(IPropertyListener iPropertyListener) {
        this.removeListenerObject(iPropertyListener);
    }

    public Control getControl() {
        return this.control;
    }

    private void fireEvent(int n) {
        Object[] objectArray = this.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            iPropertyListener.propertyChanged((Object)this, n);
            ++n2;
        }
    }

    private class PaneMenu
    extends SystemMenuContribution {
        public PaneMenu() {
            super(0);
        }

        @Override
        public void setToolTipText(String string) {
            super.setToolTipText(string);
        }

        @Override
        public void setImage(Image image) {
            super.setImage(image);
        }

        @Override
        public void fill(ToolBar toolBar, int n) {
            if (!this.isVisible()) {
                return;
            }
            super.fill(toolBar, n);
        }
    }

    private class SystemMenuContribution
    extends ContributionItem {
        ToolItem item;
        Image img;
        String text;
        int flags;

        public SystemMenuContribution() {
            this(8);
        }

        public SystemMenuContribution(int n) {
            this.flags = n;
        }

        public void setToolTipText(String string) {
            this.text = string;
            if (this.item != null) {
                this.item.setToolTipText(string);
            }
        }

        public void setImage(Image image) {
            this.img = image;
            if (this.item != null) {
                this.item.setImage(image);
            }
        }

        public void setVisible(boolean bl) {
            if (bl != this.isVisible()) {
                StandardSystemToolbar.this.toolbarManager.markDirty();
            }
            super.setVisible(bl);
        }

        public void fill(ToolBar toolBar, int n) {
            if (!this.isVisible()) {
                return;
            }
            this.item = new ToolItem(toolBar, this.flags, n);
            if (this.img != null) {
                this.item.setImage(this.img);
            }
            if (this.text != null) {
                this.item.setToolTipText(this.text);
            }
            this.item.addSelectionListener((SelectionListener)StandardSystemToolbar.this.selectionListener);
        }
    }
}

