/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.presentations.SystemMenuCloseAll;
import org.eclipse.ui.internal.presentations.SystemMenuCloseOthers;
import org.eclipse.ui.internal.presentations.util.StandardViewSystemMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class StandardEditorSystemMenu
extends StandardViewSystemMenu {
    private SystemMenuCloseOthers closeOthers;
    private SystemMenuCloseAll closeAll;
    private ActionFactory.IWorkbenchAction openAgain;

    public StandardEditorSystemMenu(IStackPresentationSite iStackPresentationSite) {
        super(iStackPresentationSite);
        this.closeOthers = new SystemMenuCloseOthers(iStackPresentationSite);
        this.closeAll = new SystemMenuCloseAll(iStackPresentationSite);
        this.openAgain = ActionFactory.NEW_EDITOR.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.menuManager.add((IAction)this.closeOthers);
        this.menuManager.add((IAction)this.closeAll);
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add((IAction)this.openAgain);
    }

    @Override
    String getMoveMenuText() {
        return WorkbenchMessages.EditorPane_moveEditor;
    }

    @Override
    public void show(Control control, Point point, IPresentablePart iPresentablePart) {
        this.closeOthers.setTarget(iPresentablePart);
        this.closeAll.update();
        super.show(control, point, iPresentablePart);
    }

    @Override
    public void dispose() {
        this.openAgain.dispose();
        super.dispose();
    }
}

