/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.TabDragHandler;
import org.eclipse.ui.presentations.StackDropResult;

public class ReplaceDragHandler
extends TabDragHandler {
    private AbstractTabFolder tabFolder;

    public ReplaceDragHandler(AbstractTabFolder abstractTabFolder) {
        this.tabFolder = abstractTabFolder;
    }

    @Override
    public StackDropResult dragOver(Control control, Point point, int n) {
        AbstractTabItem abstractTabItem = this.tabFolder.getItem(point);
        if (abstractTabItem == null) {
            Rectangle rectangle = this.tabFolder.getTabArea();
            if (rectangle.contains(point) && this.tabFolder.getItemCount() > 0) {
                int n2 = this.tabFolder.getItemCount();
                AbstractTabItem abstractTabItem2 = this.tabFolder.getItem(n2 - 1);
                if (!abstractTabItem2.isShowing()) {
                    return null;
                }
                Rectangle rectangle2 = abstractTabItem2.getBounds();
                if (rectangle2.isEmpty()) {
                    return null;
                }
                if (n >= 0) {
                    return new StackDropResult(rectangle2, new Integer(--n2));
                }
                Rectangle rectangle3 = rectangle;
                rectangle3.x = rectangle2.x + rectangle2.width;
                rectangle3.width = 3 * rectangle3.height;
                return new StackDropResult(rectangle3, new Integer(n2));
            }
            Rectangle rectangle4 = DragUtil.getDisplayBounds(this.tabFolder.getControl());
            int n3 = Geometry.getClosestSide((Rectangle)rectangle4, (Point)point);
            if (n3 == this.tabFolder.getTabPosition()) {
                return new StackDropResult(rectangle4, null);
            }
            return null;
        }
        if (!abstractTabItem.isShowing()) {
            return null;
        }
        Rectangle rectangle = abstractTabItem.getBounds();
        if (rectangle.isEmpty()) {
            return null;
        }
        return new StackDropResult(rectangle, new DragCookie(this.tabFolder.indexOf(abstractTabItem)));
    }

    @Override
    public int getInsertionPosition(Object object) {
        if (object instanceof DragCookie) {
            return Math.min(this.tabFolder.getItemCount(), ((DragCookie)object).insertPosition);
        }
        return this.tabFolder.getItemCount();
    }

    private final class DragCookie {
        int insertPosition;

        public DragCookie(int n) {
            this.insertPosition = n;
        }
    }
}

