/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.layout.SizeCache;

public class ProxyControl {
    private Composite control;
    private Control target = null;
    private SizeCache targetCache = null;
    private Control commonAncestor;
    private boolean visible = true;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            if (disposeEvent.widget == ProxyControl.this.target || disposeEvent.widget == ProxyControl.this.control) {
                ProxyControl.this.setTargetControl(null);
            }
        }
    };
    private Listener visibilityListener = new Listener(){

        public void handleEvent(Event event) {
            if (ProxyControl.this.target != null) {
                ProxyControl.this.visible = ProxyControl.this.control.getVisible();
                ProxyControl.this.target.setVisible(ProxyControl.this.visible);
            }
        }
    };
    private ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent controlEvent) {
            ProxyControl.this.layout();
        }

        public void controlResized(ControlEvent controlEvent) {
        }
    };

    public void setVisible(boolean bl) {
    }

    public ProxyControl(Composite composite) {
        this.control = new Composite(composite, 262144);
        this.control.setVisible(false);
        this.control.setLayout(new Layout(){

            protected void layout(Composite composite, boolean bl) {
                ProxyControl.this.layout();
            }

            protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
                if (ProxyControl.this.targetCache == null) {
                    if (ProxyControl.this.target != null) {
                        return ProxyControl.this.target.computeSize(n, n2, bl);
                    }
                    return new Point(1, 1);
                }
                return ProxyControl.this.targetCache.computeSize(n, n2);
            }
        });
        this.control.addDisposeListener(this.disposeListener);
        this.control.addListener(22, this.visibilityListener);
        this.control.addListener(23, this.visibilityListener);
    }

    public void setTargetControl(Control control) {
        this.targetCache = null;
        this.internalSetTargetControl(control);
    }

    private void internalSetTargetControl(Control control) {
        if (this.target != control) {
            Composite composite;
            if (this.target != null) {
                composite = this.control;
                while (composite != this.commonAncestor && composite != null) {
                    composite.removeControlListener(this.controlListener);
                    composite = composite.getParent();
                }
                this.commonAncestor = null;
                if (!this.target.isDisposed()) {
                    this.target.removeDisposeListener(this.disposeListener);
                }
            }
            if (this.target == null && control != null) {
                this.control.setVisible(this.visible);
            }
            this.target = control;
            if (control != null) {
                this.commonAncestor = SwtUtil.findCommonAncestor(this.target, (Control)this.control);
                composite = this.control;
                while (composite != null && composite != this.commonAncestor) {
                    composite.addControlListener(this.controlListener);
                    composite = composite.getParent();
                }
                control.setVisible(this.control.getVisible());
                control.addDisposeListener(this.disposeListener);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setTarget(SizeCache sizeCache) {
        this.targetCache = sizeCache;
        if (this.targetCache != null) {
            this.setTargetControl(sizeCache.getControl());
        } else {
            this.setTargetControl(null);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Control getTarget() {
        return this.target;
    }

    public void layout() {
        if (this.getTarget() == null) {
            return;
        }
        Rectangle rectangle = Geometry.toDisplay((Control)this.control.getParent(), (Rectangle)this.control.getBounds());
        Rectangle rectangle2 = DragUtil.getDisplayBounds((Control)this.control.getParent());
        rectangle = rectangle.intersection(rectangle2);
        Rectangle rectangle3 = Geometry.toControl((Control)this.getTarget().getParent(), (Rectangle)rectangle);
        this.getTarget().setBounds(rectangle3);
    }
}

