/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.IPresentablePartList;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.presentations.IPresentablePart;

public final class PresentablePartFolder
implements IPresentablePartList {
    private AbstractTabFolder folder;
    private IPresentablePart current;
    private Control contentProxy;
    private static PartInfo tempPartInfo = new PartInfo();
    private ControlListener contentListener = new ControlListener(){

        public void controlMoved(ControlEvent controlEvent) {
            PresentablePartFolder.this.layoutContent();
        }

        public void controlResized(ControlEvent controlEvent) {
        }
    };
    private ShellListener shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent shellEvent) {
            PresentablePartFolder.this.folder.shellActive(true);
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            PresentablePartFolder.this.folder.shellActive(false);
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (object instanceof IPresentablePart) {
                IPresentablePart iPresentablePart = (IPresentablePart)object;
                PresentablePartFolder.this.childPropertyChanged(iPresentablePart, n);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            if (disposeEvent.widget == PresentablePartFolder.this.folder.getControl()) {
                PresentablePartFolder.this.disposed();
            }
        }
    };
    private List partList = new ArrayList(4);
    private boolean isVisible = true;

    public PresentablePartFolder(AbstractTabFolder abstractTabFolder) {
        this.folder = abstractTabFolder;
        abstractTabFolder.getControl().getShell().addShellListener(this.shellListener);
        abstractTabFolder.shellActive(abstractTabFolder.getControl().getDisplay().getActiveShell() == abstractTabFolder.getControl().getShell());
        abstractTabFolder.getControl().addDisposeListener(this.tabDisposeListener);
        this.contentProxy = new Composite(abstractTabFolder.getContentParent(), 0);
        this.contentProxy.setVisible(false);
        Control control = this.contentProxy;
        while (control != abstractTabFolder.getControl().getParent()) {
            control.addControlListener(this.contentListener);
            control = control.getParent();
        }
        abstractTabFolder.setContent(this.contentProxy);
    }

    private void layoutContent() {
        if (this.current != null) {
            Rectangle rectangle = DragUtil.getDisplayBounds(this.contentProxy);
            this.current.setBounds(Geometry.toControl((Control)this.folder.getControl().getParent(), (Rectangle)rectangle));
        }
    }

    protected void disposed() {
        this.folder.getControl().getShell().removeShellListener(this.shellListener);
        for (IPresentablePart iPresentablePart : this.partList) {
            iPresentablePart.removePropertyListener(this.childPropertyChangeListener);
        }
    }

    @Override
    public IPresentablePart[] getPartList() {
        AbstractTabItem[] abstractTabItemArray = this.folder.getItems();
        IPresentablePart[] iPresentablePartArray = new IPresentablePart[abstractTabItemArray.length];
        int n = 0;
        while (n < abstractTabItemArray.length) {
            iPresentablePartArray[n] = this.getPartForTab(abstractTabItemArray[n]);
            ++n;
        }
        return iPresentablePartArray;
    }

    @Override
    public void insert(IPresentablePart iPresentablePart, int n) {
        Assert.isTrue((!this.folder.getControl().isDisposed() ? 1 : 0) != 0);
        if (this.getTab(iPresentablePart) != null) {
            if (this.indexOf(iPresentablePart) != n) {
                this.move(iPresentablePart, n);
            }
            return;
        }
        n = Math.min(n, this.folder.getItemCount());
        int n2 = 0;
        if (iPresentablePart.isCloseable()) {
            n2 |= 0x40;
        }
        AbstractTabItem abstractTabItem = this.folder.add(n, n2);
        this.folder.showItem(abstractTabItem);
        abstractTabItem.setData(iPresentablePart);
        this.initTab(abstractTabItem, iPresentablePart);
        iPresentablePart.addPropertyListener(this.childPropertyChangeListener);
        this.partList.add(iPresentablePart);
    }

    @Override
    public void remove(IPresentablePart iPresentablePart) {
        if (iPresentablePart == this.current) {
            this.select(null);
        }
        this.internalRemove(iPresentablePart);
    }

    private void internalRemove(IPresentablePart iPresentablePart) {
        AbstractTabItem abstractTabItem = this.getTab(iPresentablePart);
        if (abstractTabItem != null) {
            abstractTabItem.dispose();
        }
        if (this.partList.contains(iPresentablePart)) {
            iPresentablePart.removePropertyListener(this.childPropertyChangeListener);
            this.partList.remove(iPresentablePart);
        }
    }

    @Override
    public void move(IPresentablePart iPresentablePart, int n) {
        int n2 = this.indexOf(iPresentablePart);
        if (n2 == n) {
            return;
        }
        this.internalRemove(iPresentablePart);
        this.insert(iPresentablePart, n);
        if (this.current == iPresentablePart) {
            this.folder.setSelection(this.getTab(iPresentablePart));
        }
    }

    @Override
    public int size() {
        return this.folder.getItemCount();
    }

    public void setBounds(Rectangle rectangle) {
        Point point = this.folder.computeSize(rectangle.width, -1);
        if (this.folder.getState() == 0 && point.y < rectangle.height) {
            rectangle = Geometry.copy((Rectangle)rectangle);
            rectangle.height = point.y;
        }
        this.folder.getControl().setBounds(rectangle);
        this.layout(false);
    }

    @Override
    public void select(IPresentablePart iPresentablePart) {
        if (iPresentablePart == this.current) {
            return;
        }
        if (iPresentablePart != null) {
            iPresentablePart.setVisible(true);
        }
        if (this.current != null) {
            this.current.setVisible(false);
            this.setToolbar(null);
        }
        this.current = iPresentablePart;
        AbstractTabItem abstractTabItem = this.getTab(iPresentablePart);
        this.folder.setSelection(abstractTabItem);
        if (abstractTabItem != null) {
            abstractTabItem.setBold(false);
            this.initTab(abstractTabItem, iPresentablePart);
        } else {
            this.setToolbar(null);
        }
        this.layout(true);
    }

    private void setToolbar(Control control) {
        if (this.folder.getToolbar() != control) {
            this.folder.setToolbar(control);
        }
    }

    private void childPropertyChanged(IPresentablePart iPresentablePart, int n) {
        AbstractTabItem abstractTabItem = this.getTab(iPresentablePart);
        switch (n) {
            case 148: {
                if (abstractTabItem == null || this.getCurrent() == iPresentablePart) break;
                abstractTabItem.setBold(true);
                this.initTab(abstractTabItem, iPresentablePart);
                break;
            }
            case 147: {
                if (abstractTabItem != null && this.getCurrent() == iPresentablePart) {
                    this.folder.flushToolbarSize();
                }
            }
            case 1: 
            case 261: 
            case 770: {
                if (abstractTabItem == null) break;
                this.initTab(abstractTabItem, iPresentablePart);
                if (this.getCurrent() != iPresentablePart) break;
                this.layout(true);
                break;
            }
            case 771: {
                this.folder.fireEvent(new TabFolderEvent(13, abstractTabItem, 0, 0));
                break;
            }
            default: {
                if (abstractTabItem == null) break;
                this.initTab(abstractTabItem, iPresentablePart);
            }
        }
    }

    protected void initTab(AbstractTabItem abstractTabItem, IPresentablePart iPresentablePart) {
        tempPartInfo.set(iPresentablePart);
        abstractTabItem.setInfo(tempPartInfo);
        abstractTabItem.setBusy(iPresentablePart.isBusy());
        if (iPresentablePart == this.getCurrent()) {
            this.folder.setSelectedInfo(tempPartInfo);
            this.folder.enablePaneMenu(iPresentablePart.getMenu() != null);
            this.setToolbar(iPresentablePart.getToolBar());
        }
    }

    public boolean isDisposed() {
        return SwtUtil.isDisposed(this.folder.getControl());
    }

    public IPresentablePart getPartForTab(AbstractTabItem abstractTabItem) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (abstractTabItem == null) {
            return null;
        }
        IPresentablePart iPresentablePart = (IPresentablePart)abstractTabItem.getData();
        return iPresentablePart;
    }

    public AbstractTabItem getTab(IPresentablePart iPresentablePart) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.folder.findItem(iPresentablePart);
    }

    public int indexOf(IPresentablePart iPresentablePart) {
        AbstractTabItem abstractTabItem = this.getTab(iPresentablePart);
        if (abstractTabItem == null) {
            return -1;
        }
        return this.folder.indexOf(abstractTabItem);
    }

    public AbstractTabFolder getTabFolder() {
        return this.folder;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        this.getTabFolder().setVisible(bl);
        if (bl) {
            this.layout(true);
        }
    }

    public void layout(boolean bl) {
        if (!this.isVisible) {
            return;
        }
        this.folder.layout(bl);
        this.layoutContent();
    }

    public IPresentablePart getCurrent() {
        return this.current;
    }
}

