/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.presentations.util.IPresentablePartList;
import org.eclipse.ui.internal.presentations.util.TabOrder;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;

public class LeftToRightTabOrder
extends TabOrder {
    private IPresentablePartList list;

    public LeftToRightTabOrder(IPresentablePartList iPresentablePartList) {
        this.list = iPresentablePartList;
    }

    @Override
    public void add(IPresentablePart iPresentablePart) {
        this.list.insert(iPresentablePart, this.list.size());
    }

    @Override
    public void addInitial(IPresentablePart iPresentablePart) {
        this.add(iPresentablePart);
    }

    @Override
    public void insert(IPresentablePart iPresentablePart, int n) {
        this.list.insert(iPresentablePart, n);
    }

    @Override
    public void remove(IPresentablePart iPresentablePart) {
        this.list.remove(iPresentablePart);
    }

    @Override
    public void select(IPresentablePart iPresentablePart) {
        this.list.select(iPresentablePart);
    }

    @Override
    public void move(IPresentablePart iPresentablePart, int n) {
        this.list.move(iPresentablePart, n);
    }

    @Override
    public IPresentablePart[] getPartList() {
        return this.list.getPartList();
    }

    @Override
    public void restoreState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren("part");
        int n = 0;
        while (n < iMementoArray.length) {
            IPresentablePart iPresentablePart;
            String string = iMementoArray[n].getString("id");
            if (string != null && (iPresentablePart = iPresentationSerializer.getPart(string)) != null) {
                this.addInitial(iPresentablePart);
            }
            ++n;
        }
    }

    @Override
    public void saveState(IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
        List<IPresentablePart> list = Arrays.asList(this.list.getPartList());
        for (IPresentablePart iPresentablePart : list) {
            IMemento iMemento2 = iMemento.createChild("part");
            iMemento2.putString("id", iPresentationSerializer.getId(iPresentablePart));
        }
    }
}

