/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.internal.presentations.util.TabFolderListener;
import org.eclipse.ui.presentations.PresentationUtil;

public abstract class AbstractTabFolder {
    private List listeners = new ArrayList(1);
    private Control toolbar;
    private int state;
    private int activeState = 2;
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            AbstractTabFolder.this.handleContextMenu(point, event);
        }
    };
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = ((Control)event.widget).toDisplay(event.x, event.y);
            AbstractTabFolder.this.handleDragStarted(point, event);
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            Point point = ((Control)mouseEvent.widget).toDisplay(mouseEvent.x, mouseEvent.y);
            AbstractTabFolder.this.handleMouseDown(point, mouseEvent);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (mouseEvent.button != 1) {
                return;
            }
            Point point = ((Control)mouseEvent.widget).toDisplay(mouseEvent.x, mouseEvent.y);
            AbstractTabFolder.this.handleDoubleClick(point, mouseEvent);
        }
    };

    public abstract Point computeSize(int var1, int var2);

    public abstract AbstractTabItem add(int var1, int var2);

    public abstract Composite getContentParent();

    public abstract void setContent(Control var1);

    public abstract AbstractTabItem[] getItems();

    public abstract AbstractTabItem getSelection();

    public abstract void setSelection(AbstractTabItem var1);

    public abstract void setSelectedInfo(PartInfo var1);

    public abstract void enablePaneMenu(boolean var1);

    public void setActive(int n) {
        this.activeState = n;
    }

    public int getActive() {
        return this.activeState;
    }

    public Point getPaneMenuLocation() {
        return this.getControl().toDisplay(new Point(0, 0));
    }

    public Point getPartListLocation() {
        return this.getSystemMenuLocation();
    }

    public Point getSystemMenuLocation() {
        return this.getControl().toDisplay(new Point(0, 0));
    }

    public abstract Composite getToolbarParent();

    public abstract Control getControl();

    public AbstractTabItem getItem(int n) {
        return this.getItems()[n];
    }

    public AbstractTabItem getItem(Point point) {
        AbstractTabItem[] abstractTabItemArray = this.getItems();
        int n = 0;
        while (n < abstractTabItemArray.length) {
            AbstractTabItem abstractTabItem = abstractTabItemArray[n];
            if (abstractTabItem.getBounds().contains(point)) {
                return abstractTabItem;
            }
            ++n;
        }
        return null;
    }

    public AbstractTabItem findItem(Object object) {
        AbstractTabItem[] abstractTabItemArray = this.getItems();
        int n = 0;
        while (n < abstractTabItemArray.length) {
            AbstractTabItem abstractTabItem = abstractTabItemArray[n];
            if (abstractTabItem.getData() == object) {
                return abstractTabItem;
            }
            ++n;
        }
        return null;
    }

    public int indexOf(AbstractTabItem abstractTabItem) {
        AbstractTabItem[] abstractTabItemArray = this.getItems();
        int n = 0;
        while (n < abstractTabItemArray.length) {
            AbstractTabItem abstractTabItem2 = abstractTabItemArray[n];
            if (abstractTabItem2 == abstractTabItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public void setToolbar(Control control) {
        this.toolbar = control;
    }

    public final Control getToolbar() {
        return this.toolbar;
    }

    public void setState(int n) {
        this.state = n;
    }

    public abstract Rectangle getTabArea();

    public void shellActive(boolean bl) {
    }

    public final void addListener(TabFolderListener tabFolderListener) {
        this.listeners.add(tabFolderListener);
    }

    public final void removeListener(TabFolderListener tabFolderListener) {
        this.listeners.remove(tabFolderListener);
    }

    public void flushToolbarSize() {
    }

    protected final void fireEvent(TabFolderEvent tabFolderEvent) {
        for (TabFolderListener tabFolderListener : this.listeners) {
            tabFolderListener.handleEvent(tabFolderEvent);
        }
    }

    protected final void fireEvent(int n) {
        this.fireEvent(new TabFolderEvent(n));
    }

    protected final void fireEvent(int n, AbstractTabItem abstractTabItem) {
        this.fireEvent(new TabFolderEvent(n, abstractTabItem, 0, 0));
    }

    protected final void fireEvent(int n, AbstractTabItem abstractTabItem, Point point) {
        this.fireEvent(new TabFolderEvent(n, abstractTabItem, point));
    }

    public void layout(boolean bl) {
    }

    public void setTabPosition(int n) {
    }

    public int getTabPosition() {
        return 128;
    }

    public int getState() {
        return this.state;
    }

    protected void attachListeners(Control control, boolean bl) {
        control.addListener(35, this.menuListener);
        control.addMouseListener(this.mouseListener);
        PresentationUtil.addDragListener(control, this.dragListener);
        if (bl && control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control2 = controlArray[n];
                this.attachListeners(control2, bl);
                ++n;
            }
        }
    }

    protected void detachListeners(Control control, boolean bl) {
        control.removeListener(35, this.menuListener);
        control.removeMouseListener(this.mouseListener);
        PresentationUtil.removeDragListener(control, this.dragListener);
        if (bl && control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control2 = controlArray[n];
                this.detachListeners(control2, bl);
                ++n;
            }
        }
    }

    protected void handleContextMenu(Point point, Event event) {
        if (this.isOnBorder(point)) {
            return;
        }
        AbstractTabItem abstractTabItem = this.getItem(point);
        this.fireEvent(12, abstractTabItem, point);
    }

    protected void handleMouseDown(Point point, MouseEvent mouseEvent) {
        this.fireEvent(9);
    }

    protected void handleDoubleClick(Point point, MouseEvent mouseEvent) {
        if (this.isOnBorder(point)) {
            return;
        }
        if (this.getState() == 1) {
            this.fireEvent(4);
        } else {
            this.fireEvent(7);
        }
    }

    protected void handleDragStarted(Point point, Event event) {
        if (this.isOnBorder(point)) {
            return;
        }
        AbstractTabItem abstractTabItem = this.getItem(point);
        this.fireEvent(10, abstractTabItem, point);
    }

    public boolean isOnBorder(Point point) {
        return false;
    }

    public void setVisible(boolean bl) {
        this.getControl().setVisible(bl);
    }

    public void showMinMax(boolean bl) {
    }

    public void showItem(AbstractTabItem abstractTabItem) {
        this.setSelection(abstractTabItem);
    }
}

