/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.presentations.defaultpresentation.NativeTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.ProxyControl;
import org.eclipse.ui.internal.presentations.util.StandardSystemToolbar;
import org.eclipse.ui.internal.util.Util;

public class NativeTabFolder
extends AbstractTabFolder {
    private TabFolder control;
    private ViewForm viewForm;
    private StandardSystemToolbar systemToolbar;
    private CLabel title;
    private ProxyControl topCenter;
    private SizeCache topCenterCache;
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            NativeTabFolder.this.fireEvent(8, NativeTabFolder.this.getTab(event.item));
        }
    };
    private IPropertyListener systemToolbarListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            Point point = n == 1 ? NativeTabFolder.this.getPaneMenuLocation() : new Point(0, 0);
            NativeTabFolder.this.fireEvent(n, NativeTabFolder.this.getSelection(), point);
        }
    };

    public NativeTabFolder(Composite composite) {
        this.control = new TabFolder(composite, 1024);
        this.control.addListener(13, this.selectionListener);
        this.attachListeners((Control)this.control, false);
        this.viewForm = new ViewForm((Composite)this.control, 0x800000);
        this.attachListeners((Control)this.viewForm, false);
        this.systemToolbar = new StandardSystemToolbar((Composite)this.viewForm, true, false, true, true, true);
        this.systemToolbar.addListener(this.systemToolbarListener);
        this.viewForm.setTopRight(this.systemToolbar.getControl());
        this.topCenter = new ProxyControl((Composite)this.viewForm);
        this.topCenterCache = new SizeCache();
        this.title = new CLabel((Composite)this.viewForm, 16384);
        this.attachListeners((Control)this.title, false);
        this.viewForm.setTopLeft((Control)this.title);
    }

    @Override
    public Point computeSize(int n, int n2) {
        return new Point(50, 50);
    }

    @Override
    public AbstractTabItem add(int n, int n2) {
        NativeTabItem nativeTabItem = new NativeTabItem(this, n);
        nativeTabItem.getWidget().setData((Object)nativeTabItem);
        return nativeTabItem;
    }

    @Override
    public void layout(boolean bl) {
        super.layout(bl);
        Rectangle rectangle = this.viewForm.getBounds();
        Rectangle rectangle2 = this.control.getClientArea();
        this.viewForm.setBounds(rectangle2);
        if (Util.equals(rectangle, rectangle2)) {
            this.viewForm.layout(bl);
        }
    }

    @Override
    public Point getPaneMenuLocation() {
        return this.systemToolbar.getPaneMenuLocation();
    }

    @Override
    public void setState(int n) {
        super.setState(n);
        this.systemToolbar.setState(n);
    }

    public Rectangle getClientArea() {
        Control control = this.viewForm.getContent();
        if (control == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return Geometry.toControl((Control)this.control, (Rectangle)DragUtil.getDisplayBounds(control));
    }

    @Override
    public AbstractTabItem[] getItems() {
        TabItem[] tabItemArray = this.control.getItems();
        AbstractTabItem[] abstractTabItemArray = new AbstractTabItem[tabItemArray.length];
        int n = 0;
        while (n < abstractTabItemArray.length) {
            abstractTabItemArray[n] = this.getTab((Widget)tabItemArray[n]);
            ++n;
        }
        return abstractTabItemArray;
    }

    private AbstractTabItem getTab(Widget widget) {
        return (AbstractTabItem)widget.getData();
    }

    @Override
    public void setSelection(AbstractTabItem abstractTabItem) {
        if (abstractTabItem == null) {
            return;
        }
        NativeTabItem nativeTabItem = (NativeTabItem)abstractTabItem;
        this.control.setSelection(new TabItem[]{(TabItem)nativeTabItem.getWidget()});
    }

    @Override
    public void setSelectedInfo(PartInfo partInfo) {
        if (!Util.equals(this.title.getText(), partInfo.title)) {
            this.title.setText(partInfo.title);
        }
        if (this.title.getImage() != partInfo.image) {
            this.title.setImage(partInfo.image);
        }
    }

    @Override
    public Composite getToolbarParent() {
        return this.viewForm;
    }

    @Override
    public Rectangle getTabArea() {
        Rectangle rectangle = this.control.getBounds();
        Rectangle rectangle2 = this.control.getClientArea();
        rectangle.x = 0;
        rectangle.y = 0;
        Geometry.expand((Rectangle)rectangle, (int)0, (int)0, (int)(-(rectangle2.height + rectangle2.y)), (int)0);
        return Geometry.toDisplay((Control)this.control.getParent(), (Rectangle)rectangle);
    }

    @Override
    public void setToolbar(Control control) {
        if (control != null) {
            this.topCenterCache.setControl(control);
            this.topCenter.setTarget(this.topCenterCache);
            this.viewForm.setTopCenter(this.topCenter.getControl());
        } else {
            this.topCenterCache.setControl(null);
            this.topCenter.setTarget(null);
            this.viewForm.setTopCenter(null);
        }
        super.setToolbar(control);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public boolean isOnBorder(Point point) {
        Point point2 = this.getControl().toControl(point);
        Rectangle rectangle = this.getClientArea();
        return point2.y > rectangle.y && point2.y < rectangle.y + rectangle.height;
    }

    @Override
    public AbstractTabItem getSelection() {
        TabItem[] tabItemArray = this.control.getSelection();
        if (tabItemArray.length == 0) {
            return null;
        }
        return this.getTab((Widget)tabItemArray[0]);
    }

    @Override
    public Composite getContentParent() {
        return this.viewForm;
    }

    @Override
    public void setContent(Control control) {
        this.viewForm.setContent(control);
    }

    public TabFolder getTabFolder() {
        return this.control;
    }

    void setSelectedTitle(String string) {
        this.title.setText(string);
    }

    void setSelectedImage(Image image) {
        this.title.setImage(image);
    }

    @Override
    public AbstractTabItem getItem(Point point) {
        return this.getSelection();
    }

    @Override
    public void enablePaneMenu(boolean bl) {
        this.systemToolbar.enablePaneMenu(bl);
    }
}

