/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.presentations.defaultpresentation.EmptyTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.EnhancedFillLayout;
import org.eclipse.ui.internal.presentations.util.PartInfo;

public class EmptyTabFolder
extends AbstractTabFolder {
    private Composite control;
    private Control childControl;
    private Color borderColor;

    public EmptyTabFolder(Composite composite, boolean bl) {
        this.control = new Composite(composite, 0);
        EnhancedFillLayout enhancedFillLayout = new EnhancedFillLayout();
        this.control.setLayout((Layout)enhancedFillLayout);
        this.borderColor = composite.getDisplay().getSystemColor(18);
        if (bl) {
            enhancedFillLayout.xmargin = 1;
            enhancedFillLayout.ymargin = 1;
            this.control.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    paintEvent.gc.setForeground(EmptyTabFolder.this.borderColor);
                    Rectangle rectangle = EmptyTabFolder.this.control.getClientArea();
                    --rectangle.width;
                    --rectangle.height;
                    paintEvent.gc.drawRectangle(rectangle);
                }
            });
        }
    }

    @Override
    public Point computeSize(int n, int n2) {
        if (this.childControl != null) {
            Composite composite;
            if (this.childControl instanceof Composite && (composite = (Composite)this.childControl).getChildren().length == 0) {
                EnhancedFillLayout enhancedFillLayout = (EnhancedFillLayout)this.control.getLayout();
                int n3 = n == -1 ? enhancedFillLayout.xmargin * 2 : n;
                int n4 = n2 == -1 ? enhancedFillLayout.ymargin * 2 : n2;
                return new Point(n3, n4);
            }
            return this.childControl.computeSize(n, n2);
        }
        return new Point(0, 0);
    }

    @Override
    public AbstractTabItem add(int n, int n2) {
        return new EmptyTabItem();
    }

    @Override
    public Composite getContentParent() {
        return this.control;
    }

    @Override
    public void setContent(Control control) {
        this.childControl = control;
    }

    @Override
    public AbstractTabItem[] getItems() {
        return new AbstractTabItem[0];
    }

    @Override
    public AbstractTabItem getSelection() {
        return null;
    }

    @Override
    public void setSelection(AbstractTabItem abstractTabItem) {
    }

    @Override
    public void setToolbar(Control control) {
        if (control != null) {
            control.setVisible(false);
        }
    }

    @Override
    public void layout(boolean bl) {
        super.layout(bl);
        this.control.layout(bl);
    }

    @Override
    public void setSelectedInfo(PartInfo partInfo) {
    }

    @Override
    public void enablePaneMenu(boolean bl) {
    }

    @Override
    public Composite getToolbarParent() {
        return this.control;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public Rectangle getTabArea() {
        return new Rectangle(0, 0, 0, 0);
    }
}

