/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.preferences.AbstractPropertyListener;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.PropertyUtil;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolderColors;
import org.eclipse.ui.internal.themes.LightColorFactory;

public class DefaultThemeListener
extends AbstractPropertyListener {
    private DefaultTabFolder folder;
    private IPropertyMap theme;

    public DefaultThemeListener(DefaultTabFolder defaultTabFolder, IPropertyMap iPropertyMap) {
        this.folder = defaultTabFolder;
        this.theme = iPropertyMap;
    }

    private Color getColor(String string, Color color) {
        Color color2 = (Color)this.theme.getValue(string, Color.class);
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    private int getInt(String string, int n) {
        Integer n2 = (Integer)this.theme.getValue(string, Integer.class);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    private boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.theme.getValue(string, Boolean.class);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    private boolean updateHighlightColor() {
        if (!this.useHighlight()) {
            return false;
        }
        RGB rGB = this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", null).getRGB();
        RGB rGB2 = LightColorFactory.createHighlightStartColor(rGB);
        JFaceResources.getColorRegistry().put("org.eclipse.ui.workbench.ACTIVE_TAB_HIGHLIGHT_START", rGB2);
        return true;
    }

    private boolean useHighlight() {
        return PropertyUtil.get(this.theme, "org.eclipse.ui.workbench.ACTIVE_TAB_HIGHLIGHT", false);
    }

    @Override
    public void update() {
        Color[] colorArray;
        if (this.updateHighlightColor()) {
            Color[] colorArray2 = new Color[3];
            colorArray2[0] = this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", null);
            colorArray2[1] = this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", null);
            colorArray = colorArray2;
            colorArray2[2] = JFaceResources.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_HIGHLIGHT_START");
        } else {
            Color[] colorArray3 = new Color[2];
            colorArray3[0] = this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", null);
            colorArray = colorArray3;
            colorArray3[1] = this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", null);
        }
        Color[] colorArray4 = colorArray;
        this.folder.setColors(new DefaultTabFolderColors(this.getColor("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR", null), colorArray4, new int[]{this.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT", 0)}, this.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL", true)), 1, true);
        this.folder.setColors(new DefaultTabFolderColors(this.getColor("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_TEXT_COLOR", null), new Color[]{this.getColor("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START", null), this.getColor("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END", null)}, new int[]{this.getInt("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_PERCENT", 0)}, this.getBoolean("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_VERTICAL", true)), 1, false);
        this.folder.setColors(new DefaultTabFolderColors(this.getColor("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", null), new Color[]{this.getColor("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START", null), this.getColor("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END", null)}, new int[]{this.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT", 0)}, this.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL", true)), 0);
        this.folder.setColors(new DefaultTabFolderColors(this.getColor("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", null), new Color[]{this.getColor("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START", null)}, new int[0], true), 2);
        this.folder.setFont((Font)this.theme.getValue("org.eclipse.ui.workbench.TAB_TEXT_FONT", Font.class));
    }
}

