/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.WidgetTabItem;
import org.eclipse.ui.internal.util.Util;

public class DefaultTabItem
extends WidgetTabItem {
    public static String DIRTY_PREFIX = "*";
    private boolean busy = false;
    private boolean bold = false;
    private Font lastFont = null;
    private String shortName = "";
    private String longName = "";

    public DefaultTabItem(CTabFolder cTabFolder, int n, int n2) {
        super((Widget)DefaultTabItem.getTab(cTabFolder, n, n2));
        this.updateFont();
    }

    private static CTabItem getTab(CTabFolder cTabFolder, int n, int n2) {
        return new CTabItem(cTabFolder, n2, n);
    }

    @Override
    public Rectangle getBounds() {
        return Geometry.toDisplay((Control)this.getItem().getParent(), (Rectangle)this.getItem().getBounds());
    }

    public CTabItem getItem() {
        return (CTabItem)this.getWidget();
    }

    @Override
    public boolean isShowing() {
        return this.getItem().isShowing();
    }

    @Override
    public void setInfo(PartInfo partInfo) {
        String string;
        CTabItem cTabItem = this.getItem();
        this.shortName = DefaultTabItem.computeShortName(partInfo);
        this.longName = DefaultTabItem.computeLongName(partInfo);
        this.updateTabText();
        if (cTabItem.getImage() != partInfo.image) {
            cTabItem.setImage(partInfo.image);
        }
        if ((string = partInfo.toolTip).equals("")) {
            string = null;
        }
        if (!Util.equals(string, cTabItem.getToolTipText())) {
            if (string != null) {
                string = DefaultTabItem.escapeAmpersands(string);
            }
            cTabItem.setToolTipText(string);
        }
    }

    public void updateTabText() {
        CTabItem cTabItem = this.getItem();
        String string = cTabItem.getParent().getSingle() ? this.longName : this.shortName;
        if (!Util.equals(string = DefaultTabItem.escapeAmpersands(string), cTabItem.getText())) {
            cTabItem.setText(string);
        }
    }

    public static String escapeAmpersands(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(c);
            if (c == '&') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public void setBold(boolean bl) {
        this.bold = bl;
        super.setBold(bl);
        this.updateFont();
    }

    @Override
    public void setBusy(boolean bl) {
        this.busy = bl;
        super.setBusy(bl);
        this.updateFont();
    }

    private void updateFont() {
        CTabItem cTabItem = this.getItem();
        FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        Font font = null;
        if (this.busy) {
            font = fontRegistry.getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        } else if (this.bold) {
            font = fontRegistry.getBold("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        }
        if (this.lastFont != font) {
            cTabItem.setFont(font);
            this.lastFont = font;
        }
    }

    private static String computeShortName(PartInfo partInfo) {
        String string = partInfo.name;
        if (partInfo.dirty) {
            string = String.valueOf(DIRTY_PREFIX) + string;
        }
        return string;
    }

    private static String computeLongName(PartInfo partInfo) {
        String string = partInfo.name;
        String string2 = partInfo.contentDescription;
        if (string2.equals("")) {
            String string3 = partInfo.toolTip.trim();
            if (string3.endsWith(partInfo.name)) {
                string3 = string3.substring(0, string3.lastIndexOf(partInfo.name)).trim();
            }
            if (string3.endsWith("\\")) {
                string3 = string3.substring(0, string3.lastIndexOf("\\")).trim();
            }
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.lastIndexOf("/")).trim();
            }
            string2 = string3;
        }
        if (!string2.equals("")) {
            string = MessageFormat.format((String)WorkbenchMessages.EditorPart_AutoTitleFormat, (Object[])new String[]{string, string2});
        }
        if (partInfo.dirty) {
            string = String.valueOf(DIRTY_PREFIX) + string;
        }
        return string;
    }
}

