/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.defaultpresentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.presentations.PaneFolderButtonListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolderColors;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.internal.util.Util;

public class DefaultTabFolder
extends AbstractTabFolder {
    private PaneFolder paneFolder;
    private Control viewToolBar;
    private Label titleLabel;
    private PaneFolderButtonListener buttonListener = new PaneFolderButtonListener(){

        @Override
        public void stateButtonPressed(int n) {
            DefaultTabFolder.this.fireEvent(TabFolderEvent.stackStateToEventId(n));
        }

        @Override
        public void closeButtonPressed(CTabItem cTabItem) {
            DefaultTabFolder.this.fireEvent(6, DefaultTabFolder.this.getTab(cTabItem));
        }

        @Override
        public void showList(CTabFolderEvent cTabFolderEvent) {
            cTabFolderEvent.doit = false;
            DefaultTabFolder.this.fireEvent(11);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            DefaultTabItem defaultTabItem = DefaultTabFolder.this.getTab((CTabItem)event.item);
            if (defaultTabItem != null) {
                DefaultTabFolder.this.fireEvent(8, defaultTabItem);
            }
        }
    };
    private static DefaultTabFolderColors defaultColors = new DefaultTabFolderColors();
    private DefaultTabFolderColors[] activeShellColors = new DefaultTabFolderColors[]{defaultColors, defaultColors, defaultColors};
    private DefaultTabFolderColors[] inactiveShellColors = new DefaultTabFolderColors[]{defaultColors, defaultColors, defaultColors};
    private boolean shellActive = false;

    public DefaultTabFolder(Composite composite, int n, boolean bl, boolean bl2) {
        this.paneFolder = new PaneFolder(composite, n | 0x40000);
        this.paneFolder.addButtonListener(this.buttonListener);
        this.paneFolder.setMinimizeVisible(bl);
        this.paneFolder.setMaximizeVisible(bl2);
        this.paneFolder.getControl().addListener(13, this.selectionListener);
        this.paneFolder.setTopRight(null);
        ToolBar toolBar = new ToolBar(this.paneFolder.getControl(), 0x840000);
        this.viewToolBar = toolBar;
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = WorkbenchMessages.ViewMenu;
            }
        });
        ToolItem toolItem = new ToolItem(toolBar, 8);
        Image image = WorkbenchImages.getImage("IMG_LCL_RENDERED_VIEW_MENU");
        toolItem.setDisabledImage(image);
        toolItem.setImage(image);
        toolItem.setToolTipText(WorkbenchMessages.ViewMenu);
        toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                DefaultTabFolder.this.fireEvent(1, DefaultTabFolder.this.getSelection(), DefaultTabFolder.this.getPaneMenuLocation());
            }
        });
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefaultTabFolder.this.fireEvent(1, DefaultTabFolder.this.getSelection(), DefaultTabFolder.this.getPaneMenuLocation());
                super.widgetSelected(selectionEvent);
            }
        });
        this.titleLabel = new Label(this.paneFolder.getControl(), 0);
        this.titleLabel.moveAbove(null);
        this.titleLabel.setVisible(false);
        this.attachListeners((Control)this.titleLabel, false);
        this.attachListeners((Control)this.paneFolder.getControl(), false);
        this.attachListeners((Control)this.paneFolder.getViewForm(), false);
        this.paneFolder.setTabHeight(this.computeTabHeight());
        this.viewToolBar.moveAbove(null);
    }

    public void setMinimumCharacters(int n) {
        this.paneFolder.setMinimumCharacters(n);
    }

    public void setSimpleTabs(boolean bl) {
        this.paneFolder.setSimpleTab(bl);
    }

    protected DefaultTabItem getTab(CTabItem cTabItem) {
        return (DefaultTabItem)cTabItem.getData();
    }

    @Override
    public Point computeSize(int n, int n2) {
        return this.paneFolder.computeMinimumSize();
    }

    PaneFolder getFolder() {
        return this.paneFolder;
    }

    @Override
    public AbstractTabItem getSelection() {
        return this.getTab(this.paneFolder.getSelection());
    }

    @Override
    public AbstractTabItem add(int n, int n2) {
        DefaultTabItem defaultTabItem = new DefaultTabItem((CTabFolder)this.getFolder().getControl(), n, n2);
        defaultTabItem.getWidget().setData((Object)defaultTabItem);
        return defaultTabItem;
    }

    @Override
    public Composite getContentParent() {
        return this.paneFolder.getContentParent();
    }

    @Override
    public void setContent(Control control) {
        this.paneFolder.setContent(control);
    }

    @Override
    public AbstractTabItem[] getItems() {
        CTabItem[] cTabItemArray = this.paneFolder.getItems();
        AbstractTabItem[] abstractTabItemArray = new AbstractTabItem[cTabItemArray.length];
        int n = 0;
        while (n < abstractTabItemArray.length) {
            abstractTabItemArray[n] = this.getTab(cTabItemArray[n]);
            ++n;
        }
        return abstractTabItemArray;
    }

    @Override
    public int getItemCount() {
        return this.paneFolder.getItemCount();
    }

    @Override
    public void setSelection(AbstractTabItem abstractTabItem) {
        this.paneFolder.setSelection(this.indexOf(abstractTabItem));
    }

    @Override
    public void showItem(AbstractTabItem abstractTabItem) {
        int n = this.indexOf(abstractTabItem);
        if (n != -1) {
            this.paneFolder.showItem(n);
        }
    }

    @Override
    public Composite getToolbarParent() {
        return this.paneFolder.getControl();
    }

    @Override
    public Control getControl() {
        return this.paneFolder.getControl();
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.paneFolder.setUnselectedCloseVisible(bl);
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.paneFolder.setUnselectedImageVisible(bl);
    }

    @Override
    public Rectangle getTabArea() {
        return Geometry.toDisplay((Control)this.paneFolder.getControl(), (Rectangle)this.paneFolder.getTitleArea());
    }

    @Override
    public void enablePaneMenu(boolean bl) {
        if (bl) {
            this.paneFolder.setTopRight(this.viewToolBar);
            this.viewToolBar.setVisible(true);
        } else {
            this.paneFolder.setTopRight(null);
            this.viewToolBar.setVisible(false);
        }
    }

    @Override
    public void setSelectedInfo(PartInfo partInfo) {
        String string = DefaultTabItem.escapeAmpersands(partInfo.contentDescription);
        if (!Util.equals(this.titleLabel.getText(), string)) {
            this.titleLabel.setText(string);
            this.titleLabel.setToolTipText(string);
        }
        if (!partInfo.contentDescription.equals("")) {
            this.paneFolder.flushTopLeftSize();
            this.paneFolder.setTopLeft((Control)this.titleLabel);
            this.titleLabel.setVisible(true);
        } else {
            this.paneFolder.setTopLeft(null);
            this.titleLabel.setVisible(false);
        }
    }

    @Override
    public Point getPaneMenuLocation() {
        Point point = this.viewToolBar.getSize();
        return this.viewToolBar.toDisplay(0, point.y);
    }

    @Override
    public Point getPartListLocation() {
        return this.paneFolder.getControl().toDisplay(this.paneFolder.getChevronLocation());
    }

    @Override
    public Point getSystemMenuLocation() {
        CTabItem cTabItem;
        Rectangle rectangle = DragUtil.getDisplayBounds((Control)this.paneFolder.getControl());
        int n = this.paneFolder.getSelectionIndex();
        if (n > -1) {
            cTabItem = this.paneFolder.getItem(n);
            Rectangle rectangle2 = cTabItem.getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
        }
        cTabItem = new Point(rectangle.x, rectangle.y + this.paneFolder.getTabHeight());
        return cTabItem;
    }

    @Override
    public boolean isOnBorder(Point point) {
        Control control = this.paneFolder.getContent();
        if (control != null) {
            Rectangle rectangle = DragUtil.getDisplayBounds(control);
            if (this.paneFolder.getTabPosition() == 128) {
                return point.y >= rectangle.y;
            }
            if (point.y >= rectangle.y && point.y < rectangle.y + rectangle.height) {
                return true;
            }
        }
        return super.isOnBorder(point);
    }

    @Override
    public void layout(boolean bl) {
        this.paneFolder.layout(bl);
        super.layout(bl);
    }

    @Override
    public void setState(int n) {
        this.paneFolder.setState(n);
        super.setState(n);
    }

    @Override
    public void setActive(int n) {
        super.setActive(n);
        this.updateColors();
    }

    @Override
    public void setTabPosition(int n) {
        this.paneFolder.setTabPosition(n);
        super.setTabPosition(n);
        this.layout(true);
    }

    @Override
    public void flushToolbarSize() {
        this.paneFolder.flushTopCenterSize();
    }

    @Override
    public void setToolbar(Control control) {
        this.paneFolder.setTopCenter(control);
        super.setToolbar(control);
    }

    public void setColors(DefaultTabFolderColors defaultTabFolderColors, int n, boolean bl) {
        Assert.isTrue((n < this.activeShellColors.length ? 1 : 0) != 0);
        if (bl) {
            this.activeShellColors[n] = defaultTabFolderColors;
        } else {
            this.inactiveShellColors[n] = defaultTabFolderColors;
        }
        if (n == this.getActive() && this.shellActive == bl) {
            this.updateColors();
        }
    }

    public void updateColors() {
        DefaultTabFolderColors defaultTabFolderColors = this.shellActive ? this.activeShellColors[this.getActive()] : this.inactiveShellColors[this.getActive()];
        this.paneFolder.setSelectionForeground(defaultTabFolderColors.foreground);
        this.paneFolder.setSelectionBackground(defaultTabFolderColors.background, defaultTabFolderColors.percentages, defaultTabFolderColors.vertical);
    }

    public void setColors(DefaultTabFolderColors defaultTabFolderColors, int n) {
        this.setColors(defaultTabFolderColors, n, true);
        this.setColors(defaultTabFolderColors, n, false);
    }

    @Override
    public void shellActive(boolean bl) {
        this.shellActive = bl;
        super.shellActive(bl);
        this.updateColors();
    }

    public void setFont(Font font) {
        if (font != this.paneFolder.getControl().getFont()) {
            this.paneFolder.getControl().setFont(font);
            this.layout(true);
            this.paneFolder.setTabHeight(this.computeTabHeight());
        }
    }

    protected int computeTabHeight() {
        GC gC = new GC((Drawable)this.getControl());
        int n = Math.max(this.viewToolBar.computeSize((int)-1, (int)-1).y, gC.getFontMetrics().getHeight());
        gC.dispose();
        return n;
    }

    public void setSingleTab(boolean bl) {
        this.paneFolder.setSingleTab(bl);
        AbstractTabItem[] abstractTabItemArray = this.getItems();
        int n = 0;
        while (n < abstractTabItemArray.length) {
            DefaultTabItem defaultTabItem = (DefaultTabItem)abstractTabItemArray[n];
            defaultTabItem.updateTabText();
            ++n;
        }
        this.layout(true);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.getFolder().setVisible(bl);
    }

    @Override
    public void showMinMax(boolean bl) {
        this.paneFolder.showMinMax(bl);
    }
}

