/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.ViewStackTrimToolBar;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;

public class SystemMenuFastViewOrientation
extends ContributionItem {
    private PartPane viewPane;
    private IntModel currentOrientation = new IntModel(512);
    private ViewStackTrimToolBar minimizedStack = null;

    public SystemMenuFastViewOrientation(PartPane partPane) {
        this(partPane, null);
    }

    public SystemMenuFastViewOrientation(PartPane partPane, final ViewStackTrimToolBar viewStackTrimToolBar) {
        this.viewPane = partPane;
        this.minimizedStack = viewStackTrimToolBar;
        this.currentOrientation.addChangeListener(new IChangeListener(){

            @Override
            public void update(boolean bl) {
                if (bl) {
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)SystemMenuFastViewOrientation.this.viewPane.getPage().getWorkbenchWindow();
                    if (viewStackTrimToolBar == null) {
                        IWorkbenchPartReference iWorkbenchPartReference;
                        FastViewBar fastViewBar = workbenchWindow.getFastViewBar();
                        if (fastViewBar != null && SystemMenuFastViewOrientation.this.viewPane != null && (iWorkbenchPartReference = SystemMenuFastViewOrientation.this.viewPane.getPartReference()) instanceof IViewReference) {
                            fastViewBar.setOrientation((IViewReference)iWorkbenchPartReference, SystemMenuFastViewOrientation.this.currentOrientation.get());
                        }
                    } else {
                        viewStackTrimToolBar.setOrientation(SystemMenuFastViewOrientation.this.currentOrientation.get(), workbenchWindow);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void fill(Menu menu, int n) {
        FastViewBar fastViewBar;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPage().getWorkbenchWindow();
        IWorkbenchPartReference iWorkbenchPartReference = this.viewPane.getPartReference();
        if (!(iWorkbenchPartReference instanceof IViewReference)) {
            return;
        }
        if (this.minimizedStack == null) {
            fastViewBar = workbenchWindow.getFastViewBar();
            if (fastViewBar != null && this.viewPane != null) {
                this.currentOrientation.set(fastViewBar.getOrientation((IViewReference)iWorkbenchPartReference));
            }
        } else {
            this.currentOrientation.set(this.minimizedStack.getPaneOrientation());
        }
        fastViewBar = new MenuItem(menu, 64, n);
        fastViewBar.setText(WorkbenchMessages.FastViewBar_view_orientation);
        Menu menu2 = new Menu((MenuItem)fastViewBar);
        RadioMenu radioMenu = new RadioMenu(menu2, this.currentOrientation);
        radioMenu.addMenuItem(WorkbenchMessages.FastViewBar_horizontal, new Integer(256));
        radioMenu.addMenuItem(WorkbenchMessages.FastViewBar_vertical, new Integer(512));
        fastViewBar.setMenu(menu2);
    }

    public boolean isDynamic() {
        return true;
    }
}

