/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuFastView
extends Action
implements ISelfUpdatingAction {
    private PresentablePart viewPane;
    private IStackPresentationSite site;
    private boolean realFV = true;

    public SystemMenuFastView(IStackPresentationSite iStackPresentationSite) {
        this.site = iStackPresentationSite;
        this.setText(WorkbenchMessages.ViewPane_fastView);
        this.update();
    }

    public void setPane(PresentablePart presentablePart) {
        this.viewPane = presentablePart;
        this.update();
    }

    @Override
    public void update() {
        IViewReference iViewReference = this.getReference();
        if (iViewReference == null) {
            this.setEnabled(false);
            return;
        }
        Perspective perspective = this.viewPane.getPane().getPage().getActivePerspective();
        FastViewManager fastViewManager = perspective.getFastViewManager();
        String string = null;
        if (fastViewManager != null) {
            string = fastViewManager.getIdForRef(iViewReference);
        }
        boolean bl = this.realFV = string == null || FastViewBar.FASTVIEWBAR_ID.equals(string);
        if (this.realFV) {
            this.setText(WorkbenchMessages.ViewPane_fastView);
        } else {
            this.setText(WorkbenchMessages.StandardSystemToolbar_Restore);
            this.setChecked(false);
        }
        if (!this.site.isPartMoveable(this.viewPane)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            if (this.realFV) {
                this.setChecked(perspective.isFastView(iViewReference));
            }
        }
    }

    private IViewReference getReference() {
        IWorkbenchPartReference iWorkbenchPartReference;
        IViewReference iViewReference = null;
        if (this.viewPane != null && (iWorkbenchPartReference = this.viewPane.getPane().getPartReference()) instanceof IViewReference) {
            iViewReference = (IViewReference)iWorkbenchPartReference;
        }
        return iViewReference;
    }

    @Override
    public boolean shouldBeVisible() {
        if (this.viewPane == null || this.viewPane.getPane().getPage() == null) {
            return false;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.viewPane.getPane().getPage().getWorkbenchWindow();
        return workbenchWindow.getShowFastViewBars() && this.viewPane != null && this.site.isPartMoveable(this.viewPane);
    }

    public void dispose() {
        this.viewPane = null;
    }

    public void run() {
        if (this.realFV) {
            if (this.viewPane.getPane() instanceof ViewPane) {
                ViewPane viewPane = (ViewPane)this.viewPane.getPane();
                if (!this.isChecked()) {
                    viewPane.doMakeFast();
                } else {
                    viewPane.doRemoveFast();
                }
            }
        } else {
            IViewReference iViewReference = this.getReference();
            Perspective perspective = this.viewPane.getPane().getPage().getActivePerspective();
            FastViewManager fastViewManager = perspective.getFastViewManager();
            String string = fastViewManager.getIdForRef(iViewReference);
            fastViewManager.restoreToPresentation(string);
        }
    }
}

