/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuDetach
extends Action
implements ISelfUpdatingAction {
    private ViewPane viewPane;
    private IStackPresentationSite site;
    private WorkbenchPage page;

    public SystemMenuDetach(IStackPresentationSite iStackPresentationSite) {
        this.site = iStackPresentationSite;
        this.setText(WorkbenchMessages.PartPane_detach);
        this.update();
    }

    @Override
    public void update() {
        IPresentablePart iPresentablePart = this.site.getSelectedPart();
        this.setEnabled(iPresentablePart != null && this.site.isPartMoveable(iPresentablePart));
        if (this.viewPane != null) {
            this.setChecked(!this.viewPane.isDocked());
            this.page = this.viewPane.getPage();
        }
    }

    @Override
    public boolean shouldBeVisible() {
        if (this.page != null) {
            return this.page.getActivePerspective().getPresentation().canDetach();
        }
        return false;
    }

    public void dispose() {
        this.site = null;
    }

    public void setPane(ViewPane viewPane) {
        this.viewPane = viewPane;
        this.update();
    }

    public void run() {
        if (this.site != null) {
            if (!this.isChecked()) {
                this.viewPane.doDetach();
            } else {
                this.viewPane.doAttach();
            }
        }
    }
}

