/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class PresentationFactoryUtil {
    public static final int ROLE_EDITOR = 1;
    public static final int ROLE_VIEW = 2;
    public static final int ROLE_STANDALONE = 3;
    public static final int ROLE_STANDALONE_NOTITLE = 4;

    public static StackPresentation createPresentation(AbstractPresentationFactory abstractPresentationFactory, int n, Composite composite, IStackPresentationSite iStackPresentationSite, IPresentationSerializer iPresentationSerializer, IMemento iMemento) {
        StackPresentation stackPresentation = null;
        switch (n) {
            case 1: {
                stackPresentation = abstractPresentationFactory.createEditorPresentation(composite, iStackPresentationSite);
                break;
            }
            case 3: {
                stackPresentation = abstractPresentationFactory.createStandaloneViewPresentation(composite, iStackPresentationSite, true);
                break;
            }
            case 4: {
                stackPresentation = abstractPresentationFactory.createStandaloneViewPresentation(composite, iStackPresentationSite, false);
                break;
            }
            default: {
                stackPresentation = abstractPresentationFactory.createViewPresentation(composite, iStackPresentationSite);
            }
        }
        if (n != 1 && iMemento != null && iPresentationSerializer != null) {
            stackPresentation.restoreState(iPresentationSerializer, iMemento);
        }
        return stackPresentation;
    }

    private PresentationFactoryUtil() {
    }
}

