/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;

public class PresentablePart
implements IPresentablePart {
    private PartPane part;
    private List listeners = new ArrayList();
    private IPropertyListener lazyPropertyListenerProxy;
    private ListenerList partPropertyChangeListeners = new ListenerList();
    private IPropertyChangeListener lazyPartPropertyChangeListener;
    private IPartMenu viewMenu;
    private boolean enableInputs = true;
    private boolean enableOutputs = true;
    private Rectangle savedBounds = new Rectangle(0, 0, 0, 0);
    private boolean isVisible = false;
    private String name = "";
    private String titleStatus = "";
    private boolean isDirty = false;
    private boolean isBusy = false;
    private boolean hasViewMenu = false;

    public PresentablePart(PartPane partPane, Composite composite) {
        this.part = partPane;
        this.getPane().addPropertyListener(this.getPropertyListenerProxy());
        this.getPane().addPartPropertyListener(this.getPartPropertyListenerProxy());
    }

    public PartPane getPane() {
        return this.part;
    }

    private IPropertyListener getPropertyListenerProxy() {
        if (this.lazyPropertyListenerProxy == null) {
            this.lazyPropertyListenerProxy = new IPropertyListener(){

                @Override
                public void propertyChanged(Object object, int n) {
                    PresentablePart.this.firePropertyChange(n);
                }
            };
        }
        return this.lazyPropertyListenerProxy;
    }

    private IPropertyChangeListener getPartPropertyListenerProxy() {
        if (this.lazyPartPropertyChangeListener == null) {
            this.lazyPartPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent((Object)this, propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    PresentablePart.this.firePartPropertyChange(propertyChangeEvent2);
                }
            };
        }
        return this.lazyPartPropertyChangeListener;
    }

    public void dispose() {
        this.getPane().removePropertyListener(this.getPropertyListenerProxy());
        this.getPane().removePartPropertyListener(this.getPartPropertyListenerProxy());
        this.part = null;
        this.listeners.clear();
        this.listeners = null;
        this.partPropertyChangeListeners.clear();
        this.partPropertyChangeListeners = null;
    }

    public void firePropertyChange(int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((IPropertyListener)this.listeners.get(n2)).propertyChanged(this, n);
            ++n2;
        }
    }

    @Override
    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.listeners.add(iPropertyListener);
    }

    @Override
    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.listeners.remove(iPropertyListener);
    }

    protected void firePartPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.partPropertyChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    @Override
    public void addPartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partPropertyChangeListeners.add((Object)iPropertyChangeListener);
    }

    @Override
    public void removePartPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.partPropertyChangeListeners.remove((Object)iPropertyChangeListener);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.savedBounds = rectangle;
        if (this.enableInputs && !SwtUtil.isDisposed(this.part.getControl())) {
            this.part.setBounds(rectangle);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
        if (this.enableInputs) {
            this.part.setVisible(bl);
        }
    }

    @Override
    public void setFocus() {
        if (!SwtUtil.isDisposed(this.part.getControl())) {
            if (this.part.getPage().getActivePart() == this.part.getPartReference().getPart(false)) {
                this.part.setFocus();
            } else {
                this.part.requestActivation();
            }
        }
    }

    private WorkbenchPartReference getPartReference() {
        return (WorkbenchPartReference)this.part.getPartReference();
    }

    @Override
    public String getName() {
        if (this.enableOutputs) {
            return this.getPartReference().getPartName();
        }
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.getPartReference().getTitle();
    }

    @Override
    public String getTitleStatus() {
        if (this.enableOutputs) {
            return this.getPartReference().getContentDescription();
        }
        return this.titleStatus;
    }

    @Override
    public Image getTitleImage() {
        if (this.enableOutputs) {
            return this.getPartReference().getTitleImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    @Override
    public String getTitleToolTip() {
        return this.getPartReference().getTitleToolTip();
    }

    @Override
    public boolean isDirty() {
        if (this.enableOutputs) {
            return this.getPartReference().isDirty();
        }
        return this.isDirty;
    }

    @Override
    public boolean isBusy() {
        if (this.enableOutputs) {
            return this.part.isBusy();
        }
        return this.isBusy;
    }

    @Override
    public Control getToolBar() {
        if (this.enableOutputs) {
            return this.getPane().getToolBar();
        }
        return null;
    }

    @Override
    public IPartMenu getMenu() {
        boolean bl = this.enableOutputs ? this.part.hasViewMenu() : this.hasViewMenu;
        if (!bl) {
            return null;
        }
        if (this.viewMenu == null) {
            this.viewMenu = new IPartMenu(){

                @Override
                public void showMenu(Point point) {
                    PresentablePart.this.part.showViewMenu(point);
                }
            };
        }
        return this.viewMenu;
    }

    @Override
    public boolean isCloseable() {
        return this.part.isCloseable();
    }

    @Override
    public Control getControl() {
        return this.part.getControl();
    }

    public void enableOutputs(boolean bl) {
        if (bl == this.enableOutputs) {
            return;
        }
        this.enableOutputs = bl;
        if (bl) {
            if (this.isBusy != this.getPane().isBusy()) {
                this.firePropertyChange(146);
            }
            if (this.isDirty != this.isDirty()) {
                this.firePropertyChange(257);
            }
            if (!this.name.equals(this.getName())) {
                this.firePropertyChange(260);
            }
            if (!this.titleStatus.equals(this.getTitleStatus())) {
                this.firePropertyChange(261);
            }
            if (this.hasViewMenu != this.getPane().hasViewMenu()) {
                this.firePropertyChange(770);
            }
            this.firePropertyChange(147);
            this.firePropertyChange(1);
            this.getPane().addPropertyListener(this.getPropertyListenerProxy());
        } else {
            this.getPane().removePropertyListener(this.getPropertyListenerProxy());
            WorkbenchPartReference workbenchPartReference = this.getPartReference();
            this.isBusy = this.getPane().isBusy();
            this.isDirty = workbenchPartReference.isDirty();
            this.name = workbenchPartReference.getPartName();
            this.titleStatus = workbenchPartReference.getContentDescription();
            this.hasViewMenu = this.getPane().hasViewMenu();
            this.firePropertyChange(1);
            this.firePropertyChange(147);
        }
    }

    public void enableInputs(boolean bl) {
        if (bl == this.enableInputs) {
            return;
        }
        this.enableInputs = bl;
        if (bl) {
            if (bl && !SwtUtil.isDisposed(this.part.getControl())) {
                this.part.setBounds(this.savedBounds);
            }
            this.part.setVisible(this.isVisible);
        }
    }

    @Override
    public String getPartProperty(String string) {
        return this.getPartReference().getPartProperty(string);
    }

    @Override
    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return this.getPane().computePreferredSize(bl, n, n2, n3);
    }

    @Override
    public int getSizeFlags(boolean bl) {
        return this.getPane().getSizeFlags(bl);
    }
}

