/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.presentations.PaneFolderButtonListener;
import org.eclipse.ui.internal.presentations.util.ProxyControl;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;

public final class PaneFolder {
    private CTabFolder tabFolder;
    private Control titleAreaProxy;
    private ViewForm viewForm;
    private ProxyControl contentProxy;
    private ProxyControl viewFormTopLeftProxy;
    private ProxyControl viewFormTopRightProxy;
    private ProxyControl viewFormTopCenterProxy;
    private SizeCache topRightCache = new SizeCache();
    private SizeCache topCenterCache = new SizeCache();
    private SizeCache topLeftCache = new SizeCache();
    private boolean putTrimOnTop = true;
    private boolean topRightResized = false;
    private boolean useTopRightOptimization = false;
    private int lastWidth = 0;
    private DisposeListener tabFolderDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            PaneFolder.this.widgetDisposed();
            PaneFolder.this.clrUnselectedBgFrom.dispose();
            PaneFolder.this.clrUnselectedBgTo.dispose();
        }
    };
    private DisposeListener prematureDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            Control control = (Control)disposeEvent.widget;
            if (PaneFolder.this.isDisposed()) {
                return;
            }
            control.removeDisposeListener((DisposeListener)this);
            if (control == PaneFolder.this.topLeftCache.getControl()) {
                PaneFolder.this.setTopLeft(null);
            }
            if (control == PaneFolder.this.topRightCache.getControl()) {
                PaneFolder.this.setTopRight(null);
            }
            if (control == PaneFolder.this.topCenterCache.getControl()) {
                PaneFolder.this.setTopCenter(null);
            }
        }
    };
    private List buttonListeners = new ArrayList(1);
    private int state = 2;
    private int mousedownState = -1;
    private Point mousedownPoint = new Point(-1, -1);
    private long mousedownTime = 0L;
    private static long CLICK_TIME = 1000L;
    private CTabFolder2Adapter expandListener = new CTabFolder2Adapter(){

        public void minimize(CTabFolderEvent cTabFolderEvent) {
            cTabFolderEvent.doit = false;
            PaneFolder.this.notifyButtonListeners(0);
        }

        public void restore(CTabFolderEvent cTabFolderEvent) {
            cTabFolderEvent.doit = false;
            PaneFolder.this.notifyButtonListeners(2);
        }

        public void maximize(CTabFolderEvent cTabFolderEvent) {
            cTabFolderEvent.doit = false;
            PaneFolder.this.notifyButtonListeners(1);
        }

        public void close(CTabFolderEvent cTabFolderEvent) {
            cTabFolderEvent.doit = false;
            PaneFolder.this.notifyCloseListeners((CTabItem)cTabFolderEvent.item);
        }

        public void showList(CTabFolderEvent cTabFolderEvent) {
            PaneFolder.this.notifyShowListeners(cTabFolderEvent);
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            PaneFolder.this.mousedownState = PaneFolder.this.getState();
            PaneFolder.this.mousedownPoint = new Point(mouseEvent.x, mouseEvent.y);
            PaneFolder.this.mousedownTime = (long)mouseEvent.time & 0xFFFFFFFFL;
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 2 && mouseEvent.count == 1) {
                CTabItem cTabItem;
                Point point = new Point(mouseEvent.x, mouseEvent.y);
                CTabItem cTabItem2 = PaneFolder.this.tabFolder.getItem(point);
                long l = (long)mouseEvent.time & 0xFFFFFFFFL;
                if (cTabItem2 != null && l - PaneFolder.this.mousedownTime <= CLICK_TIME && (cTabItem = PaneFolder.this.tabFolder.getItem(PaneFolder.this.mousedownPoint)) == cTabItem2) {
                    PaneFolder.this.notifyCloseListeners(cTabItem2);
                }
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }
    };
    private boolean showButtons = true;
    private boolean minimizeVisible = false;
    private boolean maximizeVisible = false;
    private boolean inLayout = false;
    private int tabPosition;
    private Color clrUnselectedBgFrom;
    private Color clrUnselectedBgTo;

    public PaneFolder(Composite composite, int n) {
        Display display = composite.getDisplay();
        this.clrUnselectedBgFrom = new Color((Device)display, 220, 220, 220);
        this.clrUnselectedBgTo = new Color((Device)display, 208, 208, 208);
        final String[] stringArray = new String[1];
        final DefaultToolTip[] defaultToolTipArray = new DefaultToolTip[1];
        final boolean[] blArray = new boolean[]{true};
        this.tabFolder = new CTabFolder(composite, n){

            public void setToolTipText(String string) {
                stringArray[0] = string;
                if (string != null && string.length() > 0) {
                    if (blArray[0]) {
                        defaultToolTipArray[0].activate();
                        blArray[0] = false;
                    }
                } else if (!blArray[0]) {
                    defaultToolTipArray[0].deactivate();
                    blArray[0] = true;
                }
            }
        };
        defaultToolTipArray[0] = new DefaultToolTip((Control)this.tabFolder){

            protected String getText(Event event) {
                return stringArray[0];
            }
        };
        defaultToolTipArray[0].setShift(new Point(0, 16));
        this.tabFolder.setBackground(new Color[]{this.clrUnselectedBgFrom, this.clrUnselectedBgTo}, new int[]{100}, true);
        this.tabFolder.setMRUVisible(((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).enableMRUTabVisibility());
        this.titleAreaProxy = new Composite((Composite)this.tabFolder, 262144);
        this.titleAreaProxy.setVisible(false);
        this.titleAreaProxy.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                PaneFolder.this.topRightResized = true;
            }

            public void controlResized(ControlEvent controlEvent) {
                PaneFolder.this.topRightResized = true;
                if (!PaneFolder.this.inLayout && !PaneFolder.this.isDisposed() && PaneFolder.this.viewForm != null && PaneFolder.this.contentProxy != null) {
                    PaneFolder.this.aboutToResize();
                    PaneFolder.this.layout(false);
                }
            }
        });
        this.tabFolder.setTopRight(this.titleAreaProxy, 4);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)this.expandListener);
        this.tabFolder.addMouseListener(this.mouseListener);
        this.tabFolder.addDisposeListener(this.tabFolderDisposeListener);
        this.viewForm = new ViewForm((Composite)this.tabFolder, 262144);
        this.viewFormTopLeftProxy = new ProxyControl((Composite)this.viewForm);
        this.viewFormTopCenterProxy = new ProxyControl((Composite)this.viewForm);
        this.viewFormTopRightProxy = new ProxyControl((Composite)this.viewForm);
        this.contentProxy = new ProxyControl((Composite)this.viewForm);
        this.viewForm.setContent(this.contentProxy.getControl());
    }

    public Rectangle getTitleArea() {
        return this.titleAreaProxy.getBounds();
    }

    public Composite getControl() {
        return this.tabFolder;
    }

    public void flushTopCenterSize() {
        this.topCenterCache.flush();
        this.viewForm.changed(new Control[]{this.viewFormTopCenterProxy.getControl()});
    }

    public void flushTopLeftSize() {
        this.topLeftCache.flush();
        this.viewForm.changed(new Control[]{this.viewFormTopLeftProxy.getControl()});
    }

    public void setTopCenter(Control control) {
        if (control == this.topCenterCache.getControl()) {
            return;
        }
        this.removeDisposeListener(this.topCenterCache.getControl());
        this.topCenterCache.setControl(control);
        if (this.putTrimOnTop) {
            this.viewFormTopCenterProxy.setTarget(null);
        } else {
            this.viewFormTopCenterProxy.setTarget(this.topCenterCache);
        }
        this.viewForm.changed(new Control[]{this.viewFormTopCenterProxy.getControl()});
        if (control != null) {
            control.addDisposeListener(this.prematureDisposeListener);
            if (!this.putTrimOnTop && !this.viewForm.isDisposed()) {
                this.viewForm.setTopCenter(this.viewFormTopCenterProxy.getControl());
            }
        } else if (!this.putTrimOnTop && !this.viewForm.isDisposed()) {
            this.viewForm.setTopCenter(null);
        }
    }

    public void setTopRight(Control control) {
        if (this.topRightCache.getControl() == control) {
            return;
        }
        this.removeDisposeListener(this.topRightCache.getControl());
        this.topRightCache.setControl(control);
        if (this.putTrimOnTop) {
            this.viewFormTopRightProxy.setTarget(null);
        } else {
            this.viewFormTopRightProxy.setTarget(this.topRightCache);
        }
        if (control != null) {
            control.addDisposeListener(this.prematureDisposeListener);
            if (!this.putTrimOnTop) {
                this.viewForm.setTopRight(this.viewFormTopRightProxy.getControl());
            }
        } else if (!this.putTrimOnTop) {
            this.viewForm.setTopRight(null);
        }
    }

    public void setTopLeft(Control control) {
        if (this.topLeftCache.getControl() == control) {
            return;
        }
        this.removeDisposeListener(this.topLeftCache.getControl());
        this.topLeftCache.setControl(control);
        if (control != null) {
            control.addDisposeListener(this.prematureDisposeListener);
            this.viewFormTopLeftProxy.setTarget(this.topLeftCache);
            this.viewForm.setTopLeft(this.viewFormTopLeftProxy.getControl());
        } else {
            this.viewFormTopLeftProxy.setTarget(null);
            this.viewForm.setTopLeft(null);
        }
    }

    public void aboutToResize() {
        this.useTopRightOptimization = true;
        this.topRightResized = false;
        this.lastWidth = this.getControl().getBounds().width;
    }

    public void showMinMax(boolean bl) {
        this.showButtons = bl;
        this.setMaximizeVisible(bl);
        this.setMinimizeVisible(bl);
        this.layout(true);
    }

    public void layout(boolean bl) {
        if (this.inLayout) {
            return;
        }
        this.inLayout = true;
        try {
            Rectangle rectangle;
            this.viewForm.setLayoutDeferred(true);
            this.tabFolder.setMinimizeVisible(this.showButtons && this.minimizeVisible);
            this.tabFolder.setMaximizeVisible(this.showButtons && this.maximizeVisible);
            if (bl) {
                this.topLeftCache.flush();
                this.topRightCache.flush();
                this.topCenterCache.flush();
            }
            if (!this.useTopRightOptimization || !this.topRightResized && this.lastWidth != this.getControl().getBounds().width) {
                this.tabFolder.setTopRight(this.titleAreaProxy, 4);
            }
            this.useTopRightOptimization = false;
            Rectangle rectangle2 = this.titleAreaProxy.getBounds();
            Point point = this.topRightCache.computeSize(-1, -1);
            Point point2 = this.topCenterCache.computeSize(-1, -1);
            int n = point.x + point2.x;
            int n2 = Math.max(point.y, point2.y);
            boolean bl2 = this.putTrimOnTop;
            this.putTrimOnTop = rectangle2.width >= n && rectangle2.height >= n2;
            Control control = this.topRightCache.getControl();
            Control control2 = this.topCenterCache.getControl();
            if (this.putTrimOnTop) {
                if (!bl2) {
                    this.viewFormTopCenterProxy.setTarget(null);
                    this.viewFormTopRightProxy.setTarget(null);
                    this.viewForm.setTopCenter(null);
                    this.viewForm.setTopRight(null);
                }
                rectangle = new Rectangle(rectangle2.x + rectangle2.width - point.x, rectangle2.y + (rectangle2.height - point.y) / 2, point.x, point.y);
                if (control != null) {
                    control.setBounds(control.getDisplay().map((Control)this.tabFolder, (Control)control.getParent(), rectangle));
                }
                if (control2 != null) {
                    Rectangle rectangle3 = new Rectangle(rectangle.x - point2.x, rectangle2.y + (rectangle2.height - point2.y) / 2, point2.x, point2.y);
                    control2.setBounds(control2.getDisplay().map((Control)this.tabFolder, (Control)control2.getParent(), rectangle3));
                }
            } else {
                if (control2 != null) {
                    this.viewFormTopCenterProxy.setTarget(this.topCenterCache);
                    this.viewForm.setTopCenter(this.viewFormTopCenterProxy.getControl());
                }
                if (control != null) {
                    this.viewFormTopRightProxy.setTarget(this.topRightCache);
                    this.viewForm.setTopRight(this.viewFormTopRightProxy.getControl());
                }
            }
            rectangle = this.tabFolder.getClientArea();
            this.viewForm.setBounds(rectangle);
        }
        finally {
            this.viewForm.setLayoutDeferred(false);
            this.inLayout = false;
        }
        this.viewFormTopRightProxy.layout();
        this.viewFormTopLeftProxy.layout();
        this.viewFormTopCenterProxy.layout();
    }

    public Composite getContentParent() {
        return this.viewForm;
    }

    public void setContent(Control control) {
        this.viewForm.setContent(control);
    }

    public int getState() {
        return this.state;
    }

    protected void notifyButtonListeners(int n) {
        if (this.mousedownState == this.getState()) {
            for (PaneFolderButtonListener paneFolderButtonListener : this.buttonListeners) {
                paneFolderButtonListener.stateButtonPressed(n);
            }
        }
    }

    public Control getContent() {
        return this.viewForm.getContent();
    }

    protected void notifyShowListeners(CTabFolderEvent cTabFolderEvent) {
        for (PaneFolderButtonListener paneFolderButtonListener : this.buttonListeners) {
            paneFolderButtonListener.showList(cTabFolderEvent);
        }
    }

    protected void notifyCloseListeners(CTabItem cTabItem) {
        for (PaneFolderButtonListener paneFolderButtonListener : this.buttonListeners) {
            paneFolderButtonListener.closeButtonPressed(cTabItem);
        }
    }

    public void setState(int n) {
        this.state = n;
        this.tabFolder.setMinimized(n == 0);
        this.tabFolder.setMaximized(n == 1);
    }

    public void addButtonListener(PaneFolderButtonListener paneFolderButtonListener) {
        this.buttonListeners.add(paneFolderButtonListener);
    }

    public void removeButtonListener(PaneFolderButtonListener paneFolderButtonListener) {
        this.buttonListeners.remove(paneFolderButtonListener);
    }

    public void setTabPosition(int n) {
        this.tabPosition = n;
        this.tabFolder.setTabPosition(this.tabPosition);
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    public CTabItem createItem(int n, int n2) {
        return new CTabItem(this.tabFolder, n, n2);
    }

    public Point computeMinimumSize() {
        Point point = Geometry.getSize((Rectangle)this.tabFolder.computeTrim(0, 0, 0, 0));
        point.x += 100;
        return point;
    }

    private void removeDisposeListener(Control control) {
        if (!SwtUtil.isDisposed(control)) {
            control.removeDisposeListener(this.prematureDisposeListener);
        }
    }

    private void widgetDisposed() {
        this.removeDisposeListener(this.topCenterCache.getControl());
        this.topCenterCache.setControl(null);
        this.removeDisposeListener(this.topRightCache.getControl());
        this.topRightCache.setControl(null);
        this.removeDisposeListener(this.topLeftCache.getControl());
        this.topLeftCache.setControl(null);
    }

    public Point getChevronLocation() {
        int n = this.tabFolder.getItemCount();
        CTabItem cTabItem = null;
        CTabItem cTabItem2 = null;
        int n2 = 0;
        while (n2 < n) {
            cTabItem2 = this.tabFolder.getItem(n2);
            if (cTabItem2.isShowing()) {
                cTabItem = cTabItem2;
            }
            ++n2;
        }
        if (cTabItem == null) {
            return new Point(0, 0);
        }
        Rectangle rectangle = cTabItem.getBounds();
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        return new Point(n3, n4);
    }

    public void setSelection(int n) {
        this.tabFolder.setSelection(n);
    }

    public void showItem(int n) {
        this.tabFolder.showItem(this.tabFolder.getItem(n));
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        return this.tabFolder.computeTrim(n, n2, n3, n4);
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.tabFolder.setUnselectedCloseVisible(bl);
    }

    public void setSelectionForeground(Color color) {
        this.tabFolder.setSelectionForeground(color);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl) {
        this.tabFolder.setSelectionBackground(colorArray, nArray, bl);
    }

    public CTabItem getItem(int n) {
        return this.tabFolder.getItem(n);
    }

    public int getSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public int getTabHeight() {
        return this.tabFolder.getTabHeight();
    }

    public int indexOf(CTabItem cTabItem) {
        return this.tabFolder.indexOf(cTabItem);
    }

    public void setTabHeight(int n) {
        this.tabFolder.setTabHeight(n);
    }

    public int getItemCount() {
        return this.tabFolder.getItemCount();
    }

    public CTabItem[] getItems() {
        return this.tabFolder.getItems();
    }

    public CTabItem getItem(Point point) {
        return this.tabFolder.getItem(point);
    }

    public CTabItem getSelection() {
        return this.tabFolder.getSelection();
    }

    public void setMinimizeVisible(boolean bl) {
        this.tabFolder.setMinimizeVisible(bl);
        this.minimizeVisible = bl;
    }

    public void setMinimumCharacters(int n) {
        this.tabFolder.setMinimumCharacters(n);
    }

    public void setMaximizeVisible(boolean bl) {
        this.tabFolder.setMaximizeVisible(bl);
        this.maximizeVisible = bl;
    }

    public void setSimpleTab(boolean bl) {
        this.tabFolder.setSimple(bl);
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.tabFolder.setUnselectedImageVisible(bl);
    }

    public void setSingleTab(boolean bl) {
        this.tabFolder.setSingle(bl);
    }

    public void hideTitle() {
        this.tabFolder.setTabHeight(0);
    }

    public ViewForm getViewForm() {
        return this.viewForm;
    }

    public void setVisible(boolean bl) {
        this.contentProxy.setVisible(bl);
        this.viewFormTopCenterProxy.setVisible(bl);
        this.viewFormTopLeftProxy.setVisible(bl);
        this.viewFormTopRightProxy.setVisible(bl);
    }
}

