/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public class NativeStackPresentation
extends StackPresentation {
    private TabFolder tabFolder;
    private Listener dragListener;
    private IPresentablePart current;
    private MenuManager systemMenuManager = new MenuManager();
    private static int tabPos = PlatformUI.getPreferenceStore().getInt("VIEW_TAB_POSITION");
    private static final String TAB_DATA = String.valueOf(NativeStackPresentation.class.getName()) + ".partId";
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            if (NativeStackPresentation.this.current != null) {
                NativeStackPresentation.this.current.setFocus();
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            IPresentablePart iPresentablePart = null;
            NativeStackPresentation.this.showPaneMenu(iPresentablePart, point);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            IPresentablePart iPresentablePart = NativeStackPresentation.this.getPartForTab((TabItem)event.item);
            if (iPresentablePart != null) {
                NativeStackPresentation.this.getSite().selectPart(iPresentablePart);
            }
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            NativeStackPresentation.this.setControlSize();
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        @Override
        public void propertyChanged(Object object, int n) {
            if (NativeStackPresentation.this.isDisposed()) {
                return;
            }
            if (object instanceof IPresentablePart) {
                IPresentablePart iPresentablePart = (IPresentablePart)object;
                NativeStackPresentation.this.childPropertyChanged(iPresentablePart, n);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            if (disposeEvent.widget instanceof TabItem) {
                TabItem tabItem = (TabItem)disposeEvent.widget;
                IPresentablePart iPresentablePart = NativeStackPresentation.this.getPartForTab(tabItem);
                iPresentablePart.removePropertyListener(NativeStackPresentation.this.childPropertyChangeListener);
            }
        }
    };

    public NativeStackPresentation(Composite composite, IStackPresentationSite iStackPresentationSite) {
        super(iStackPresentationSite);
        this.tabFolder = new TabFolder(composite, tabPos);
        this.tabFolder.addListener(13, this.selectionListener);
        this.tabFolder.addListener(11, this.resizeListener);
        this.tabFolder.addMouseListener(this.mouseListener);
        this.tabFolder.addListener(35, this.menuListener);
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
            }
        };
        PresentationUtil.addDragListener((Control)this.tabFolder, this.dragListener);
    }

    private final int indexOf(IPresentablePart iPresentablePart) {
        if (iPresentablePart == null) {
            return this.tabFolder.getItemCount();
        }
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = 0;
        while (n < tabItemArray.length) {
            IPresentablePart iPresentablePart2 = this.getPartForTab(tabItemArray[n]);
            if (iPresentablePart == iPresentablePart2) {
                return n;
            }
            ++n;
        }
        return tabItemArray.length;
    }

    protected final TabItem getTab(IPresentablePart iPresentablePart) {
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = this.indexOf(iPresentablePart);
        if (n < tabItemArray.length) {
            return tabItemArray[n];
        }
        return null;
    }

    protected void childPropertyChanged(IPresentablePart iPresentablePart, int n) {
        TabItem tabItem = this.getTab(iPresentablePart);
        this.initTab(tabItem, iPresentablePart);
    }

    protected final IPresentablePart getPartForTab(TabItem tabItem) {
        IPresentablePart iPresentablePart = (IPresentablePart)tabItem.getData(TAB_DATA);
        return iPresentablePart;
    }

    protected TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    private void setControlSize() {
        if (this.current == null || this.tabFolder == null) {
            return;
        }
        this.current.setBounds(NativeStackPresentation.calculatePageBounds(this.tabFolder));
    }

    public static Rectangle calculatePageBounds(TabFolder tabFolder) {
        if (tabFolder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = tabFolder.getBounds();
        Rectangle rectangle2 = tabFolder.getClientArea();
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height;
        return rectangle;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        PresentationUtil.removeDragListener((Control)this.tabFolder, this.dragListener);
        this.tabFolder.dispose();
        this.tabFolder = null;
    }

    private TabItem createPartTab(IPresentablePart iPresentablePart, int n) {
        TabItem tabItem = new TabItem(this.tabFolder, 0, n);
        tabItem.setData(TAB_DATA, (Object)iPresentablePart);
        iPresentablePart.addPropertyListener(this.childPropertyChangeListener);
        tabItem.addDisposeListener(this.tabDisposeListener);
        this.initTab(tabItem, iPresentablePart);
        return tabItem;
    }

    protected void initTab(TabItem tabItem, IPresentablePart iPresentablePart) {
        tabItem.setText(iPresentablePart.getName());
        tabItem.setToolTipText(iPresentablePart.getTitleToolTip());
        Image image = iPresentablePart.getTitleImage();
        if (image != tabItem.getImage()) {
            tabItem.setImage(image);
        }
    }

    @Override
    public void addPart(IPresentablePart iPresentablePart, Object object) {
        this.createPartTab(iPresentablePart, this.tabFolder.getItemCount());
    }

    @Override
    public void removePart(IPresentablePart iPresentablePart) {
        TabItem tabItem = this.getTab(iPresentablePart);
        if (tabItem == null) {
            return;
        }
        iPresentablePart.setVisible(false);
        tabItem.dispose();
    }

    @Override
    public void selectPart(IPresentablePart iPresentablePart) {
        if (iPresentablePart == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.setVisible(false);
        }
        this.current = iPresentablePart;
        if (this.current != null) {
            this.tabFolder.setSelection(this.indexOf(this.current));
            this.current.setVisible(true);
            this.setControlSize();
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.tabFolder.setBounds(rectangle);
        this.setControlSize();
    }

    @Override
    public Point computeMinimumSize() {
        return Geometry.getSize((Rectangle)this.tabFolder.computeTrim(0, 0, 0, 0));
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.current != null) {
            this.current.setVisible(bl);
        }
        this.tabFolder.setVisible(bl);
    }

    @Override
    public void setState(int n) {
    }

    public IMenuManager getSystemMenuManager() {
        return this.systemMenuManager;
    }

    protected void showPaneMenu(IPresentablePart iPresentablePart, Point point) {
        this.systemMenuManager.update(false);
        Menu menu = this.systemMenuManager.createContextMenu((Control)this.tabFolder.getParent());
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    @Override
    public Control getControl() {
        return this.tabFolder;
    }

    @Override
    public StackDropResult dragOver(Control control, Point point) {
        return null;
    }

    @Override
    public void showSystemMenu() {
    }

    @Override
    public void showPaneMenu() {
    }

    @Override
    public Control[] getTabList(IPresentablePart iPresentablePart) {
        ArrayList<Control> arrayList = new ArrayList<Control>();
        if (this.getControl() != null) {
            arrayList.add(this.getControl());
        }
        if (iPresentablePart.getToolBar() != null) {
            arrayList.add(iPresentablePart.getToolBar());
        }
        if (iPresentablePart.getControl() != null) {
            arrayList.add(iPresentablePart.getControl());
        }
        return arrayList.toArray(new Control[arrayList.size()]);
    }

    public IPresentablePart getCurrentPart() {
        return this.current;
    }

    @Override
    public void setActive(int n) {
    }
}

