/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.presentations.AbstractTableInformationControl;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PresentablePartFolder;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class BasicPartList
extends AbstractTableInformationControl {
    private PresentablePartFolder folder;
    private IStackPresentationSite site;

    public BasicPartList(Shell shell, int n, int n2, IStackPresentationSite iStackPresentationSite, PresentablePartFolder presentablePartFolder) {
        super(shell, n, n2);
        this.site = iStackPresentationSite;
        this.folder = presentablePartFolder;
    }

    @Override
    protected TableViewer createTableViewer(Composite composite, int n) {
        Table table = new Table(composite, 4 | n & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(2));
        TableViewer tableViewer = new TableViewer(table){

            protected void internalRefresh(Object object) {
                boolean bl = Util.isMotif();
                try {
                    if (bl) {
                        this.getTable().setRedraw(false);
                    }
                    super.internalRefresh(object);
                }
                finally {
                    if (bl) {
                        this.getTable().setRedraw(true);
                    }
                }
            }
        };
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter());
        tableViewer.setContentProvider((IContentProvider)new BasicStackListContentProvider());
        if (((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).sortEditorListAlphabetically()) {
            tableViewer.setComparator((ViewerComparator)new BasicStackListViewerComparator());
        }
        tableViewer.setLabelProvider((IBaseLabelProvider)new BasicStackListLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    @Override
    public void setInput(Object object) {
        PresentablePartFolder presentablePartFolder = (PresentablePartFolder)object;
        this.inputChanged(presentablePartFolder, presentablePartFolder.getCurrent());
    }

    @Override
    protected void gotoSelectedElement() {
        Object object = this.getSelectedElement();
        this.dispose();
        if (object instanceof IPresentablePart) {
            this.site.selectPart((IPresentablePart)object);
        }
    }

    @Override
    protected boolean deleteSelectedElements() {
        IStructuredSelection iStructuredSelection = this.getSelectedElements();
        if (iStructuredSelection != null) {
            ArrayList<IPresentablePart> arrayList = new ArrayList<IPresentablePart>(iStructuredSelection.size());
            for (IPresentablePart iPresentablePart : iStructuredSelection) {
                arrayList.add(iPresentablePart);
            }
            this.site.close(arrayList.toArray(new IPresentablePart[arrayList.size()]));
        }
        if (this.folder.isDisposed()) {
            this.fComposite.dispose();
            return true;
        }
        return false;
    }

    private class BasicStackListContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (BasicPartList.this.folder == null) {
                return new IPresentablePart[0];
            }
            return BasicPartList.this.folder.getPartList();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            BasicPartList.this.folder = (PresentablePartFolder)object2;
        }
    }

    private class BasicStackListLabelProvider
    extends ColumnLabelProvider {
        private Font visibleEditorsFont;
        private Font invisibleEditorsFont;
        private Color visibleEditorsColor;

        public String getText(Object object) {
            IPresentablePart iPresentablePart = (IPresentablePart)object;
            if (iPresentablePart.isDirty()) {
                return String.valueOf(DefaultTabItem.DIRTY_PREFIX) + iPresentablePart.getName();
            }
            return iPresentablePart.getName();
        }

        public Image getImage(Object object) {
            IPresentablePart iPresentablePart = (IPresentablePart)object;
            return iPresentablePart.getTitleImage();
        }

        public Font getFont(Object object) {
            IPresentablePart iPresentablePart = (IPresentablePart)object;
            AbstractTabItem abstractTabItem = BasicPartList.this.folder.getTab(iPresentablePart);
            Control control = BasicPartList.this.folder.getTabFolder().getControl();
            if (abstractTabItem != null && abstractTabItem.isShowing()) {
                return this.getVisibleEditorsFont(control.getDisplay(), control.getFont());
            }
            return this.getInvisibleEditorsFont(control.getDisplay(), control.getFont());
        }

        private Color getVisibleEditorsColor(Display display, RGB rGB, RGB rGB2) {
            if (this.visibleEditorsColor == null) {
                this.visibleEditorsColor = ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).createVisibleEditorsColor(display, rGB, rGB2);
            }
            return this.visibleEditorsColor;
        }

        private Font getVisibleEditorsFont(Display display, Font font) {
            if (this.visibleEditorsFont == null) {
                this.visibleEditorsFont = ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).createVisibleEditorsFont(display, font);
            }
            return this.visibleEditorsFont;
        }

        private Font getInvisibleEditorsFont(Display display, Font font) {
            if (this.invisibleEditorsFont == null) {
                this.invisibleEditorsFont = ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).createInvisibleEditorsFont(display, font);
            }
            return this.invisibleEditorsFont;
        }

        public void dispose() {
            super.dispose();
            if (this.visibleEditorsColor != null) {
                this.visibleEditorsColor.dispose();
            }
            if (this.visibleEditorsFont != null) {
                this.visibleEditorsFont.dispose();
            }
            if (this.invisibleEditorsFont != null) {
                this.invisibleEditorsFont.dispose();
            }
        }

        public Color getForeground(Object object) {
            IPresentablePart iPresentablePart = (IPresentablePart)object;
            AbstractTabItem abstractTabItem = BasicPartList.this.folder.getTab(iPresentablePart);
            Control control = BasicPartList.this.folder.getTabFolder().getControl();
            if (abstractTabItem != null && abstractTabItem.isShowing()) {
                return this.getVisibleEditorsColor(control.getDisplay(), control.getForeground().getRGB(), control.getBackground().getRGB());
            }
            return null;
        }

        public String getToolTipText(Object object) {
            if (object instanceof PresentablePart) {
                PresentablePart presentablePart = (PresentablePart)object;
                IWorkbenchPartReference iWorkbenchPartReference = presentablePart.getPane().getPartReference();
                return iWorkbenchPartReference.getTitleToolTip();
            }
            return null;
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }
    }

    private class BasicStackListViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object object, Object object2) {
            String string;
            String string2;
            int n;
            int n2 = this.category(object);
            if (n2 != (n = this.category(object2))) {
                return n2 - n;
            }
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                string2 = object.toString();
                string = object2.toString();
            } else {
                IBaseLabelProvider iBaseLabelProvider = ((ContentViewer)viewer).getLabelProvider();
                if (iBaseLabelProvider instanceof ILabelProvider) {
                    ILabelProvider iLabelProvider = (ILabelProvider)iBaseLabelProvider;
                    string2 = iLabelProvider.getText(object);
                    string = iLabelProvider.getText(object2);
                    String string3 = DefaultTabItem.DIRTY_PREFIX;
                    if (string2.startsWith(string3)) {
                        string2 = string2.substring(string3.length());
                    }
                    if (string.startsWith(string3)) {
                        string = string.substring(string3.length());
                    }
                } else {
                    string2 = object.toString();
                    string = object2.toString();
                }
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string == null) {
                string = "";
            }
            return this.getComparator().compare(string2, string);
        }

        public int category(Object object) {
            IPresentablePart iPresentablePart = (IPresentablePart)object;
            AbstractTabItem abstractTabItem = BasicPartList.this.folder.getTab(iPresentablePart);
            if (abstractTabItem != null && abstractTabItem.isShowing()) {
                return 1;
            }
            return 0;
        }
    }
}

