/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;

public abstract class AbstractTableInformationControl {
    private static final int BORDER = 1;
    private static final int RIGHT_MARGIN = 3;
    private Shell fShell;
    protected Composite fComposite;
    private Text fFilterText;
    private TableViewer fTableViewer;
    private StringMatcher fStringMatcher;

    public AbstractTableInformationControl(Shell shell, int n, int n2) {
        this.fShell = new Shell(shell, n);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout gridLayout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)gridLayout);
        this.createFilterText(this.fComposite);
        this.fTableViewer = this.createTableViewer(this.fComposite, n2);
        final Table table = this.fTableViewer.getTable();
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 27: {
                        AbstractTableInformationControl.this.dispose();
                        break;
                    }
                    case 127: {
                        AbstractTableInformationControl.this.removeSelectedItems();
                        keyEvent.character = '\u0000';
                        keyEvent.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        if (table.getSelectionIndex() != 0) break;
                        AbstractTableInformationControl.this.fFilterText.setFocus();
                        break;
                    }
                    case 0x1000002: {
                        if (table.getSelectionIndex() != table.getItemCount() - 1) break;
                        AbstractTableInformationControl.this.fFilterText.setFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                AbstractTableInformationControl.this.gotoSelectedElement();
            }
        });
        final int n3 = Platform.getWS().equals("gtk") ? 4 : 1;
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem fLastItem = null;
            int lastY = 0;
            int itemHeightdiv4;
            int tableHeight;
            Point tableLoc;
            int divCount;
            {
                this.itemHeightdiv4 = table2.getItemHeight() / 4;
                this.tableHeight = table2.getBounds().height;
                this.tableLoc = table2.toDisplay(0, 0);
                this.divCount = 0;
            }

            public void mouseMove(MouseEvent mouseEvent) {
                if (this.divCount == n3) {
                    this.divCount = 0;
                }
                if (table.equals(mouseEvent.getSource()) & ++this.divCount == n3) {
                    TableItem tableItem;
                    if (this.fLastItem == null ^ (tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y))) == null) {
                        table.setCursor(tableItem == null ? null : table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem instanceof TableItem && this.lastY != mouseEvent.y) {
                        Item item;
                        this.lastY = mouseEvent.y;
                        if (!tableItem.equals(this.fLastItem)) {
                            this.fLastItem = tableItem;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        } else if (mouseEvent.y < this.itemHeightdiv4) {
                            Item item2 = AbstractTableInformationControl.this.fTableViewer.scrollUp(mouseEvent.x + this.tableLoc.x, mouseEvent.y + this.tableLoc.y);
                            if (item2 instanceof TableItem) {
                                this.fLastItem = (TableItem)item2;
                                table.setSelection(new TableItem[]{this.fLastItem});
                            }
                        } else if (mouseEvent.y > this.tableHeight - this.itemHeightdiv4 && (item = AbstractTableInformationControl.this.fTableViewer.scrollDown(mouseEvent.x + this.tableLoc.x, mouseEvent.y + this.tableLoc.y)) instanceof TableItem) {
                            this.fLastItem = (TableItem)item;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        }
                    } else if (tableItem == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TableItem tableItem;
                TableItem tableItem2;
                if (table.getSelectionCount() < 1) {
                    return;
                }
                if (mouseEvent.button == 1 && table.equals(mouseEvent.getSource())) {
                    tableItem2 = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    tableItem = table.getSelection()[0];
                    if (tableItem.equals(tableItem2)) {
                        AbstractTableInformationControl.this.gotoSelectedElement();
                    }
                }
                if (mouseEvent.button == 3 && (tableItem2 = AbstractTableInformationControl.this.fTableViewer.getTable().getItem(new Point(mouseEvent.x, mouseEvent.y))) != null) {
                    tableItem = new Menu((Control)AbstractTableInformationControl.this.fTableViewer.getTable());
                    MenuItem menuItem = new MenuItem((Menu)tableItem, 0);
                    menuItem.setText(WorkbenchMessages.PartPane_close);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            AbstractTableInformationControl.this.removeSelectedItems();
                        }
                    });
                    tableItem.setVisible(true);
                }
            }
        });
        this.fShell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 512: {
                        traverseEvent.detail = 0;
                        traverseEvent.doit = true;
                        int n = table.getItemCount();
                        if (n == 0) {
                            return;
                        }
                        int n2 = table.getSelectionIndex() + 1;
                        if (n2 >= n) {
                            n2 = 0;
                        }
                        table.setSelection(n2);
                        break;
                    }
                    case 256: {
                        traverseEvent.detail = 0;
                        traverseEvent.doit = true;
                        int n = table.getItemCount();
                        if (n == 0) {
                            return;
                        }
                        int n3 = table.getSelectionIndex() - 1;
                        if (n3 < 0) {
                            n3 = n - 1;
                        }
                        table.setSelection(n3);
                    }
                }
            }
        });
        int n4 = (n & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(n4));
        this.setInfoSystemColor();
        this.installFilter();
    }

    protected void removeSelectedItems() {
        int n = this.fTableViewer.getTable().getSelectionIndex();
        if (this.deleteSelectedElements()) {
            return;
        }
        this.fTableViewer.refresh();
        if (n >= this.fTableViewer.getTable().getItemCount()) {
            n = this.fTableViewer.getTable().getItemCount() - 1;
        }
        if (n >= 0) {
            this.fTableViewer.getTable().setSelection(n);
        }
    }

    protected abstract TableViewer createTableViewer(Composite var1, int var2);

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected Text createFilterText(Composite composite) {
        this.fFilterText = new Text(composite, 0);
        GridData gridData = new GridData();
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.fFilterText.setLayoutData((Object)gridData);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        AbstractTableInformationControl.this.gotoSelectedElement();
                        break;
                    }
                    case 0x1000002: {
                        AbstractTableInformationControl.this.fTableViewer.getTable().setFocus();
                        AbstractTableInformationControl.this.fTableViewer.getTable().setSelection(0);
                        break;
                    }
                    case 0x1000001: {
                        AbstractTableInformationControl.this.fTableViewer.getTable().setFocus();
                        AbstractTableInformationControl.this.fTableViewer.getTable().setSelection(AbstractTableInformationControl.this.fTableViewer.getTable().getItemCount() - 1);
                        break;
                    }
                    case 27: {
                        AbstractTableInformationControl.this.dispose();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        Label label = new Label(composite, 259);
        label.setLayoutData((Object)new GridData(768));
        return this.fFilterText;
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ((Text)modifyEvent.widget).getText();
                int n = string.length();
                if (n > 0 && string.charAt(n - 1) != '*') {
                    string = String.valueOf(string) + '*';
                }
                AbstractTableInformationControl.this.setMatcherString(string);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTableViewer.getControl().setRedraw(false);
        this.fTableViewer.refresh();
        this.selectFirstMatch();
        this.fTableViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String string) {
        if (string.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean bl = string.toLowerCase().equals(string);
            this.fStringMatcher = new StringMatcher(string, bl, false);
        }
        this.stringMatcherUpdated();
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        return ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
    }

    protected IStructuredSelection getSelectedElements() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    protected abstract void gotoSelectedElement();

    protected abstract boolean deleteSelectedElements();

    protected void selectFirstMatch() {
        Table table = this.fTableViewer.getTable();
        Object object = this.findElement(table.getItems());
        if (object != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(object), true);
        } else {
            this.fTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TableItem[] tableItemArray) {
        ILabelProvider iLabelProvider = (ILabelProvider)this.fTableViewer.getLabelProvider();
        int n = 0;
        while (n < tableItemArray.length) {
            Object object = tableItemArray[n].getData();
            if (this.fStringMatcher == null) {
                return object;
            }
            if (object != null) {
                String string = iLabelProvider.getText(object);
                if (string == null) {
                    return null;
                }
                String string2 = DefaultTabItem.DIRTY_PREFIX;
                if (string.startsWith(string2)) {
                    string = string.substring(string2.length());
                }
                if (this.fStringMatcher.match(string)) {
                    return object;
                }
            }
            ++n;
        }
        return null;
    }

    public abstract void setInput(Object var1);

    protected void inputChanged(Object object, Object object2) {
        int n;
        this.fFilterText.setText("");
        this.fTableViewer.setInput(object);
        this.selectFirstMatch();
        Table table = this.fTableViewer.getTable();
        Point point = table.computeSize(-1, -1);
        int n2 = this.fComposite.getDisplay().getBounds().height / 2;
        ((GridData)table.getLayoutData()).heightHint = n = point.y <= n2 ? point.y - table.getItemHeight() - table.getItemHeight() / 2 : n2;
        Point point2 = this.fComposite.computeSize(-1, -1);
        this.fComposite.setSize(point2);
        this.fComposite.getShell().setSize(point2);
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fTableViewer = null;
            this.fComposite = null;
            this.fFilterText = null;
        }
    }

    public boolean hasContents() {
        return this.fTableViewer != null && this.fTableViewer.getInput() != null;
    }

    public void setSizeConstraints(int n, int n2) {
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setLocation(Point point) {
        Rectangle rectangle = this.fShell.computeTrim(0, 0, 0, 0);
        Point point2 = this.fComposite.getLocation();
        point.x += rectangle.x - point2.x;
        point.y += rectangle.y - point2.y;
        this.fShell.setLocation(point);
    }

    public void setSize(int n, int n2) {
        this.fShell.setSize(n, n2);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fTableViewer.getTable().setForeground(color);
        this.fFilterText.setForeground(color);
        this.fComposite.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fTableViewer.getTable().setBackground(color);
        this.fFilterText.setBackground(color);
        this.fComposite.setBackground(color);
    }

    public boolean isFocusControl() {
        return this.fTableViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fShell.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fShell.removeFocusListener(focusListener);
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = n;
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            Point point = new Point(0, 0);
            if (controlArray != null) {
                int n3 = 0;
                while (n3 < controlArray.length) {
                    Point point2 = controlArray[n3].computeSize(n, n2, bl);
                    point.x = Math.max(point.x, point2.x);
                    point.y = Math.max(point.y, point2.y);
                    ++n3;
                }
            }
            point.x += this.fBorderSize * 2 + 3;
            point.y += this.fBorderSize * 2;
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Control[] controlArray = composite.getChildren();
            Point point = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (controlArray != null) {
                int n = 0;
                while (n < controlArray.length) {
                    Control control = controlArray[n];
                    control.setSize(point.x - this.fBorderSize * 2, point.y - this.fBorderSize * 2);
                    control.setLocation(this.fBorderSize, this.fBorderSize);
                    ++n;
                }
            }
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object object, Object object2) {
            StringMatcher stringMatcher = AbstractTableInformationControl.this.getMatcher();
            if (stringMatcher == null || !(viewer instanceof TableViewer)) {
                return true;
            }
            TableViewer tableViewer = (TableViewer)viewer;
            String string = ((ILabelProvider)tableViewer.getLabelProvider()).getText(object2);
            if (string == null) {
                return false;
            }
            String string2 = DefaultTabItem.DIRTY_PREFIX;
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
            return string != null && stringMatcher.match(string);
        }
    }
}

