/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.WorkbenchSettingsTransfer;

public class WorkingSetSettingsTransfer
extends WorkbenchSettingsTransfer {
    @Override
    public String getName() {
        return WorkbenchMessages.WorkingSets_Name;
    }

    @Override
    public IStatus transferSettings(IPath iPath) {
        IPath iPath2 = this.getNewWorkbenchStateLocation(iPath);
        if (iPath2 == null) {
            return this.noWorkingSettingsStatus();
        }
        iPath2 = iPath2.append("workingsets.xml");
        File file = new File(iPath2.toOSString());
        try {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            if (!(iWorkingSetManager instanceof AbstractWorkingSetManager)) {
                return new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.WorkingSets_CannotSave);
            }
            ((AbstractWorkingSetManager)iWorkingSetManager).saveState(file);
        }
        catch (IOException iOException) {
            new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.ProblemSavingWorkingSetState_message, (Throwable)iOException);
        }
        return Status.OK_STATUS;
    }
}

