/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.preferences.WizardPropertyPage;

public class WorkingSetPropertyPage
extends WizardPropertyPage {
    private IWorkingSet fWorkingSet;

    public WorkingSetPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    @Override
    public void setElement(IAdaptable iAdaptable) {
        super.setElement(iAdaptable);
        this.fWorkingSet = iAdaptable instanceof IWorkingSet ? (IWorkingSet)iAdaptable : (IWorkingSet)iAdaptable.getAdapter(IWorkingSet.class);
    }

    @Override
    protected void applyChanges() {
    }

    @Override
    protected IWizard createWizard() {
        if (this.fWorkingSet.isEditable()) {
            return PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetEditWizard(this.fWorkingSet);
        }
        return new ReadOnlyWizard();
    }

    private static final class ReadOnlyPage
    extends WizardPage {
        protected ReadOnlyPage() {
            super(WorkbenchMessages.WorkingSetPropertyPage_ReadOnlyWorkingSet_title);
            this.setDescription(WorkbenchMessages.WorkingSetPropertyPage_ReadOnlyWorkingSet_description);
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            composite2.setLayout((Layout)new GridLayout(1, false));
            this.setControl((Control)composite2);
        }
    }

    private static final class ReadOnlyWizard
    extends Wizard {
        public boolean performFinish() {
            return true;
        }

        public void addPages() {
            this.addPage((IWizardPage)new ReadOnlyPage());
        }
    }
}

