/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.ui.internal.preferences.Base64;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class WorkingCopyPreferences
extends EventManager
implements IEclipsePreferences {
    private static final String TRUE = "true";
    private final Map temporarySettings;
    private final IEclipsePreferences original;
    private boolean removed = false;
    private WorkingCopyManager manager;

    public WorkingCopyPreferences(IEclipsePreferences iEclipsePreferences, WorkingCopyManager workingCopyManager) {
        this.original = iEclipsePreferences;
        this.manager = workingCopyManager;
        this.temporarySettings = new HashMap();
    }

    private void checkRemoved() {
        if (this.removed) {
            String string = "Preference node: " + this.absolutePath() + " has been removed.";
            throw new IllegalStateException(string);
        }
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener iNodeChangeListener) {
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener iNodeChangeListener) {
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.checkRemoved();
        this.addListenerObject(iPreferenceChangeListener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.checkRemoved();
        this.removeListenerObject(iPreferenceChangeListener);
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] stringArray = this.keys();
        int n = 0;
        while (n < stringArray.length) {
            this.remove(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this.childrenNames();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.node(stringArray2[n2]).removeNode();
            ++n2;
        }
        this.removed = true;
    }

    public Preferences node(String string) {
        this.checkRemoved();
        return this.manager.getWorkingCopy((IEclipsePreferences)this.getOriginal().node(string));
    }

    public void accept(IPreferenceNodeVisitor iPreferenceNodeVisitor) throws BackingStoreException {
        this.checkRemoved();
        if (!iPreferenceNodeVisitor.visit((IEclipsePreferences)this)) {
            return;
        }
        String[] stringArray = this.childrenNames();
        int n = 0;
        while (n < stringArray.length) {
            ((IEclipsePreferences)this.node(stringArray[n])).accept(iPreferenceNodeVisitor);
            ++n;
        }
    }

    public void put(String string, String string2) {
        this.checkRemoved();
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        String string3 = null;
        string3 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        this.temporarySettings.put(string, string2);
        if (!string2.equals(string3)) {
            this.firePropertyChangeEvent(string, string3, string2);
        }
    }

    private void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.getListeners();
        if (objectArray.length == 0) {
            return;
        }
        IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent = new IEclipsePreferences.PreferenceChangeEvent((Object)this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            ((IEclipsePreferences.IPreferenceChangeListener)objectArray[n]).preferenceChange(preferenceChangeEvent);
            ++n;
        }
    }

    public String get(String string, String string2) {
        this.checkRemoved();
        return this.internalGet(string, string2);
    }

    private String internalGet(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.temporarySettings.containsKey(string)) {
            Object v = this.temporarySettings.get(string);
            return v == null ? string2 : (String)v;
        }
        return this.getOriginal().get(string, string2);
    }

    public void remove(String string) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.original.get(string, null);
        if (string2 == null) {
            return;
        }
        this.temporarySettings.put(string, null);
        this.firePropertyChangeEvent(string, string2, null);
    }

    public void clear() {
        this.checkRemoved();
        for (String string : this.temporarySettings.keySet()) {
            Object v = this.temporarySettings.get(string);
            if (v == null) continue;
            this.temporarySettings.put(string, null);
            this.firePropertyChangeEvent(string, v, null);
        }
    }

    public void putInt(String string, int n) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = Integer.toString(n);
        this.temporarySettings.put(string, string3);
        if (!string3.equals(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public int getInt(String string, int n) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public void putLong(String string, long l) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = Long.toString(l);
        this.temporarySettings.put(string, string3);
        if (!string3.equals(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public long getLong(String string, long l) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        long l2 = l;
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    public void putBoolean(String string, boolean bl) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = String.valueOf(bl);
        this.temporarySettings.put(string, string3);
        if (!string3.equalsIgnoreCase(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        return string2 == null ? bl : TRUE.equalsIgnoreCase(string2);
    }

    public void putFloat(String string, float f) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = Float.toString(f);
        this.temporarySettings.put(string, string3);
        if (!string3.equals(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public float getFloat(String string, float f) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        float f2 = f;
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f2;
    }

    public void putDouble(String string, double d) {
        this.checkRemoved();
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = Double.toString(d);
        this.temporarySettings.put(string, string3);
        if (!string3.equals(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public double getDouble(String string, double d) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        double d2 = d;
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public void putByteArray(String string, byte[] byArray) {
        this.checkRemoved();
        if (string == null || byArray == null) {
            throw new NullPointerException();
        }
        String string2 = null;
        string2 = this.temporarySettings.containsKey(string) ? (String)this.temporarySettings.get(string) : this.getOriginal().get(string, null);
        String string3 = new String(Base64.encode(byArray));
        this.temporarySettings.put(string, string3);
        if (!string3.equals(string2)) {
            this.firePropertyChangeEvent(string, string2, string3);
        }
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        this.checkRemoved();
        String string2 = this.internalGet(string, null);
        return string2 == null ? byArray : Base64.decode(string2.getBytes());
    }

    public String[] keys() throws BackingStoreException {
        this.checkRemoved();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getOriginal().keys()));
        hashSet.addAll(this.temporarySettings.keySet());
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] childrenNames() throws BackingStoreException {
        this.checkRemoved();
        return this.getOriginal().childrenNames();
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.manager.getWorkingCopy((IEclipsePreferences)this.getOriginal().parent());
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        if (string.length() == 0) {
            return this.removed ? false : this.getOriginal().nodeExists(string);
        }
        return this.getOriginal().nodeExists(string);
    }

    public String name() {
        return this.getOriginal().name();
    }

    public String absolutePath() {
        return this.getOriginal().absolutePath();
    }

    public void flush() throws BackingStoreException {
        if (this.removed) {
            this.getOriginal().removeNode();
            return;
        }
        this.checkRemoved();
        for (String string : this.temporarySettings.keySet()) {
            String string2 = (String)this.temporarySettings.get(string);
            if (string2 == null) {
                this.getOriginal().remove(string);
                continue;
            }
            this.getOriginal().put(string, string2);
        }
        this.temporarySettings.clear();
        this.getOriginal().flush();
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        this.temporarySettings.clear();
        this.getOriginal().sync();
    }

    private IEclipsePreferences getOriginal() {
        return this.original;
    }
}

