/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExpressionNode;
import org.eclipse.ui.internal.registry.KeywordRegistry;
import org.eclipse.ui.model.IComparableContribution;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPreferenceExtensionNode
extends WorkbenchPreferenceExpressionNode
implements IComparableContribution {
    private Collection keywordReferences;
    private IConfigurationElement configurationElement;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private Collection keywordLabelCache;
    private int priority;
    private String pluginId;

    public WorkbenchPreferenceExtensionNode(String string, IConfigurationElement iConfigurationElement) {
        super(string);
        this.configurationElement = iConfigurationElement;
        this.pluginId = iConfigurationElement.getNamespaceIdentifier();
    }

    public Collection getKeywordReferences() {
        if (this.keywordReferences == null) {
            IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElement().getChildren("keywordReference");
            HashSet<String> hashSet = new HashSet<String>(iConfigurationElementArray.length);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("id");
                if (string != null) {
                    hashSet.add(string);
                }
                ++n;
            }
            this.keywordReferences = !hashSet.isEmpty() ? hashSet : Collections.EMPTY_SET;
        }
        return this.keywordReferences;
    }

    public Collection getKeywordLabels() {
        if (this.keywordLabelCache != null) {
            return this.keywordLabelCache;
        }
        Collection collection = this.getKeywordReferences();
        if (collection == Collections.EMPTY_SET) {
            this.keywordLabelCache = Collections.EMPTY_SET;
            return this.keywordLabelCache;
        }
        this.keywordLabelCache = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = KeywordRegistry.getInstance().getKeywordLabel((String)iterator.next());
            if (string == null) continue;
            this.keywordLabelCache.add(string);
        }
        return this.keywordLabelCache;
    }

    public void clearKeywords() {
        this.keywordLabelCache = null;
    }

    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.disposeResources();
    }

    public Image getLabelImage() {
        ImageDescriptor imageDescriptor;
        if (this.image == null && (imageDescriptor = this.getImageDescriptor()) != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public String getLabelText() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String string = this.getConfigurationElement().getAttribute("icon");
        if (string != null) {
            String string2 = this.pluginId;
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string2, string);
        }
        return this.imageDescriptor;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == IConfigurationElement.class) {
            return this.getConfigurationElement();
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.getLabelText();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }
}

