/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;
import org.eclipse.ui.internal.preferences.ThemeAdapter;
import org.eclipse.ui.themes.IThemeManager;

public class ThemeManagerAdapter
extends PropertyMapAdapter {
    private IThemeManager manager;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThemeManagerAdapter.this.firePropertyChange(propertyChangeEvent.getProperty());
        }
    };

    public ThemeManagerAdapter(IThemeManager iThemeManager) {
        this.manager = iThemeManager;
    }

    @Override
    protected void attachListener() {
        this.manager.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.manager.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        Set set = ThemeAdapter.getKeySet(this.manager.getCurrentTheme());
        return set;
    }

    @Override
    public Object getValue(String string, Class clazz) {
        return ThemeAdapter.getValue(this.manager.getCurrentTheme(), string, clazz);
    }

    @Override
    public boolean propertyExists(String string) {
        return this.keySet().contains(string);
    }

    @Override
    public void setValue(String string, Object object) {
        throw new UnsupportedOperationException();
    }
}

