/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;
import org.eclipse.ui.themes.ITheme;

public class ThemeAdapter
extends PropertyMapAdapter {
    private ITheme targetTheme;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ThemeAdapter.this.firePropertyChange(propertyChangeEvent.getProperty());
        }
    };

    public ThemeAdapter(ITheme iTheme) {
        this.targetTheme = iTheme;
    }

    @Override
    protected void attachListener() {
        this.targetTheme.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.targetTheme.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        return ThemeAdapter.getKeySet(this.targetTheme);
    }

    @Override
    public Object getValue(String string, Class clazz) {
        return ThemeAdapter.getValue(this.targetTheme, string, clazz);
    }

    public static Set getKeySet(ITheme iTheme) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(iTheme.keySet());
        hashSet.addAll(iTheme.getColorRegistry().getKeySet());
        hashSet.addAll(iTheme.getFontRegistry().getKeySet());
        return hashSet;
    }

    public static Object getValue(ITheme iTheme, String string, Class clazz) {
        Color color;
        if (clazz.isAssignableFrom(String.class)) {
            return iTheme.getString(string);
        }
        if (clazz.isAssignableFrom(Color.class) && (color = iTheme.getColorRegistry().get(string)) != null) {
            return color;
        }
        if (clazz.isAssignableFrom(Font.class) && (color = iTheme.getFontRegistry()).hasValueFor(string)) {
            return color.get(string);
        }
        if (clazz == Integer.class) {
            return new Integer(iTheme.getInt(string));
        }
        if (clazz == Boolean.class) {
            return iTheme.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean propertyExists(String string) {
        return this.keySet().contains(string);
    }

    @Override
    public void setValue(String string, Object object) {
        throw new UnsupportedOperationException();
    }
}

