/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Map;
import java.util.Set;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.util.Util;

public class PropertyMapUnion
implements IPropertyMap {
    private Map values;

    @Override
    public Set keySet() {
        return this.values.keySet();
    }

    @Override
    public Object getValue(String string, Class clazz) {
        PropertyInfo propertyInfo = (PropertyInfo)this.values.get(string);
        if (propertyInfo == null) {
            return null;
        }
        Object object = propertyInfo.value;
        if (clazz.isInstance(object)) {
            return object;
        }
        return null;
    }

    @Override
    public boolean isCommonProperty(String string) {
        PropertyInfo propertyInfo = (PropertyInfo)this.values.get(string);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.commonAttribute;
    }

    @Override
    public boolean propertyExists(String string) {
        return this.values.get(string) != null;
    }

    @Override
    public void setValue(String string, Object object) {
        PropertyInfo propertyInfo = new PropertyInfo(object, true);
        this.values.put(string, propertyInfo);
    }

    public void addMap(IPropertyMap iPropertyMap) {
        Object object;
        PropertyInfo propertyInfo;
        Set set = iPropertyMap.keySet();
        for (String string : this.keySet()) {
            propertyInfo = (PropertyInfo)this.values.get(string);
            if (propertyInfo == null) continue;
            if (iPropertyMap.propertyExists(string)) {
                object = iPropertyMap.getValue(string, Object.class);
                if (!Util.equals(object, iPropertyMap.getValue(string, Object.class))) {
                    propertyInfo.value = null;
                }
                propertyInfo.commonAttribute = propertyInfo.commonAttribute && iPropertyMap.isCommonProperty(string);
                continue;
            }
            propertyInfo.commonAttribute = false;
        }
        for (String string : set) {
            propertyInfo = (PropertyInfo)this.values.get(string);
            if (propertyInfo != null) continue;
            object = iPropertyMap.getValue(string, Object.class);
            boolean bl = iPropertyMap.isCommonProperty(string);
            propertyInfo = new PropertyInfo(object, bl);
            this.values.put(string, propertyInfo);
        }
    }

    public void removeValue(String string) {
        this.values.remove(string);
    }

    private static final class PropertyInfo {
        Object value;
        boolean commonAttribute;

        PropertyInfo(Object object, boolean bl) {
            this.value = object;
            this.commonAttribute = bl;
        }
    }
}

