/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.ui.internal.preferences.IDynamicPropertyMap;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.IPropertyMapListener;
import org.eclipse.ui.internal.preferences.PropertyListenerList;
import org.eclipse.ui.internal.preferences.PropertyUtil;

public abstract class PropertyMapAdapter
implements IDynamicPropertyMap {
    private PropertyListenerList listeners;
    private int ignoreCount = 0;
    private ArrayList queuedEvents = new ArrayList();

    @Override
    public final void addListener(IPropertyMapListener iPropertyMapListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyListenerList();
            this.attachListener();
        }
        this.listeners.add(iPropertyMapListener);
    }

    @Override
    public final void removeListener(IPropertyMapListener iPropertyMapListener) {
        if (this.listeners != null) {
            this.listeners.remove(iPropertyMapListener);
            if (this.listeners.isEmpty()) {
                this.detachListener();
                this.listeners = null;
            }
        }
    }

    @Override
    public final boolean isCommonProperty(String string) {
        return true;
    }

    public void dispose() {
        if (this.listeners != null) {
            this.detachListener();
            this.listeners = null;
        }
    }

    protected final void firePropertyChange(String string) {
        if (this.ignoreCount > 0) {
            this.queuedEvents.add(string);
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange(string);
        }
    }

    @Override
    public final void addListener(String[] stringArray, IPropertyMapListener iPropertyMapListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyListenerList();
            this.attachListener();
        }
        this.listeners.add(stringArray, iPropertyMapListener);
    }

    protected final void firePropertyChange(String[] stringArray) {
        if (this.ignoreCount > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.queuedEvents.add(stringArray[n]);
                ++n;
            }
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange(stringArray);
        }
    }

    public final void startTransaction() {
        ++this.ignoreCount;
    }

    public final void endTransaction() {
        --this.ignoreCount;
        if (this.ignoreCount == 0 && !this.queuedEvents.isEmpty()) {
            if (this.listeners != null) {
                this.listeners.firePropertyChange(this.queuedEvents.toArray(new String[this.queuedEvents.size()]));
            }
            this.queuedEvents.clear();
        }
    }

    public boolean equals(Object object) {
        return object instanceof IPropertyMap && PropertyUtil.isEqual(this, (IPropertyMap)object);
    }

    protected abstract void attachListener();

    protected abstract void detachListener();
}

