/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.registry.PreferenceTransferRegistryReader;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferenceTransferElement
extends WorkbenchAdapter
implements IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private IConfigurationElement configurationElement;
    private IPreferenceFilter filter;

    public PreferenceTransferElement(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
        this.id = iConfigurationElement.getAttribute("id");
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IPreferenceFilter getFilter() throws CoreException {
        block6: {
            if (this.filter != null) break block6;
            IConfigurationElement[] iConfigurationElementArray = PreferenceTransferRegistryReader.getMappings(this.configurationElement);
            int n = iConfigurationElementArray.length;
            HashSet<String> hashSet = new HashSet<String>(n);
            HashMap hashMap = new HashMap(n);
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    Map map;
                    String string;
                    block8: {
                        block7: {
                            string = PreferenceTransferRegistryReader.getScope(iConfigurationElementArray[n2]);
                            hashSet.add(string);
                            if (hashMap.containsKey(string)) break block7;
                            map = new HashMap(n);
                            hashMap.put(string, map);
                            break block8;
                        }
                        map = (Map)hashMap.get(string);
                        if (map == null) break block9;
                    }
                    Map map2 = PreferenceTransferRegistryReader.getEntry(iConfigurationElementArray[n2]);
                    if (map2 == null) {
                        hashMap.put(string, null);
                    } else {
                        map.putAll(map2);
                    }
                }
                ++n2;
            }
            this.filter = new PreferenceFilter(hashSet.toArray(new String[hashSet.size()]), hashMap);
        }
        return this.filter;
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.configurationElement);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    @Override
    public String getLocalId() {
        return this.getID();
    }

    @Override
    public String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getContributor().getName() : null;
    }

    @Override
    public String getLabel(Object object) {
        return this.getName();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.imageDescriptor == null) {
            String string = this.configurationElement.getAttribute("icon");
            if (string == null) {
                return null;
            }
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.getPluginId(), string);
        }
        return this.imageDescriptor;
    }

    class PreferenceFilter
    implements IPreferenceFilter {
        private String[] scopes;
        private Map mappings;

        public PreferenceFilter(String[] stringArray, Map map) {
            this.scopes = stringArray;
            this.mappings = map;
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public Map getMapping(String string) {
            return (Map)this.mappings.get(string);
        }
    }
}

