/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.preferences.PropertyMapAdapter;

public final class PreferenceStoreAdapter
extends PropertyMapAdapter {
    private IPreferenceStore store;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PreferenceStoreAdapter.this.firePropertyChange(propertyChangeEvent.getProperty());
        }
    };

    public PreferenceStoreAdapter(IPreferenceStore iPreferenceStore) {
        this.store = iPreferenceStore;
    }

    @Override
    protected void attachListener() {
        this.store.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void detachListener() {
        this.store.removePropertyChangeListener(this.listener);
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(String string, Class clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return this.store.getString(string);
        }
        if (clazz == Boolean.class) {
            return this.store.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == Double.class) {
            return new Double(this.store.getDouble(string));
        }
        if (clazz == Float.class) {
            return new Float(this.store.getFloat(string));
        }
        if (clazz == Integer.class) {
            return new Integer(this.store.getInt(string));
        }
        if (clazz == Long.class) {
            return new Long(this.store.getLong(string));
        }
        return null;
    }

    @Override
    public boolean propertyExists(String string) {
        return this.store.contains(string);
    }

    @Override
    public void setValue(String string, Object object) {
        if (object instanceof String) {
            this.store.setValue(string, (String)object);
        } else if (object instanceof Integer) {
            this.store.setValue(string, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            this.store.setValue(string, ((Boolean)object).booleanValue());
        } else if (object instanceof Double) {
            this.store.setValue(string, ((Double)object).doubleValue());
        } else if (object instanceof Float) {
            this.store.setValue(string, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.store.setValue(string, ((Integer)object).intValue());
        } else if (object instanceof Long) {
            this.store.setValue(string, ((Long)object).longValue());
        }
    }
}

