/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;

public class StatusPart {
    private static final String LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";
    boolean showingDetails = false;
    private Button detailsButton;
    private Composite detailsArea;
    private Control details = null;
    private IStatus reason;

    public StatusPart(Composite composite, IStatus iStatus) {
        int n;
        Color color = composite.getDisplay().getSystemColor(25);
        Color color2 = composite.getDisplay().getSystemColor(24);
        composite.setBackground(color);
        composite.setForeground(color2);
        this.reason = iStatus;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        int n2 = 8;
        gridLayout.marginBottom = n = 8;
        gridLayout.marginTop = n;
        gridLayout.marginLeft = n;
        gridLayout.marginRight = n;
        gridLayout.horizontalSpacing = n2;
        gridLayout.verticalSpacing = n2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setBackground(color);
        Image image = this.getImage();
        if (image != null) {
            image.setBackground(color);
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        Text text = new Text(composite, 74);
        text.setBackground(color);
        text.setForeground(color2);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText(this.reason.getMessage());
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.detailsButton = new Button(composite2, 8);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusPart.this.showDetails(!StatusPart.this.showingDetails);
            }
        });
        this.detailsButton.setLayoutData((Object)new GridData(1, 4, false, false));
        this.detailsButton.setVisible(this.reason.getException() != null);
        this.createShowLogButton(composite2);
        this.updateDetailsText();
        this.detailsArea = new Composite(composite, 0);
        this.detailsArea.setBackground(color);
        this.detailsArea.setForeground(color2);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        this.detailsArea.setLayoutData((Object)gridData);
        this.detailsArea.setLayout((Layout)new FillLayout());
        composite.layout(true);
    }

    private Image getImage() {
        Display display = Display.getCurrent();
        switch (this.reason.getSeverity()) {
            case 4: {
                return display.getSystemImage(1);
            }
            case 2: {
                return display.getSystemImage(8);
            }
        }
        return display.getSystemImage(2);
    }

    private void showDetails(boolean bl) {
        if (bl == this.showingDetails) {
            return;
        }
        this.showingDetails = bl;
        this.updateDetailsText();
    }

    private void updateDetailsText() {
        if (this.details != null) {
            this.details.dispose();
            this.details = null;
        }
        if (this.showingDetails) {
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            Text text = new Text(this.detailsArea, 33557258);
            text.setText(this.getDetails(this.reason));
            text.setBackground(text.getDisplay().getSystemColor(25));
            this.details = text;
            this.detailsArea.layout(true);
        } else {
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    private String getDetails(IStatus iStatus) {
        if (iStatus.getException() != null) {
            return this.getStackTrace(iStatus.getException());
        }
        return "";
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    private void createShowLogButton(Composite composite) {
        IViewDescriptor iViewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(LOG_VIEW_ID);
        if (iViewDescriptor == null) {
            return;
        }
        Button button = new Button(composite, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(StatusPart.LOG_VIEW_ID);
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException, WorkbenchPlugin.PI_WORKBENCH);
                }
            }
        });
        final Image image = iViewDescriptor.getImageDescriptor().createImage();
        button.setImage(image);
        button.setToolTipText(WorkbenchMessages.ErrorLogUtil_ShowErrorLogTooltip);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                image.dispose();
            }
        });
    }
}

