/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TimeTriggeredProgressMonitorDialog
extends ProgressMonitorDialog {
    private int longOperationTime;
    private long triggerTime = -1L;
    private boolean dialogOpened = false;
    private IProgressMonitor wrapperedMonitor;

    public TimeTriggeredProgressMonitorDialog(Shell shell, int n) {
        super(shell);
        this.setOpenOnRun(false);
        this.longOperationTime = n;
    }

    public void createWrapperedMonitor() {
        this.wrapperedMonitor = new IProgressMonitor(){
            IProgressMonitor superMonitor;
            {
                this.superMonitor = TimeTriggeredProgressMonitorDialog.super.getProgressMonitor();
            }

            public void beginTask(String string, int n) {
                this.superMonitor.beginTask(string, n);
                this.checkTicking();
            }

            private void checkTicking() {
                if (TimeTriggeredProgressMonitorDialog.this.triggerTime < 0L) {
                    TimeTriggeredProgressMonitorDialog.this.triggerTime = System.currentTimeMillis() + (long)TimeTriggeredProgressMonitorDialog.this.longOperationTime;
                }
                if (!TimeTriggeredProgressMonitorDialog.this.dialogOpened && System.currentTimeMillis() > TimeTriggeredProgressMonitorDialog.this.triggerTime) {
                    TimeTriggeredProgressMonitorDialog.this.open();
                    TimeTriggeredProgressMonitorDialog.this.dialogOpened = true;
                }
            }

            public void done() {
                this.superMonitor.done();
                this.checkTicking();
            }

            public void internalWorked(double d) {
                this.superMonitor.internalWorked(d);
                this.checkTicking();
            }

            public boolean isCanceled() {
                return this.superMonitor.isCanceled();
            }

            public void setCanceled(boolean bl) {
                this.superMonitor.setCanceled(bl);
            }

            public void setTaskName(String string) {
                this.superMonitor.setTaskName(string);
                this.checkTicking();
            }

            public void subTask(String string) {
                this.superMonitor.subTask(string);
                this.checkTicking();
            }

            public void worked(int n) {
                this.superMonitor.worked(n);
                this.checkTicking();
            }
        };
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.wrapperedMonitor == null) {
            this.createWrapperedMonitor();
        }
        return this.wrapperedMonitor;
    }

    public void run(final boolean bl, final boolean bl2, final IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] invocationTargetExceptionArray = new InvocationTargetException[1];
        final InterruptedException[] interruptedExceptionArray = new InterruptedException[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TimeTriggeredProgressMonitorDialog.super.run(bl, bl2, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetExceptionArray[0] = invocationTargetException;
                }
                catch (InterruptedException interruptedException) {
                    interruptedExceptionArray[0] = interruptedException;
                }
            }
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)runnable);
        if (invocationTargetExceptionArray[0] != null) {
            throw invocationTargetExceptionArray[0];
        }
        if (interruptedExceptionArray[0] != null) {
            throw interruptedExceptionArray[0];
        }
    }
}

