/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.internal.util.Util;

public class AdvancedValidationUserApprover
implements IOperationApprover,
IOperationApprover2 {
    public static boolean AUTOMATED_MODE = false;
    private IUndoContext context;
    private static final int EXECUTING = 1;
    private static final int UNDOING = 2;
    private static final int REDOING = 3;

    public AdvancedValidationUserApprover(IUndoContext iUndoContext) {
        this.context = iUndoContext;
    }

    public IStatus proceedRedoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        return this.proceedWithOperation(iUndoableOperation, iOperationHistory, iAdaptable, 3);
    }

    public IStatus proceedUndoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        return this.proceedWithOperation(iUndoableOperation, iOperationHistory, iAdaptable, 2);
    }

    public IStatus proceedExecuting(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        return this.proceedWithOperation(iUndoableOperation, iOperationHistory, iAdaptable, 1);
    }

    private IStatus proceedWithOperation(final IUndoableOperation iUndoableOperation, final IOperationHistory iOperationHistory, final IAdaptable iAdaptable, final int n) {
        if (!iUndoableOperation.hasContext(this.context)) {
            return Status.OK_STATUS;
        }
        if (n == 1 ? !(iUndoableOperation instanceof IAdvancedUndoableOperation2) : !(iUndoableOperation instanceof IAdvancedUndoableOperation)) {
            return Status.OK_STATUS;
        }
        final IStatus[] iStatusArray = new IStatus[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                iStatusArray[0] = AdvancedValidationUserApprover.this.computeOperationStatus(iUndoableOperation, iOperationHistory, iAdaptable, n);
                if (!iStatusArray[0].isOK()) {
                    iStatusArray[0] = AdvancedValidationUserApprover.this.reportAndInterpretStatus(iStatusArray[0], iAdaptable, iUndoableOperation, n);
                }
            }
        });
        if (!iStatusArray[0].isOK()) {
            iOperationHistory.operationChanged(iUndoableOperation);
        }
        return iStatusArray[0];
    }

    private IStatus computeOperationStatus(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable, int n) {
        try {
            StatusReportingRunnable statusReportingRunnable = new StatusReportingRunnable(iUndoableOperation, iOperationHistory, iAdaptable, n);
            TimeTriggeredProgressMonitorDialog timeTriggeredProgressMonitorDialog = new TimeTriggeredProgressMonitorDialog(this.getShell(iAdaptable), PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
            timeTriggeredProgressMonitorDialog.run(false, true, statusReportingRunnable);
            return statusReportingRunnable.getStatus();
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.reportException(invocationTargetException, iAdaptable);
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    private void reportException(Exception exception, IAdaptable iAdaptable) {
        Throwable throwable = StatusUtil.getCause(exception);
        Throwable throwable2 = throwable == null ? exception : throwable;
        String string = WorkbenchMessages.Error;
        String string2 = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        String string3 = throwable2.getMessage();
        if (string3 == null) {
            string3 = string2;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string3, throwable2);
        WorkbenchPlugin.log(string2, (IStatus)status);
        boolean bl = false;
        Shell shell = this.getShell(iAdaptable);
        if (shell == null) {
            bl = true;
            shell = new Shell();
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)status);
        if (bl) {
            shell.dispose();
        }
    }

    private IStatus reportAndInterpretStatus(IStatus iStatus, IAdaptable iAdaptable, IUndoableOperation iUndoableOperation, int n) {
        if (AUTOMATED_MODE) {
            if (iStatus.getSeverity() == 2) {
                return Status.OK_STATUS;
            }
            return iStatus;
        }
        if (iStatus.getSeverity() == 8) {
            return iStatus;
        }
        boolean bl = false;
        IStatus iStatus2 = iStatus;
        Shell shell = this.getShell(iAdaptable);
        if (shell == null) {
            bl = true;
            shell = new Shell();
        }
        if (iStatus.getSeverity() != 4) {
            String string;
            String string2;
            switch (n) {
                case 2: {
                    string2 = WorkbenchMessages.Operations_proceedWithNonOKUndoStatus;
                    if (iStatus.getSeverity() == 1) {
                        string = WorkbenchMessages.Operations_undoInfo;
                        break;
                    }
                    string = WorkbenchMessages.Operations_undoWarning;
                    break;
                }
                case 3: {
                    string2 = WorkbenchMessages.Operations_proceedWithNonOKRedoStatus;
                    if (iStatus.getSeverity() == 1) {
                        string = WorkbenchMessages.Operations_redoInfo;
                        break;
                    }
                    string = WorkbenchMessages.Operations_redoWarning;
                    break;
                }
                default: {
                    string2 = WorkbenchMessages.Operations_proceedWithNonOKExecuteStatus;
                    string = iStatus.getSeverity() == 1 ? WorkbenchMessages.Operations_executeInfo : WorkbenchMessages.Operations_executeWarning;
                }
            }
            String string3 = NLS.bind((String)string2, (Object[])new Object[]{iStatus.getMessage(), iUndoableOperation.getLabel()});
            String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog messageDialog = new MessageDialog(shell, string, null, string3, 4, stringArray, 0);
            int n2 = messageDialog.open();
            iStatus2 = n2 == 0 ? Status.OK_STATUS : Status.CANCEL_STATUS;
        } else {
            String string;
            String string4;
            switch (n) {
                case 2: {
                    string4 = WorkbenchMessages.Operations_undoProblem;
                    string = WorkbenchMessages.Operations_stoppedOnUndoErrorStatus;
                    break;
                }
                case 3: {
                    string4 = WorkbenchMessages.Operations_redoProblem;
                    string = WorkbenchMessages.Operations_stoppedOnRedoErrorStatus;
                    break;
                }
                default: {
                    string4 = WorkbenchMessages.Operations_executeProblem;
                    string = WorkbenchMessages.Operations_stoppedOnExecuteErrorStatus;
                }
            }
            String string5 = NLS.bind((String)string, (Object)iStatus.getMessage(), (Object)iUndoableOperation.getLabel());
            MessageDialog messageDialog = new MessageDialog(shell, string4, null, string5, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            messageDialog.open();
        }
        if (bl) {
            shell.dispose();
        }
        return iStatus2;
    }

    Shell getShell(IAdaptable iAdaptable) {
        Shell shell;
        if (iAdaptable != null && (shell = (Shell)Util.getAdapter(iAdaptable, Shell.class)) != null) {
            return shell;
        }
        return null;
    }

    private class StatusReportingRunnable
    implements IRunnableWithProgress {
        IStatus status;
        int doing;
        IUndoableOperation operation;
        IAdaptable uiInfo;

        StatusReportingRunnable(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable, int n) {
            this.operation = iUndoableOperation;
            this.doing = n;
            this.uiInfo = iAdaptable;
        }

        public void run(IProgressMonitor iProgressMonitor) {
            try {
                switch (this.doing) {
                    case 2: {
                        this.status = ((IAdvancedUndoableOperation)this.operation).computeUndoableStatus(iProgressMonitor);
                        break;
                    }
                    case 3: {
                        this.status = ((IAdvancedUndoableOperation)this.operation).computeRedoableStatus(iProgressMonitor);
                        break;
                    }
                    case 1: {
                        this.status = ((IAdvancedUndoableOperation2)this.operation).computeExecutionStatus(iProgressMonitor);
                    }
                }
            }
            catch (ExecutionException executionException) {
                AdvancedValidationUserApprover.this.reportException((Exception)((Object)executionException), this.uiInfo);
                this.status = IOperationHistory.OPERATION_INVALID_STATUS;
            }
        }

        IStatus getStatus() {
            return this.status;
        }
    }
}

