/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.util.Util;

public class UIListenerLogging {
    private static final String LISTENER_EVENTS = "org.eclipse.ui/debug";
    public static final String PAGE_PARTLISTENER_EVENTS = "org.eclipse.ui/listeners/IWorkbenchPage.IPartListener";
    public static final String PAGE_PARTLISTENER2_EVENTS = "org.eclipse.ui/listeners/IWorkbenchPage.IPartListener2";
    private static final String PAGE_PROPERTY_EVENTS = "org.eclipse.ui/listeners/IWorkbenchPage.IPropertyChangeListener";
    private static final String WINDOW_PAGE_EVENTS = "org.eclipse.ui/listeners/IWorkbenchWindow.IPageListener";
    private static final String WINDOW_PERSPECTIVE_EVENTS = "org.eclipse.ui/listeners/IWorkbenchWindow.IPerspectiveListener";
    public static final String WINDOW_PARTLISTENER_EVENTS = "org.eclipse.ui/listeners/IWorkbenchWindow.IPartListener";
    public static final String WINDOW_PARTLISTENER2_EVENTS = "org.eclipse.ui/listeners/IWorkbenchWindow.IPartListener2";
    private static final String PARTREFERENCE_PROPERTY_EVENTS = "org.eclipse.ui/listeners/IWorkbenchPartReference";
    public static final boolean enabled = UIListenerLogging.internal_isEnabled("org.eclipse.ui/debug");
    public static final String PE_ACTIVATED = "partActivated";
    public static final String PE_PART_BROUGHT_TO_TOP = "partBroughtToTop";
    public static final String PE_PART_CLOSED = "partClosed";
    public static final String PE_PART_DEACTIVATED = "partDeactivated";
    public static final String PE_PART_OPENED = "partOpened";
    public static final String PE2_ACTIVATED = "partActivated";
    public static final String PE2_PART_VISIBLE = "partVisible";
    public static final String PE2_PART_HIDDEN = "partHidden";
    public static final String PE2_PART_BROUGHT_TO_TOP = "partBroughtToTop";
    public static final String PE2_PART_CLOSED = "partClosed";
    public static final String PE2_PART_DEACTIVATED = "partDectivated";
    public static final String PE2_PART_OPENED = "partOpened";
    public static final String PE2_PART_INPUT_CHANGED = "partInputChanged";
    public static final String WPE_PAGE_ACTIVATED = "pageActivated";
    public static final String WPE_PAGE_OPENED = "pageOpened";
    public static final String WPE_PAGE_CLOSED = "pageClosed";
    public static final String PLE_PERSP_PRE_DEACTIVATE = "perspectivePreDeactivate";
    public static final String PLE_PERSP_DEACTIVATED = "perspectiveDeactivated";
    public static final String PLE_PERSP_ACTIVATED = "perspectiveActivated";
    public static final String PLE_PERSP_OPENED = "perspectiveOpened";
    public static final String PLE_PERSP_CLOSED = "perspectiveClosed";
    public static final String PLE_PERSP_SAVED_AS = "perspectiveSavedAs";

    private static String getSourceId(Object object) {
        return Util.safeString(Integer.toString(object.hashCode() % 1000));
    }

    private static String getWindowId(IWorkbenchWindow iWorkbenchWindow) {
        return "window " + Util.safeString(Integer.toString(iWorkbenchWindow.hashCode() % 1000));
    }

    private static String getPageId(IWorkbenchPage iWorkbenchPage) {
        return "page " + Util.safeString(Integer.toString(iWorkbenchPage.hashCode() % 1000));
    }

    private static String getPerspectiveId(IPerspectiveDescriptor iPerspectiveDescriptor) {
        return Util.safeString(iPerspectiveDescriptor.getId());
    }

    public static final void logPageEvent(IWorkbenchWindow iWorkbenchWindow, IWorkbenchPage iWorkbenchPage, String string) {
        if (UIListenerLogging.isEnabled(WINDOW_PAGE_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchWindow.IPageListener " + UIListenerLogging.getWindowId(iWorkbenchWindow) + " " + string + " (" + UIListenerLogging.getPageId(iWorkbenchPage) + ")");
        }
    }

    public static final void logPerspectiveEvent(IWorkbenchWindow iWorkbenchWindow, IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        if (UIListenerLogging.isEnabled(WINDOW_PERSPECTIVE_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchWindow.IPerspectiveListener " + UIListenerLogging.getWindowId(iWorkbenchWindow) + " " + string + " (" + UIListenerLogging.getPageId(iWorkbenchPage) + ", " + UIListenerLogging.getPerspectiveId(iPerspectiveDescriptor) + ")");
        }
    }

    public static final void logPerspectiveChangedEvent(IWorkbenchWindow iWorkbenchWindow, IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        if (UIListenerLogging.isEnabled(WINDOW_PERSPECTIVE_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchWindow.IPerspectiveListener " + UIListenerLogging.getWindowId(iWorkbenchWindow) + " perspectiveChanged (" + UIListenerLogging.getPageId(iWorkbenchPage) + ", " + UIListenerLogging.getPerspectiveId(iPerspectiveDescriptor) + ", " + UIListenerLogging.getPartId(iWorkbenchPartReference) + ", " + string + ")");
        }
    }

    public static final void logPerspectiveSavedAs(IWorkbenchWindow iWorkbenchWindow, IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IPerspectiveDescriptor iPerspectiveDescriptor2) {
        if (UIListenerLogging.isEnabled(WINDOW_PERSPECTIVE_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchWindow.IPerspectiveListener " + UIListenerLogging.getWindowId(iWorkbenchWindow) + " " + PLE_PERSP_SAVED_AS + " (" + UIListenerLogging.getPageId(iWorkbenchPage) + ", " + UIListenerLogging.getPerspectiveId(iPerspectiveDescriptor) + ", " + UIListenerLogging.getPerspectiveId(iPerspectiveDescriptor2) + ")");
        }
    }

    private static String getPartId(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return "null part";
        }
        return String.valueOf(Util.safeString(iWorkbenchPart.getTitle())) + " - " + Util.safeString(iWorkbenchPart.getSite().getId());
    }

    private static String getPartId(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference == null) {
            return "null part";
        }
        return String.valueOf(Util.safeString(iWorkbenchPartReference.getPartName())) + " - " + Util.safeString(iWorkbenchPartReference.getId());
    }

    public static final void logPartListenerEvent(String string, Object object, IWorkbenchPart iWorkbenchPart, String string2) {
        if (UIListenerLogging.isEnabled(string)) {
            System.out.println(String.valueOf(string) + " " + UIListenerLogging.getSourceId(object) + ", " + string2 + "(" + UIListenerLogging.getPartId(iWorkbenchPart) + ")");
        }
    }

    public static final void logPartListener2Event(String string, Object object, IWorkbenchPartReference iWorkbenchPartReference, String string2) {
        if (UIListenerLogging.isEnabled(string)) {
            System.out.println(String.valueOf(string) + " " + UIListenerLogging.getSourceId(object) + ", " + string2 + "(" + UIListenerLogging.getPartId(iWorkbenchPartReference) + ")");
        }
    }

    public static final void logPartListenerEvent(IWorkbenchPage iWorkbenchPage, IWorkbenchPart iWorkbenchPart, String string) {
        if (UIListenerLogging.isEnabled(PAGE_PARTLISTENER_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchPage.IPartListener page " + Util.safeString(iWorkbenchPage.getLabel()) + ", " + string + "(" + UIListenerLogging.getPartId(iWorkbenchPart) + ")");
        }
    }

    public static final void logPartListener2Event(IWorkbenchPage iWorkbenchPage, IWorkbenchPartReference iWorkbenchPartReference, String string) {
        if (UIListenerLogging.isEnabled(PAGE_PARTLISTENER2_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchPage.IPartListener2 page " + Util.safeString(iWorkbenchPage.getLabel()) + ", " + string + "(" + UIListenerLogging.getPartId(iWorkbenchPartReference) + ")");
        }
    }

    public static final void logPagePropertyChanged(IWorkbenchPage iWorkbenchPage, String string, Object object, Object object2) {
        if (UIListenerLogging.isEnabled(PAGE_PROPERTY_EVENTS)) {
            System.out.println("org.eclipse.ui/listeners/IWorkbenchPage.IPropertyChangeListener page " + Util.safeString(iWorkbenchPage.getLabel()) + ", " + string + " = " + Util.safeString(object2.toString()) + "( old value = " + object2.toString() + " )");
        }
    }

    public static final void logPartReferencePropertyChange(IWorkbenchPartReference iWorkbenchPartReference, int n) {
        if (UIListenerLogging.isEnabled(PARTREFERENCE_PROPERTY_EVENTS)) {
            String string;
            switch (n) {
                case 1: {
                    string = "title";
                    break;
                }
                case 257: {
                    string = "dirty";
                    break;
                }
                case 258: {
                    string = "input";
                    break;
                }
                case 260: {
                    string = "part_name";
                    break;
                }
                case 261: {
                    string = "content_description";
                    break;
                }
                default: {
                    string = "unknown event id = " + n;
                }
            }
            System.out.println("org.eclipse.ui/listeners/IWorkbenchPartReference " + UIListenerLogging.getPartId(iWorkbenchPartReference) + ", property " + string);
        }
    }

    private static boolean isEnabled(String string) {
        return enabled && UIListenerLogging.internal_isEnabled(string);
    }

    private static boolean internal_isEnabled(String string) {
        String string2 = Platform.getDebugOption((String)string);
        return string2 != null && !string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("-1");
    }
}

