/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class StatusUtil {
    protected static List flatten(IStatus iStatus) {
        ArrayList arrayList = new ArrayList();
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                IStatus iStatus2 = iStatusArray[n];
                if (iStatus2.isMultiStatus()) {
                    Iterator iterator = StatusUtil.flatten(iStatus2).iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                } else {
                    arrayList.add(iStatus2);
                }
                ++n;
            }
        } else {
            arrayList.add(iStatus);
        }
        return arrayList;
    }

    protected static IStatus newStatus(IStatus[] iStatusArray, String string, Throwable throwable) {
        Assert.isTrue((string != null ? 1 : 0) != 0);
        Assert.isTrue((string.trim().length() != 0 ? 1 : 0) != 0);
        return new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, iStatusArray, string, throwable);
    }

    public static IStatus newStatus(String string, Throwable throwable) {
        return StatusUtil.newStatus(string, StatusUtil.getLocalizedMessage(throwable), throwable);
    }

    public static String getLocalizedMessage(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            return coreException.getStatus().getMessage();
        }
        return WorkbenchMessages.StatusUtil_errorOccurred;
    }

    public static IStatus newStatus(IStatus iStatus, String string) {
        return new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, iStatus.getException());
    }

    public static IStatus newStatus(String string, String string2, Throwable throwable) {
        return new Status(4, string, 0, string2, StatusUtil.getCause(throwable));
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable throwable2 = null;
        if (throwable != null) {
            if (throwable instanceof CoreException) {
                CoreException coreException = (CoreException)throwable;
                throwable2 = coreException.getStatus().getException();
            } else {
                try {
                    Method method = throwable.getClass().getMethod("getCause", new Class[0]);
                    Object object = method.invoke((Object)throwable, new Object[0]);
                    if (object instanceof Throwable) {
                        throwable2 = (Throwable)object;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (throwable2 == null) {
                throwable2 = throwable;
            }
        }
        return throwable2;
    }

    public static IStatus newStatus(int n, String string, Throwable throwable) {
        String string2 = string;
        if (string == null || string.trim().length() == 0) {
            string2 = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
        }
        return new Status(n, WorkbenchPlugin.PI_WORKBENCH, n, string2, StatusUtil.getCause(throwable));
    }

    public static IStatus newStatus(List list, String string, Throwable throwable) {
        IStatus iStatus2;
        ArrayList arrayList = new ArrayList();
        for (IStatus iStatus2 : list) {
            Iterator iterator = StatusUtil.flatten(iStatus2).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        iStatus2 = new IStatus[arrayList.size()];
        arrayList.toArray((T[])iStatus2);
        return StatusUtil.newStatus((IStatus[])iStatus2, string, throwable);
    }

    public static void handleStatus(IStatus iStatus, int n, Shell shell) {
        StatusManager.getManager().handle(iStatus, n);
    }

    public static void handleStatus(Throwable throwable, int n) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, throwable), n);
    }

    public static void handleStatus(String string, Throwable throwable, int n) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, string, throwable), n);
    }

    public static void handleStatus(String string, Throwable throwable, int n, Shell shell) {
        StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, string, throwable), n);
    }

    public static void handleStatus(IStatus iStatus, String string, int n) {
        StatusManager.getManager().handle(StatusUtil.newStatus(iStatus, string), n);
    }

    public static void handleStatus(IStatus iStatus, String string, int n, Shell shell) {
        StatusManager.getManager().handle(StatusUtil.newStatus(iStatus, string), n);
    }

    public static void handleStatus(String string, int n) {
        StatusUtil.handleStatus(string, null, n);
    }

    public static void handleStatus(String string, int n, Shell shell) {
        StatusUtil.handleStatus(string, null, n);
    }
}

