/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class ExternalEditor {
    private IPath filePath;
    private EditorDescriptor descriptor;

    public ExternalEditor(IPath iPath, EditorDescriptor editorDescriptor) {
        this.filePath = iPath;
        this.descriptor = editorDescriptor;
    }

    public void open() throws CoreException {
        Program program = this.descriptor.getProgram();
        if (program != null) {
            String string = "";
            if (this.filePath != null && program.execute(string = this.filePath.toOSString())) {
                return;
            }
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, NLS.bind((String)WorkbenchMessages.ExternalEditor_errorMessage, (Object)string), null));
        }
        this.openWithUserDefinedProgram();
    }

    public void openWithUserDefinedProgram() throws CoreException {
        Object object;
        String string = null;
        IConfigurationElement iConfigurationElement = this.descriptor.getConfigurationElement();
        if (iConfigurationElement != null) {
            try {
                URL uRL;
                File file;
                object = Platform.getBundle((String)iConfigurationElement.getNamespace());
                URL uRL2 = object.getEntry(this.descriptor.getFileName());
                if (uRL2 != null && (file = new File((uRL = Platform.asLocalURL((URL)uRL2)).getFile())).exists()) {
                    string = file.getAbsolutePath();
                }
            }
            catch (IOException iOException) {}
        }
        if (string == null) {
            string = this.descriptor.getFileName();
        }
        if (this.filePath == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, NLS.bind((String)WorkbenchMessages.ExternalEditor_errorMessage, (Object)string), null));
        }
        object = this.filePath.toOSString();
        try {
            if (Util.isMac()) {
                Runtime.getRuntime().exec(new String[]{"open", "-a", string, object});
            } else {
                Runtime.getRuntime().exec(new String[]{string, object});
            }
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, NLS.bind((String)WorkbenchMessages.ExternalEditor_errorMessage, (Object)string), (Throwable)exception));
        }
    }
}

