/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.internal.handlers.HandlerPersistence;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.menus.AbstractMenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.ContributionRoot;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.menus.ProxyMenuAdditionCacheEntry;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public final class WorkbenchMenuService
extends InternalMenuService {
    private static final String INDEX_AFTER_ADDITIONS = "after=additions";
    private static final String PROP_VISIBLE = "visible";
    private final MenuPersistence menuPersistence;
    private IEvaluationService evaluationService;
    private IPropertyChangeListener serviceListener;
    private IServiceLocator serviceLocator;
    private IActivityManagerListener activityManagerListener;
    private Map uriToFactories = new HashMap();
    private Map evaluationsByItem = new HashMap();
    private Map activityListenersByItem = new HashMap();
    private Set managersAwaitingUpdates = new HashSet();
    private HashMap populatedManagers = new HashMap();
    private IRegistryChangeListener registryChangeListener;

    public WorkbenchMenuService(IServiceLocator iServiceLocator) {
        this.menuPersistence = new MenuPersistence(this);
        this.serviceLocator = iServiceLocator;
        this.evaluationService = (IEvaluationService)iServiceLocator.getService(IEvaluationService.class);
        this.evaluationService.addServiceListener(this.getServiceListener());
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)iServiceLocator.getService(IWorkbenchLocationService.class);
        iWorkbenchLocationService.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this.getActivityManagerListener());
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        this.registryChangeListener = new IRegistryChangeListener(){

            public void registryChanged(final IRegistryChangeEvent iRegistryChangeEvent) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkbenchMenuService.this.handleRegistryChanges(iRegistryChangeEvent);
                    }
                });
            }
        };
        iExtensionRegistry.addRegistryChangeListener(this.registryChangeListener);
    }

    private IActivityManagerListener getActivityManagerListener() {
        if (this.activityManagerListener == null) {
            this.activityManagerListener = new IActivityManagerListener(){

                @Override
                public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                    if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.activityManagerListener;
    }

    private IPropertyChangeListener getServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("org.eclipse.ui.services.notifying") && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.serviceListener;
    }

    public void updateManagers() {
        Object[] objectArray = this.managersAwaitingUpdates.toArray();
        this.managersAwaitingUpdates.clear();
        int n = 0;
        while (n < objectArray.length) {
            IContributionManager iContributionManager;
            IContributionManager iContributionManager2 = (IContributionManager)objectArray[n];
            iContributionManager2.update(true);
            if (iContributionManager2 instanceof ToolBarManager) {
                if (!this.updateCoolBar((ToolBarManager)iContributionManager2)) {
                    this.updateTrim((ToolBarManager)iContributionManager2);
                }
            } else if (iContributionManager2 instanceof MenuManager && (iContributionManager = ((MenuManager)iContributionManager2).getParent()) != null) {
                iContributionManager.update(true);
            }
            ++n;
        }
    }

    private void updateTrim(ToolBarManager toolBarManager) {
        ToolBar toolBar = toolBarManager.getControl();
        if (toolBar == null || toolBar.isDisposed()) {
            return;
        }
        LayoutUtil.resize((Control)toolBar);
    }

    private boolean updateCoolBar(ToolBarManager toolBarManager) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            ICoolBarManager iCoolBarManager = workbenchWindow.getCoolBarManager2();
            if (iCoolBarManager != null) {
                IContributionItem[] iContributionItemArray = iCoolBarManager.getItems();
                int n2 = 0;
                while (n2 < iContributionItemArray.length) {
                    IToolBarManager iToolBarManager;
                    if (iContributionItemArray[n2] instanceof ToolBarContributionItem && toolBarManager == (iToolBarManager = ((ToolBarContributionItem)iContributionItemArray[n2]).getToolBarManager())) {
                        iCoolBarManager.update(true);
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    @Override
    public final void addSourceProvider(ISourceProvider iSourceProvider) {
    }

    @Override
    public final void dispose() {
        IWorkbench iWorkbench;
        Object object2;
        this.menuPersistence.dispose();
        if (this.registryChangeListener != null) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            iExtensionRegistry.removeRegistryChangeListener(this.registryChangeListener);
            this.registryChangeListener = null;
        }
        for (Object object2 : this.evaluationsByItem.values()) {
            this.evaluationService.removeEvaluationListener((IEvaluationReference)object2);
        }
        this.evaluationsByItem.clear();
        this.managersAwaitingUpdates.clear();
        if (this.serviceListener != null) {
            this.evaluationService.removeServiceListener(this.serviceListener);
            this.serviceListener = null;
        }
        if (this.activityManagerListener != null && (iWorkbench = (object2 = (IWorkbenchLocationService)this.serviceLocator.getService(IWorkbenchLocationService.class)).getWorkbench()) != null) {
            iWorkbench.getActivitySupport().getActivityManager().removeActivityManagerListener(this.activityManagerListener);
        }
    }

    public final void readRegistry() {
        this.menuPersistence.read();
    }

    @Override
    public final void removeSourceProvider(ISourceProvider iSourceProvider) {
    }

    private String getIdFromURI(MenuLocationURI menuLocationURI) {
        return String.valueOf(menuLocationURI.getScheme()) + ":" + menuLocationURI.getPath();
    }

    @Override
    public List getAdditionsForURI(MenuLocationURI menuLocationURI) {
        if (menuLocationURI == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.uriToFactories.get(this.getIdFromURI(menuLocationURI));
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.uriToFactories.put(this.getIdFromURI(menuLocationURI), arrayList);
        }
        return arrayList;
    }

    @Override
    public void addContributionFactory(AbstractContributionFactory abstractContributionFactory) {
        if (abstractContributionFactory == null || abstractContributionFactory.getLocation() == null) {
            return;
        }
        MenuLocationURI menuLocationURI = new MenuLocationURI(abstractContributionFactory.getLocation());
        String string = this.getIdFromURI(menuLocationURI);
        ArrayList<AbstractContributionFactory> arrayList = (ArrayList<AbstractContributionFactory>)this.uriToFactories.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<AbstractContributionFactory>();
            this.uriToFactories.put(string, arrayList);
        }
        if (abstractContributionFactory instanceof MenuAdditionCacheEntry && ((MenuAdditionCacheEntry)abstractContributionFactory).hasAdditions()) {
            arrayList.add(0, abstractContributionFactory);
        } else {
            arrayList.add(abstractContributionFactory);
        }
        ArrayList<AbstractContributionFactory> arrayList2 = new ArrayList<AbstractContributionFactory>();
        arrayList2.add(abstractContributionFactory);
        List list = this.getManagersFor(string);
        for (ContributionManager contributionManager : list) {
            ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)this.populatedManagers.get(contributionManager);
            this.addContributionsToManager(managerPopulationRecord.serviceLocatorToUse, managerPopulationRecord.restriction, contributionManager, managerPopulationRecord.uri, managerPopulationRecord.recurse, arrayList2);
            contributionManager.update(true);
        }
    }

    private List getManagersFor(String string) {
        ArrayList<ContributionManager> arrayList = new ArrayList<ContributionManager>();
        for (ContributionManager contributionManager : this.populatedManagers.keySet()) {
            ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)this.populatedManagers.get(contributionManager);
            if (!string.equals(managerPopulationRecord.uri)) continue;
            arrayList.add(contributionManager);
        }
        return arrayList;
    }

    @Override
    public void removeContributionFactory(AbstractContributionFactory abstractContributionFactory) {
        Object object2;
        List list;
        if (abstractContributionFactory == null || abstractContributionFactory.getLocation() == null) {
            return;
        }
        MenuLocationURI menuLocationURI = new MenuLocationURI(abstractContributionFactory.getLocation());
        String string = this.getIdFromURI(menuLocationURI);
        List list2 = (List)this.uriToFactories.get(string);
        if (list2 != null) {
            if (abstractContributionFactory instanceof MenuAdditionCacheEntry && (list = ((MenuAdditionCacheEntry)abstractContributionFactory).getSubCaches()) != null) {
                for (Object object2 : list) {
                    this.removeContributionFactory((AbstractContributionFactory)object2);
                }
            }
            list2.remove(abstractContributionFactory);
        }
        list = new ArrayList<AbstractContributionFactory>();
        list.add(abstractContributionFactory);
        List list3 = this.getManagersFor(string);
        object2 = list3.iterator();
        while (object2.hasNext()) {
            ContributionManager contributionManager = (ContributionManager)object2.next();
            this.removeContributionsForFactory((IContributionManager)contributionManager, abstractContributionFactory);
            contributionManager.update(true);
        }
    }

    private boolean processAdditions(final IServiceLocator iServiceLocator, Set set, final ContributionManager contributionManager, final AbstractContributionFactory abstractContributionFactory, final Set set2) {
        if (!this.processFactory(contributionManager, abstractContributionFactory)) {
            return true;
        }
        final int n = this.getInsertionIndex(contributionManager, abstractContributionFactory.getLocation());
        if (n == -1) {
            return false;
        }
        final ContributionRoot contributionRoot = new ContributionRoot(this, set, contributionManager, abstractContributionFactory);
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void handleException(Throwable throwable) {
            }

            public void run() throws Exception {
                int n3 = n;
                abstractContributionFactory.createContributionItems(iServiceLocator, contributionRoot);
                if (contributionRoot.getItems().size() > 0) {
                    ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)WorkbenchMenuService.this.populatedManagers.get(contributionManager);
                    ContributionRoot contributionRoot2 = managerPopulationRecord.getContributions(abstractContributionFactory);
                    if (contributionRoot2 != null) {
                        for (IContributionItem iContributionItem : contributionRoot2.getItems()) {
                            if (!iContributionItem.equals(contributionManager.find(iContributionItem.getId()))) continue;
                            --n3;
                        }
                    }
                    managerPopulationRecord.addFactoryContribution(abstractContributionFactory, contributionRoot);
                    for (IContributionItem iContributionItem : contributionRoot.getItems()) {
                        if ((iContributionItem instanceof ContributionManager || iContributionItem instanceof IToolBarContributionItem || iContributionItem instanceof AbstractGroupMarker) && iContributionItem.getId() != null && !"".equals(iContributionItem.getId())) {
                            IToolBarManager iToolBarManager;
                            IContributionItem iContributionItem2 = contributionManager.find(iContributionItem.getId());
                            if (iContributionItem2 instanceof ContributionManager) {
                                if (((ContributionManager)iContributionItem).getSize() <= 0) continue;
                                iToolBarManager = new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Menu contribution id collision: " + iContributionItem.getId());
                                StatusManager.getManager().handle((IStatus)iToolBarManager);
                                continue;
                            }
                            if (iContributionItem2 instanceof IToolBarContributionItem) {
                                iToolBarManager = ((IToolBarContributionItem)iContributionItem).getToolBarManager();
                                if (!(iToolBarManager instanceof ContributionManager) || ((ContributionManager)iToolBarManager).getSize() <= 0) continue;
                                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Toolbar contribution id collision: " + iContributionItem.getId());
                                StatusManager.getManager().handle((IStatus)status);
                                continue;
                            }
                            if (iContributionItem2 instanceof AbstractGroupMarker) continue;
                        }
                        int n2 = contributionManager.getSize();
                        contributionManager.insert(n3, iContributionItem);
                        if (iContributionItem.getId() != null) {
                            set2.add(iContributionItem.getId());
                        }
                        if (contributionManager.getSize() <= n2) continue;
                        ++n3;
                    }
                }
            }
        };
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
        return true;
    }

    private boolean processFactory(ContributionManager contributionManager, AbstractContributionFactory abstractContributionFactory) {
        MenuLocationURI menuLocationURI = new MenuLocationURI(abstractContributionFactory.getLocation());
        if ("popup:org.eclipse.ui.popup.any".equals(String.valueOf(menuLocationURI.getScheme()) + ':' + menuLocationURI.getPath()) && contributionManager.indexOf("additions") == -1 && abstractContributionFactory instanceof MenuAdditionCacheEntry) {
            MenuAdditionCacheEntry menuAdditionCacheEntry = (MenuAdditionCacheEntry)abstractContributionFactory;
            return menuAdditionCacheEntry.contributeToAllPopups();
        }
        return true;
    }

    protected void removeContributionsForFactory(IContributionManager iContributionManager, AbstractContributionFactory abstractContributionFactory) {
        ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)this.populatedManagers.get(iContributionManager);
        managerPopulationRecord.removeFactoryContribution(abstractContributionFactory);
    }

    private void releaseCache(ContributionRoot contributionRoot) {
        contributionRoot.release();
    }

    @Override
    public void populateContributionManager(ContributionManager contributionManager, String string) {
        this.populateContributionManager(this.serviceLocator, null, contributionManager, string, true);
    }

    @Override
    public void populateContributionManager(IServiceLocator iServiceLocator, Set set, ContributionManager contributionManager, String string, boolean bl) {
        ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)this.populatedManagers.get(contributionManager);
        if (managerPopulationRecord == null) {
            managerPopulationRecord = new ManagerPopulationRecord(iServiceLocator, set, string, bl);
            this.populatedManagers.put(contributionManager, managerPopulationRecord);
        }
        MenuLocationURI menuLocationURI = new MenuLocationURI(string);
        List list = this.getAdditionsForURI(menuLocationURI);
        this.addContributionsToManager(iServiceLocator, set, contributionManager, string, bl, list);
    }

    public void addContributionsToManager(IServiceLocator iServiceLocator, Set set, ContributionManager contributionManager, String string, boolean bl, List list) {
        Object object;
        int n;
        Object object22;
        MenuLocationURI menuLocationURI = new MenuLocationURI(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet hashSet = new HashSet();
        for (Object object22 : list) {
            if (this.processAdditions(iServiceLocator, set, contributionManager, (AbstractContributionFactory)object22, hashSet)) continue;
            arrayList.add(object22);
        }
        boolean bl2 = arrayList.size() == 0;
        while (!bl2) {
            object22 = new ArrayList(arrayList);
            n = arrayList.size();
            arrayList.clear();
            object = object22.iterator();
            while (object.hasNext()) {
                AbstractContributionFactory abstractContributionFactory = (AbstractContributionFactory)object.next();
                if (this.processAdditions(iServiceLocator, set, contributionManager, abstractContributionFactory, hashSet)) continue;
                arrayList.add(abstractContributionFactory);
            }
            boolean bl3 = bl2 = arrayList.size() == 0 || arrayList.size() == n;
        }
        object22 = contributionManager.getItems();
        n = 0;
        while (n < ((IContributionItem[])object22).length) {
            if (object22[n] instanceof ContributionManager) {
                object = object22[n].getId();
                if (object != null && ((String)object).length() > 0 && (bl || hashSet.contains(object))) {
                    this.populateContributionManager(iServiceLocator, set, (ContributionManager)object22[n], String.valueOf(menuLocationURI.getScheme()) + ":" + (String)object, true);
                }
            } else if (object22[n] instanceof IToolBarContributionItem && (object = (IToolBarContributionItem)object22[n]).getId() != null && object.getId().length() > 0 && (bl || hashSet.contains(object.getId()))) {
                this.populateContributionManager(iServiceLocator, set, (ContributionManager)object.getToolBarManager(), String.valueOf(menuLocationURI.getScheme()) + ":" + object.getId(), true);
            }
            ++n;
        }
    }

    private int getInsertionIndex(ContributionManager contributionManager, String string) {
        MenuLocationURI menuLocationURI = new MenuLocationURI(string);
        String string2 = menuLocationURI.getQuery();
        int n = -1;
        if (string2.length() == 0 || string2.equals(INDEX_AFTER_ADDITIONS)) {
            n = contributionManager.indexOf("additions");
            n = n == -1 ? contributionManager.getItems().length : ++n;
        } else {
            String[] stringArray = Util.split(string2, '=');
            if (stringArray.length > 1 && stringArray[1].length() > 0) {
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                n = contributionManager.indexOf(string4);
                if (n != -1 && !"before".equals(string3)) {
                    if ("after".equals(string3)) {
                        ++n;
                    } else if ("endof".equals(string3)) {
                        IContributionItem[] iContributionItemArray = contributionManager.getItems();
                        ++n;
                        while (n < iContributionItemArray.length) {
                            if (iContributionItemArray[n].isGroupMarker()) break;
                            ++n;
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return this.evaluationService.getCurrentState();
    }

    @Override
    public void registerVisibleWhen(IContributionItem iContributionItem, Expression expression, Set set, String string) {
        if (iContributionItem == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("visibleWhen expression cannot be null");
        }
        if (this.evaluationsByItem.get(iContributionItem) != null) {
            String string2 = iContributionItem.getId();
            WorkbenchPlugin.log("item is already registered: " + (string2 == null ? "no id" : string2));
            return;
        }
        IIdentifier iIdentifier = null;
        if (string != null) {
            iIdentifier = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getIdentifier(string);
        }
        ContributionItemUpdater contributionItemUpdater = new ContributionItemUpdater(iContributionItem, iIdentifier);
        if (expression != AlwaysEnabledExpression.INSTANCE) {
            IEvaluationReference iEvaluationReference = this.evaluationService.addEvaluationListener(expression, contributionItemUpdater, PROP_VISIBLE);
            if (set != null) {
                set.add(iEvaluationReference);
            }
            this.evaluationsByItem.put(iContributionItem, iEvaluationReference);
        }
        this.activityListenersByItem.put(iContributionItem, contributionItemUpdater);
    }

    @Override
    public void unregisterVisibleWhen(IContributionItem iContributionItem, Set set) {
        IEvaluationReference iEvaluationReference;
        ContributionItemUpdater contributionItemUpdater = (ContributionItemUpdater)this.activityListenersByItem.remove(iContributionItem);
        if (contributionItemUpdater != null) {
            contributionItemUpdater.dispose();
        }
        if ((iEvaluationReference = (IEvaluationReference)this.evaluationsByItem.remove(iContributionItem)) == null) {
            return;
        }
        this.evaluationService.removeEvaluationListener(iEvaluationReference);
        if (set != null) {
            set.remove(iEvaluationReference);
        }
    }

    protected void releaseContributions(ContributionRoot contributionRoot) {
        ContributionManager contributionManager = contributionRoot.getManager();
        for (IContributionItem iContributionItem : contributionRoot.getItems()) {
            this.releaseItem(iContributionItem, contributionRoot.restriction);
            contributionManager.remove(iContributionItem);
        }
        this.releaseCache(contributionRoot);
    }

    @Override
    public void releaseContributions(ContributionManager contributionManager) {
        if (contributionManager == null) {
            return;
        }
        IContributionItem[] iContributionItemArray = contributionManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (iContributionItemArray[n] instanceof ContributionManager) {
                this.releaseContributions((ContributionManager)iContributionItemArray[n]);
            } else if (iContributionItemArray[n] instanceof IToolBarContributionItem) {
                IToolBarContributionItem iToolBarContributionItem = (IToolBarContributionItem)iContributionItemArray[n];
                this.releaseContributions((ContributionManager)iToolBarContributionItem.getToolBarManager());
            }
            ++n;
        }
        ManagerPopulationRecord managerPopulationRecord = (ManagerPopulationRecord)this.populatedManagers.remove(contributionManager);
        if (managerPopulationRecord != null) {
            managerPopulationRecord.releaseContributions();
        }
        this.managersAwaitingUpdates.remove(contributionManager);
    }

    private void releaseItem(IContributionItem iContributionItem, Set set) {
        this.unregisterVisibleWhen(iContributionItem, set);
        if (iContributionItem instanceof ContributionManager) {
            this.releaseContributions((ContributionManager)iContributionItem);
        } else if (iContributionItem instanceof IToolBarContributionItem) {
            IToolBarContributionItem iToolBarContributionItem = (IToolBarContributionItem)iContributionItem;
            this.releaseContributions((ContributionManager)iToolBarContributionItem.getToolBarManager());
        }
    }

    public void handleDynamicAdditions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractMenuAdditionCacheEntry abstractMenuAdditionCacheEntry = null;
            IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator.next();
            abstractMenuAdditionCacheEntry = this.isProgramaticContribution(iConfigurationElement) ? new ProxyMenuAdditionCacheEntry(iConfigurationElement.getAttribute("locationURI"), iConfigurationElement.getNamespaceIdentifier(), iConfigurationElement) : new MenuAdditionCacheEntry(this, iConfigurationElement, iConfigurationElement.getAttribute("locationURI"), iConfigurationElement.getNamespaceIdentifier());
            if (abstractMenuAdditionCacheEntry == null) continue;
            this.addContributionFactory(abstractMenuAdditionCacheEntry);
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("class") != null;
    }

    public void handleDynamicRemovals(List list) {
        for (IConfigurationElement iConfigurationElement : list) {
            AbstractMenuAdditionCacheEntry abstractMenuAdditionCacheEntry = this.findFactory(iConfigurationElement);
            this.removeContributionFactory(abstractMenuAdditionCacheEntry);
        }
    }

    private AbstractMenuAdditionCacheEntry findFactory(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("locationURI");
        MenuLocationURI menuLocationURI = new MenuLocationURI(string);
        List list = this.getAdditionsForURI(menuLocationURI);
        for (AbstractContributionFactory abstractContributionFactory : list) {
            AbstractMenuAdditionCacheEntry abstractMenuAdditionCacheEntry;
            if (!(abstractContributionFactory instanceof AbstractMenuAdditionCacheEntry) || !(abstractMenuAdditionCacheEntry = (AbstractMenuAdditionCacheEntry)abstractContributionFactory).getConfigElement().equals((Object)iConfigurationElement)) continue;
            return abstractMenuAdditionCacheEntry;
        }
        return null;
    }

    private void handleMenuChanges(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "menus");
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> arrayList2 = new ArrayList<IConfigurationElement>();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if ("menuContribution".equals(iConfigurationElementArray[n2].getName())) {
                    if (iExtensionDeltaArray[n].getKind() == 1) {
                        arrayList.add(iConfigurationElementArray[n2]);
                    } else {
                        arrayList2.add(iConfigurationElementArray[n2]);
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.handleDynamicAdditions(arrayList);
        }
        if (arrayList2.size() > 0) {
            this.handleDynamicRemovals(arrayList2);
        }
    }

    public void handleRegistryChanges(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta iExtensionDelta;
        int n;
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas();
        if (iExtensionDeltaArray2.length == 0) {
            return;
        }
        boolean bl = iExtensionDeltaArray2[0].getKind() == 1;
        HandlerService handlerService = (HandlerService)this.serviceLocator.getService(IHandlerService.class);
        HandlerPersistence handlerPersistence = handlerService.getHandlerPersistence();
        CommandService commandService = (CommandService)this.serviceLocator.getService(ICommandService.class);
        CommandPersistence commandPersistence = commandService.getCommandPersistence();
        BindingService bindingService = (BindingService)this.serviceLocator.getService(IBindingService.class);
        BindingPersistence bindingPersistence = bindingService.getBindingPersistence();
        boolean bl2 = false;
        if (bl) {
            if (commandPersistence.commandsNeedUpdating(iRegistryChangeEvent)) {
                commandPersistence.reRead();
                bl2 = true;
            }
            if (handlerPersistence.handlersNeedUpdating(iRegistryChangeEvent)) {
                handlerPersistence.reRead();
                bl2 = true;
            }
            if (bindingPersistence.bindingsNeedUpdating(iRegistryChangeEvent)) {
                bindingPersistence.reRead();
                bl2 = true;
            }
            if (this.menuPersistence.menusNeedUpdating(iRegistryChangeEvent)) {
                this.handleMenuChanges(iRegistryChangeEvent);
                bl2 = true;
            }
        } else {
            if (this.menuPersistence.menusNeedUpdating(iRegistryChangeEvent)) {
                this.handleMenuChanges(iRegistryChangeEvent);
                bl2 = true;
            }
            if (bindingPersistence.bindingsNeedUpdating(iRegistryChangeEvent)) {
                bindingPersistence.reRead();
                bl2 = true;
            }
            if (handlerPersistence.handlersNeedUpdating(iRegistryChangeEvent)) {
                iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "handlers");
                n = 0;
                while (n < iExtensionDeltaArray.length) {
                    iExtensionDelta = iExtensionDeltaArray[n].getExtension().getConfigurationElements();
                    HandlerProxy.updateStaleCEs((IConfigurationElement[])iExtensionDelta);
                    ++n;
                }
                handlerPersistence.reRead();
                bl2 = true;
            }
            if (commandPersistence.commandsNeedUpdating(iRegistryChangeEvent)) {
                commandPersistence.reRead();
                bl2 = true;
            }
        }
        if (bl2) {
            iExtensionDeltaArray = this.populatedManagers.keySet().toArray(new ContributionManager[this.populatedManagers.keySet().size()]);
            n = 0;
            while (n < iExtensionDeltaArray.length) {
                iExtensionDelta = iExtensionDeltaArray[n];
                iExtensionDelta.update(false);
                ++n;
            }
        }
    }

    public MenuPersistence getMenuPersistence() {
        return this.menuPersistence;
    }

    @Override
    public void populateContributionManager(ContributionManager contributionManager, String string, boolean bl) {
        this.populateContributionManager(this.serviceLocator, null, contributionManager, string, bl);
    }

    private final class ContributionItemUpdater
    implements IPropertyChangeListener,
    IIdentifierListener {
        private final IContributionItem item;
        private IIdentifier identifier;
        private boolean lastExpressionResult = true;

        private ContributionItemUpdater(IContributionItem iContributionItem, IIdentifier iIdentifier) {
            this.item = iContributionItem;
            if (iIdentifier != null) {
                this.identifier = iIdentifier;
                this.identifier.addIdentifierListener(this);
                this.updateVisibility();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty() == WorkbenchMenuService.PROP_VISIBLE) {
                this.lastExpressionResult = propertyChangeEvent.getNewValue() != null ? (Boolean)propertyChangeEvent.getNewValue() : false;
                this.updateVisibility();
            }
        }

        private void updateVisibility() {
            boolean bl = this.identifier != null ? this.identifier.isEnabled() && this.lastExpressionResult : this.lastExpressionResult;
            this.item.setVisible(bl);
            IContributionManager iContributionManager = null;
            if (this.item instanceof ContributionItem) {
                iContributionManager = ((ContributionItem)this.item).getParent();
            } else if (this.item instanceof MenuManager) {
                iContributionManager = ((MenuManager)this.item).getParent();
            }
            if (iContributionManager != null) {
                iContributionManager.markDirty();
                WorkbenchMenuService.this.managersAwaitingUpdates.add(iContributionManager);
            }
        }

        @Override
        public void identifierChanged(IdentifierEvent identifierEvent) {
            this.updateVisibility();
        }

        public void dispose() {
            if (this.identifier != null) {
                this.identifier.removeIdentifierListener(this);
            }
        }
    }

    private final class ManagerPopulationRecord {
        public IServiceLocator serviceLocatorToUse;
        public Set restriction;
        public String uri;
        public boolean recurse;
        Map factoryToItems = new HashMap();

        public ManagerPopulationRecord(IServiceLocator iServiceLocator, Set set, String string, boolean bl) {
            this.serviceLocatorToUse = iServiceLocator;
            this.restriction = set;
            this.uri = string;
            this.recurse = bl;
        }

        public void addFactoryContribution(AbstractContributionFactory abstractContributionFactory, ContributionRoot contributionRoot) {
            this.removeFactoryContribution(abstractContributionFactory);
            this.factoryToItems.put(abstractContributionFactory, contributionRoot);
        }

        public void removeFactoryContribution(AbstractContributionFactory abstractContributionFactory) {
            ContributionRoot contributionRoot = (ContributionRoot)this.factoryToItems.remove(abstractContributionFactory);
            if (contributionRoot != null) {
                WorkbenchMenuService.this.releaseContributions(contributionRoot);
            }
        }

        public ContributionRoot getContributions(AbstractContributionFactory abstractContributionFactory) {
            return (ContributionRoot)this.factoryToItems.get(abstractContributionFactory);
        }

        public void releaseContributions() {
            Collection collection = this.factoryToItems.values();
            for (ContributionRoot contributionRoot : collection) {
                WorkbenchMenuService.this.releaseContributions(contributionRoot);
            }
            this.factoryToItems.clear();
        }
    }
}

