/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;
import org.eclipse.ui.menus.IWorkbenchWidget;

final class WidgetProxy
implements IWorkbenchWidget {
    private boolean firstLoad = true;
    private IConfigurationElement configurationElement;
    private IWorkbenchWidget widget = null;
    private final String widgetAttributeName;

    public WidgetProxy(IConfigurationElement iConfigurationElement, String string) {
        if (iConfigurationElement == null) {
            throw new NullPointerException("The configuration element backing a widget proxy cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("The attribute containing the widget class must be known");
        }
        this.configurationElement = iConfigurationElement;
        this.widgetAttributeName = string;
    }

    public final void dispose() {
        if (this.loadWidget()) {
            this.widget.dispose();
        }
    }

    public final void fill(Composite composite) {
        if (this.loadWidget()) {
            this.widget.fill(composite);
        }
    }

    public final void fill(CoolBar coolBar, int n) {
        if (this.loadWidget()) {
            this.widget.fill(coolBar, n);
        }
    }

    public final void fill(Menu menu, int n) {
        if (this.loadWidget()) {
            this.widget.fill(menu, n);
        }
    }

    public final void fill(ToolBar toolBar, int n) {
        if (this.loadWidget()) {
            this.widget.fill(toolBar, n);
        }
    }

    @Override
    public void init(IWorkbenchWindow iWorkbenchWindow) {
        if (this.loadWidget()) {
            this.widget.init(iWorkbenchWindow);
        }
    }

    public final void fill(Composite composite, int n, int n2) {
        if (this.loadWidget()) {
            if (this.isMoveableTrimWidget()) {
                ((AbstractWorkbenchTrimWidget)this.widget).fill(composite, n, n2);
            } else {
                this.widget.fill(composite);
            }
        }
    }

    private final boolean loadWidget() {
        if (this.firstLoad) {
            try {
                this.widget = (IWorkbenchWidget)this.configurationElement.createExecutableExtension(this.widgetAttributeName);
                this.configurationElement = null;
            }
            catch (ClassCastException classCastException) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied widget was the wrong class", (Throwable)classCastException);
                WorkbenchPlugin.log("The proxied widget was the wrong class", (IStatus)status);
            }
            catch (CoreException coreException) {
                String string = "The proxied widget for '" + this.configurationElement.getAttribute(this.widgetAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, (Throwable)coreException);
                WorkbenchPlugin.log(string, (IStatus)status);
            }
        }
        this.firstLoad = false;
        return this.widget != null;
    }

    private final boolean isMoveableTrimWidget() {
        if (this.loadWidget()) {
            return this.widget instanceof AbstractWorkbenchTrimWidget;
        }
        return false;
    }

    public final String toString() {
        if (this.widget == null) {
            return this.configurationElement.getAttribute(this.widgetAttributeName);
        }
        return this.widget.toString();
    }
}

