/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.menus.ContributionRoot;
import org.eclipse.ui.internal.menus.InternalControlContribution;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;

public class TrimContributionManager
extends ContributionManager {
    private String[] trimAreaURIs = new String[]{"toolbar:org.eclipse.ui.trim.command1", "toolbar:org.eclipse.ui.trim.command2", "toolbar:org.eclipse.ui.trim.vertical1", "toolbar:org.eclipse.ui.trim.vertical2", "toolbar:org.eclipse.ui.trim.status"};
    private int[] swtSides = new int[]{128, 128, 16384, 131072, 1024};
    private WorkbenchWindow wbWindow;
    TrimLayout layout;
    private InternalMenuService menuService;
    List contributedTrim = new ArrayList();
    List contributedLists = new ArrayList();
    private Set restrictionExpression;

    public TrimContributionManager(WorkbenchWindow workbenchWindow) {
        this.wbWindow = workbenchWindow;
        this.layout = (TrimLayout)this.wbWindow.getShell().getLayout();
        this.menuService = (InternalMenuService)workbenchWindow.getService(IMenuService.class);
        this.restrictionExpression = this.wbWindow.getMenuRestrictions();
    }

    public void update(boolean bl) {
        this.update(bl, false);
    }

    public void update(boolean bl, boolean bl2) {
        this.teardown();
        int n = 0;
        while (n < this.trimAreaURIs.length) {
            if (!bl2 || this.swtSides[n] != 128) {
                List list = this.menuService.getAdditionsForURI(new MenuLocationURI(this.trimAreaURIs[n]));
                for (AbstractContributionFactory abstractContributionFactory : list) {
                    Object object;
                    ContributionRoot contributionRoot = new ContributionRoot(this.menuService, this.restrictionExpression, this, abstractContributionFactory);
                    abstractContributionFactory.createContributionItems(this.wbWindow, contributionRoot);
                    IWindowTrim iWindowTrim = null;
                    MenuLocationURI menuLocationURI = new MenuLocationURI(abstractContributionFactory.getLocation());
                    String string = menuLocationURI.getQuery();
                    String[] stringArray = Util.split(string, '=');
                    if (stringArray.length == 2) {
                        String string2 = stringArray[0];
                        String string3 = stringArray[1];
                        iWindowTrim = this.layout.getTrim(string3);
                        if ("after".equals(string2) && iWindowTrim != null) {
                            object = this.layout.getAreaTrim(this.swtSides[n]);
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                IWindowTrim iWindowTrim2 = (IWindowTrim)iterator.next();
                                if (iWindowTrim != iWindowTrim2) continue;
                                iWindowTrim = iterator.hasNext() ? iterator.next() : null;
                            }
                        }
                    }
                    if (iWindowTrim == null && n == 0) {
                        iWindowTrim = this.layout.getTrim("org.eclipse.ui.internal.WorkbenchWindow.topBar");
                    }
                    this.contributedLists.add(contributionRoot);
                    for (String string3 : contributionRoot.getItems()) {
                        if (!(string3 instanceof IToolBarContributionItem)) continue;
                        object = new ToolBarTrimProxy(string3.getId(), this.wbWindow);
                        ((ToolBarTrimProxy)object).dock(this.swtSides[n]);
                        this.layout.addTrim(this.swtSides[n], (IWindowTrim)object, iWindowTrim);
                        this.contributedTrim.add(object);
                    }
                }
            }
            ++n;
        }
    }

    private void teardown() {
        for (Object object : this.contributedTrim) {
            this.layout.removeTrim((IWindowTrim)object);
            try {
                ((ToolBarTrimProxy)object).dispose();
            }
            catch (Throwable throwable) {
                IStatus iStatus = null;
                iStatus = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : StatusUtil.newStatus(4, "Internal plug-in widget delegate error on dispose.", throwable);
                StatusUtil.handleStatus(iStatus, "widget delegate failed on dispose: id = " + ((ToolBarTrimProxy)object).getId(), 1);
            }
        }
        this.contributedTrim.clear();
        for (Object object : this.contributedLists) {
            ((ContributionRoot)object).release();
        }
        this.contributedLists.clear();
    }

    public void dispose() {
        this.teardown();
    }

    public void updateLocations(List list) {
    }

    private class ToolBarTrimProxy
    implements IWindowTrim {
        private String id;
        private String uriSpec;
        private WorkbenchMenuService menuService;
        private WorkbenchWindow wbw;
        private ToolBar tb = null;
        private ToolBarManager tbm = null;

        ToolBarTrimProxy(String string, WorkbenchWindow workbenchWindow) {
            this.id = string;
            this.uriSpec = "toolbar:" + string;
            this.wbw = workbenchWindow;
            this.menuService = (WorkbenchMenuService)workbenchWindow.getWorkbench().getService(IMenuService.class);
        }

        @Override
        public void dock(int n) {
            this.dispose();
            int n2 = 256;
            if (n == 16384 || n == 131072) {
                n2 = 512;
            }
            this.tbm = new ToolBarManager(0x800000 | n2);
            this.menuService.populateContributionManager(this.wbw, TrimContributionManager.this.restrictionExpression, (ContributionManager)this.tbm, this.uriSpec, true);
            IContributionItem[] iContributionItemArray = this.tbm.getItems();
            int n3 = 0;
            while (n3 < iContributionItemArray.length) {
                if (iContributionItemArray[n3] instanceof InternalControlContribution) {
                    InternalControlContribution internalControlContribution = (InternalControlContribution)iContributionItemArray[n3];
                    internalControlContribution.setWorkbenchWindow(this.wbw);
                    internalControlContribution.setCurSide(n);
                }
                ++n3;
            }
            this.tb = this.tbm.createControl((Composite)this.wbw.getShell());
        }

        @Override
        public Control getControl() {
            return this.tb;
        }

        @Override
        public String getDisplayName() {
            return this.getId();
        }

        @Override
        public int getHeightHint() {
            return -1;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getValidSides() {
            return 148608;
        }

        @Override
        public int getWidthHint() {
            return -1;
        }

        @Override
        public void handleClose() {
        }

        @Override
        public boolean isCloseable() {
            return false;
        }

        @Override
        public boolean isResizeable() {
            return false;
        }

        public void dispose() {
            if (this.tbm != null) {
                this.tbm.dispose();
                this.tbm.removeAll();
            }
        }
    }
}

