/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.TrimAdditionCacheEntry;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchWidget;

public class TrimBarManager2 {
    private MenuLocationURI[] trimAreaURIs = new MenuLocationURI[]{new MenuLocationURI("toolbar:command1"), new MenuLocationURI("toolbar:command2"), new MenuLocationURI("toolbar:vertical1"), new MenuLocationURI("toolbar:vertical2"), new MenuLocationURI("toolbar:status")};
    int[] swtSides = new int[]{128, 128, 16384, 131072, 1024};
    private STrimBuilder fTrimBuilder;
    private WorkbenchMenuService fMenuService;
    private boolean fDirty;

    public TrimBarManager2(WorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            throw new IllegalArgumentException("The window cannot be null");
        }
        this.fMenuService = (WorkbenchMenuService)workbenchWindow.getWorkbench().getService(IMenuService.class);
        this.fTrimBuilder = new STrimBuilder(workbenchWindow);
        this.fDirty = true;
    }

    public void update(boolean bl, boolean bl2, boolean bl3) {
        if (bl || this.isDirty()) {
            this.fTrimBuilder.build(bl3);
            this.setDirty(false);
        }
    }

    public void update(boolean bl, boolean bl2) {
        this.update(bl, bl2, false);
    }

    private void setDirty(boolean bl) {
        this.fDirty = bl;
    }

    private boolean isDirty() {
        return this.fDirty;
    }

    public void updateLocations(List list) {
        this.fTrimBuilder.updateLocations(list);
    }

    public void dispose() {
        this.fMenuService = null;
        this.fTrimBuilder = null;
    }

    private class STrimBuilder {
        private WorkbenchWindow fWindow;
        private List curGroups = new ArrayList();
        private Map initializedTrim = new HashMap();

        public STrimBuilder(WorkbenchWindow workbenchWindow) {
            this.fWindow = workbenchWindow;
        }

        public void tearDown() {
            for (TrimWidgetProxy trimWidgetProxy : this.curGroups) {
                this.fWindow.getTrimManager().removeTrim(trimWidgetProxy);
                try {
                    trimWidgetProxy.dispose();
                }
                catch (Throwable throwable) {
                    IStatus iStatus = null;
                    iStatus = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : StatusUtil.newStatus(4, "Internal plug-in widget delegate error on dispose.", throwable);
                    StatusUtil.handleStatus(iStatus, "widget delegate failed on dispose: id = " + trimWidgetProxy.getId(), 1);
                }
            }
            this.curGroups.clear();
        }

        public void build(boolean bl) {
            this.tearDown();
            int n = 0;
            while (n < TrimBarManager2.this.trimAreaURIs.length) {
                this.processAdditions(TrimBarManager2.this.trimAreaURIs[n], bl);
                ++n;
            }
        }

        private void processAdditions(MenuLocationURI menuLocationURI, boolean bl) {
            List list = TrimBarManager2.this.fMenuService.getAdditionsForURI(menuLocationURI);
            if (list.size() == 0) {
                return;
            }
            int n = this.getSide(menuLocationURI);
            if (n == 128 && bl) {
                return;
            }
            for (TrimAdditionCacheEntry trimAdditionCacheEntry : list) {
                String string = trimAdditionCacheEntry.getId();
                List list2 = trimAdditionCacheEntry.getWidgets();
                if (list2.size() == 0) continue;
                Composite composite = new Composite((Composite)this.fWindow.getShell(), 0);
                composite.setToolTipText(string);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginWidth = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginLeft = 0;
                rowLayout.marginHeight = 0;
                rowLayout.marginBottom = 0;
                composite.setLayout((Layout)rowLayout);
                boolean bl2 = false;
                for (IWorkbenchWidget iWorkbenchWidget : list2) {
                    IConfigurationElement iConfigurationElement = trimAdditionCacheEntry.getElement(iWorkbenchWidget);
                    if (iWorkbenchWidget == null) continue;
                    bl2 |= trimAdditionCacheEntry.fillMajor(iConfigurationElement);
                    this.renderTrim(composite, iWorkbenchWidget, n);
                }
                TrimWidgetProxy trimWidgetProxy = new TrimWidgetProxy(list2, n, composite, trimAdditionCacheEntry, bl2);
                this.curGroups.add(trimWidgetProxy);
                this.placeGroup(trimWidgetProxy);
            }
        }

        private void placeGroup(TrimWidgetProxy trimWidgetProxy) {
            Object object;
            int n = trimWidgetProxy.getSide();
            boolean bl = trimWidgetProxy.isAtStart();
            IWindowTrim iWindowTrim = null;
            if (bl && (object = this.fWindow.getTrimManager().getAreaTrim(n)).size() > 0) {
                iWindowTrim = (IWindowTrim)object.get(0);
            }
            try {
                trimWidgetProxy.dock(n);
                object = (TrimLayout)this.fWindow.getShell().getLayout();
                ((TrimLayout)object).addTrim(n, trimWidgetProxy, iWindowTrim);
            }
            catch (Throwable throwable) {
                IStatus iStatus = null;
                iStatus = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : StatusUtil.newStatus(4, "Internal plug-in widget delegate error on dock.", throwable);
                StatusUtil.handleStatus(iStatus, "widget delegate failed on dock: id = " + trimWidgetProxy.getId(), 1);
            }
        }

        private void renderTrim(Composite composite, IWidget iWidget, int n) {
            if (iWidget != null) {
                if (iWidget instanceof IWorkbenchWidget && this.initializedTrim.get(iWidget) == null) {
                    IWorkbenchWidget iWorkbenchWidget = (IWorkbenchWidget)iWidget;
                    iWorkbenchWidget.init(this.fWindow);
                    this.initializedTrim.put(iWidget, iWidget);
                }
                if (iWidget instanceof AbstractWorkbenchTrimWidget) {
                    ((AbstractWorkbenchTrimWidget)iWidget).fill(composite, -1, n);
                } else {
                    iWidget.fill(composite);
                }
            }
        }

        private int getSide(MenuLocationURI menuLocationURI) {
            int n = 0;
            while (n < TrimBarManager2.this.trimAreaURIs.length) {
                if (TrimBarManager2.this.trimAreaURIs[n].getRawString().equals(menuLocationURI.getRawString())) {
                    return TrimBarManager2.this.swtSides[n];
                }
                ++n;
            }
            return 1024;
        }

        public void updateLocations(List list) {
            for (TrimWidgetProxy trimWidgetProxy : this.curGroups) {
                if (list.contains(trimWidgetProxy.getId())) continue;
                this.placeGroup(trimWidgetProxy);
            }
        }
    }

    private class TrimWidgetProxy
    extends WindowTrimProxy {
        private List widgets;
        private TrimAdditionCacheEntry cacheEntry;
        private int originalSide;
        private int curSide;
        private Composite parent;

        public TrimWidgetProxy(List list, int n, Composite composite, TrimAdditionCacheEntry trimAdditionCacheEntry, boolean bl) {
            super((Control)composite, trimAdditionCacheEntry.getId(), trimAdditionCacheEntry.getId(), 148608, bl);
            this.widgets = list;
            this.curSide = n;
            this.originalSide = n;
            this.parent = composite;
            this.cacheEntry = trimAdditionCacheEntry;
        }

        @Override
        public void dock(int n) {
            for (IWidget iWidget : this.widgets) {
                iWidget.dispose();
                this.cacheEntry.removeWidget(iWidget);
            }
            for (IWidget iWidget : this.widgets) {
                if (iWidget instanceof AbstractWorkbenchTrimWidget) {
                    ((AbstractWorkbenchTrimWidget)iWidget).fill(this.parent, this.curSide, n);
                    continue;
                }
                iWidget.fill(this.parent);
            }
            this.curSide = n;
            this.parent.layout();
        }

        public void dispose() {
            for (IWidget iWidget : this.widgets) {
                iWidget.dispose();
                this.cacheEntry.removeWidget(iWidget);
            }
            this.getControl().dispose();
        }

        public int getSide() {
            return this.originalSide;
        }

        public boolean isAtStart() {
            return this.cacheEntry.isAtStart();
        }
    }
}

